/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSimulationJobBatchesRequest extends RoboMakerRequest implements
        ToCopyableBuilder<ListSimulationJobBatchesRequest.Builder, ListSimulationJobBatchesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSimulationJobBatchesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSimulationJobBatchesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListSimulationJobBatchesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private ListSimulationJobBatchesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code>
     * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListSimulationJobBatches</code> again and assign that token to the request object's
     *         <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
     *         NextToken parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results
     * in a single page along with a <code>nextToken</code> response element. The remaining results of the initial
     * request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned
     * <code>nextToken</code> value.
     * </p>
     * 
     * @return When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code>
     *         results in a single page along with a <code>nextToken</code> response element. The remaining results of
     *         the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the
     *         returned <code>nextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional filters to limit results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional filters to limit results.
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationJobBatchesRequest)) {
            return false;
        }
        ListSimulationJobBatchesRequest other = (ListSimulationJobBatchesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSimulationJobBatchesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationJobBatchesRequest, T> g) {
        return obj -> g.apply((ListSimulationJobBatchesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSimulationJobBatchesRequest> {
        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>ListSimulationJobBatches</code> again and assign that token to the request object's
         * <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken
         * parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListSimulationJobBatches</code> again and assign that token to the request object's
         *        <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
         *        NextToken parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code>
         * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
         * initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the
         * returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        When this parameter is used, <code>ListSimulationJobBatches</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Optional filters to limit results.
         * </p>
         * 
         * @param filters
         *        Optional filters to limit results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Optional filters to limit results.
         * </p>
         * 
         * @param filters
         *        Optional filters to limit results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Optional filters to limit results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationJobBatchesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSimulationJobBatchesRequest build() {
            return new ListSimulationJobBatchesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
