/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the progress of a deployment job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgressDetail implements SdkPojo, Serializable, ToCopyableBuilder<ProgressDetail.Builder, ProgressDetail> {
    private static final SdkField<String> CURRENT_PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentProgress").getter(getter(ProgressDetail::currentProgressAsString))
            .setter(setter(Builder::currentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentProgress").build()).build();

    private static final SdkField<Float> PERCENT_DONE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("percentDone").getter(getter(ProgressDetail::percentDone)).setter(setter(Builder::percentDone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentDone").build()).build();

    private static final SdkField<Integer> ESTIMATED_TIME_REMAINING_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("estimatedTimeRemainingSeconds")
            .getter(getter(ProgressDetail::estimatedTimeRemainingSeconds))
            .setter(setter(Builder::estimatedTimeRemainingSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedTimeRemainingSeconds")
                    .build()).build();

    private static final SdkField<String> TARGET_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResource").getter(getter(ProgressDetail::targetResource)).setter(setter(Builder::targetResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PROGRESS_FIELD,
            PERCENT_DONE_FIELD, ESTIMATED_TIME_REMAINING_SECONDS_FIELD, TARGET_RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currentProgress;

    private final Float percentDone;

    private final Integer estimatedTimeRemainingSeconds;

    private final String targetResource;

    private ProgressDetail(BuilderImpl builder) {
        this.currentProgress = builder.currentProgress;
        this.percentDone = builder.percentDone;
        this.estimatedTimeRemainingSeconds = builder.estimatedTimeRemainingSeconds;
        this.targetResource = builder.targetResource;
    }

    /**
     * <p>
     * The current progress status.
     * </p>
     * <dl>
     * <dt>Validating</dt>
     * <dd>
     * <p>
     * Validating the deployment.
     * </p>
     * </dd>
     * <dt>DownloadingExtracting</dt>
     * <dd>
     * <p>
     * Downloading and extracting the bundle on the robot.
     * </p>
     * </dd>
     * <dt>ExecutingPreLaunch</dt>
     * <dd>
     * <p>
     * Executing pre-launch script(s) if provided.
     * </p>
     * </dd>
     * <dt>Launching</dt>
     * <dd>
     * <p>
     * Launching the robot application.
     * </p>
     * </dd>
     * <dt>ExecutingPostLaunch</dt>
     * <dd>
     * <p>
     * Executing post-launch script(s) if provided.
     * </p>
     * </dd>
     * <dt>Finished</dt>
     * <dd>
     * <p>
     * Deployment is complete.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentProgress}
     * will return {@link RobotDeploymentStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #currentProgressAsString}.
     * </p>
     * 
     * @return The current progress status.</p>
     *         <dl>
     *         <dt>Validating</dt>
     *         <dd>
     *         <p>
     *         Validating the deployment.
     *         </p>
     *         </dd>
     *         <dt>DownloadingExtracting</dt>
     *         <dd>
     *         <p>
     *         Downloading and extracting the bundle on the robot.
     *         </p>
     *         </dd>
     *         <dt>ExecutingPreLaunch</dt>
     *         <dd>
     *         <p>
     *         Executing pre-launch script(s) if provided.
     *         </p>
     *         </dd>
     *         <dt>Launching</dt>
     *         <dd>
     *         <p>
     *         Launching the robot application.
     *         </p>
     *         </dd>
     *         <dt>ExecutingPostLaunch</dt>
     *         <dd>
     *         <p>
     *         Executing post-launch script(s) if provided.
     *         </p>
     *         </dd>
     *         <dt>Finished</dt>
     *         <dd>
     *         <p>
     *         Deployment is complete.
     *         </p>
     *         </dd>
     * @see RobotDeploymentStep
     */
    public RobotDeploymentStep currentProgress() {
        return RobotDeploymentStep.fromValue(currentProgress);
    }

    /**
     * <p>
     * The current progress status.
     * </p>
     * <dl>
     * <dt>Validating</dt>
     * <dd>
     * <p>
     * Validating the deployment.
     * </p>
     * </dd>
     * <dt>DownloadingExtracting</dt>
     * <dd>
     * <p>
     * Downloading and extracting the bundle on the robot.
     * </p>
     * </dd>
     * <dt>ExecutingPreLaunch</dt>
     * <dd>
     * <p>
     * Executing pre-launch script(s) if provided.
     * </p>
     * </dd>
     * <dt>Launching</dt>
     * <dd>
     * <p>
     * Launching the robot application.
     * </p>
     * </dd>
     * <dt>ExecutingPostLaunch</dt>
     * <dd>
     * <p>
     * Executing post-launch script(s) if provided.
     * </p>
     * </dd>
     * <dt>Finished</dt>
     * <dd>
     * <p>
     * Deployment is complete.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentProgress}
     * will return {@link RobotDeploymentStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #currentProgressAsString}.
     * </p>
     * 
     * @return The current progress status.</p>
     *         <dl>
     *         <dt>Validating</dt>
     *         <dd>
     *         <p>
     *         Validating the deployment.
     *         </p>
     *         </dd>
     *         <dt>DownloadingExtracting</dt>
     *         <dd>
     *         <p>
     *         Downloading and extracting the bundle on the robot.
     *         </p>
     *         </dd>
     *         <dt>ExecutingPreLaunch</dt>
     *         <dd>
     *         <p>
     *         Executing pre-launch script(s) if provided.
     *         </p>
     *         </dd>
     *         <dt>Launching</dt>
     *         <dd>
     *         <p>
     *         Launching the robot application.
     *         </p>
     *         </dd>
     *         <dt>ExecutingPostLaunch</dt>
     *         <dd>
     *         <p>
     *         Executing post-launch script(s) if provided.
     *         </p>
     *         </dd>
     *         <dt>Finished</dt>
     *         <dd>
     *         <p>
     *         Deployment is complete.
     *         </p>
     *         </dd>
     * @see RobotDeploymentStep
     */
    public String currentProgressAsString() {
        return currentProgress;
    }

    /**
     * <p>
     * Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step
     * of the deployment. It is empty for other steps.
     * </p>
     * 
     * @return Precentage of the step that is done. This currently only applies to the
     *         <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
     */
    public Float percentDone() {
        return percentDone;
    }

    /**
     * <p>
     * Estimated amount of time in seconds remaining in the step. This currently only applies to the
     * <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
     * </p>
     * 
     * @return Estimated amount of time in seconds remaining in the step. This currently only applies to the
     *         <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
     */
    public Integer estimatedTimeRemainingSeconds() {
        return estimatedTimeRemainingSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deployment job.
     */
    public String targetResource() {
        return targetResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentProgressAsString());
        hashCode = 31 * hashCode + Objects.hashCode(percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeRemainingSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressDetail)) {
            return false;
        }
        ProgressDetail other = (ProgressDetail) obj;
        return Objects.equals(currentProgressAsString(), other.currentProgressAsString())
                && Objects.equals(percentDone(), other.percentDone())
                && Objects.equals(estimatedTimeRemainingSeconds(), other.estimatedTimeRemainingSeconds())
                && Objects.equals(targetResource(), other.targetResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProgressDetail").add("CurrentProgress", currentProgressAsString())
                .add("PercentDone", percentDone()).add("EstimatedTimeRemainingSeconds", estimatedTimeRemainingSeconds())
                .add("TargetResource", targetResource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currentProgress":
            return Optional.ofNullable(clazz.cast(currentProgressAsString()));
        case "percentDone":
            return Optional.ofNullable(clazz.cast(percentDone()));
        case "estimatedTimeRemainingSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeRemainingSeconds()));
        case "targetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressDetail, T> g) {
        return obj -> g.apply((ProgressDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgressDetail> {
        /**
         * <p>
         * The current progress status.
         * </p>
         * <dl>
         * <dt>Validating</dt>
         * <dd>
         * <p>
         * Validating the deployment.
         * </p>
         * </dd>
         * <dt>DownloadingExtracting</dt>
         * <dd>
         * <p>
         * Downloading and extracting the bundle on the robot.
         * </p>
         * </dd>
         * <dt>ExecutingPreLaunch</dt>
         * <dd>
         * <p>
         * Executing pre-launch script(s) if provided.
         * </p>
         * </dd>
         * <dt>Launching</dt>
         * <dd>
         * <p>
         * Launching the robot application.
         * </p>
         * </dd>
         * <dt>ExecutingPostLaunch</dt>
         * <dd>
         * <p>
         * Executing post-launch script(s) if provided.
         * </p>
         * </dd>
         * <dt>Finished</dt>
         * <dd>
         * <p>
         * Deployment is complete.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentProgress
         *        The current progress status.</p>
         *        <dl>
         *        <dt>Validating</dt>
         *        <dd>
         *        <p>
         *        Validating the deployment.
         *        </p>
         *        </dd>
         *        <dt>DownloadingExtracting</dt>
         *        <dd>
         *        <p>
         *        Downloading and extracting the bundle on the robot.
         *        </p>
         *        </dd>
         *        <dt>ExecutingPreLaunch</dt>
         *        <dd>
         *        <p>
         *        Executing pre-launch script(s) if provided.
         *        </p>
         *        </dd>
         *        <dt>Launching</dt>
         *        <dd>
         *        <p>
         *        Launching the robot application.
         *        </p>
         *        </dd>
         *        <dt>ExecutingPostLaunch</dt>
         *        <dd>
         *        <p>
         *        Executing post-launch script(s) if provided.
         *        </p>
         *        </dd>
         *        <dt>Finished</dt>
         *        <dd>
         *        <p>
         *        Deployment is complete.
         *        </p>
         *        </dd>
         * @see RobotDeploymentStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotDeploymentStep
         */
        Builder currentProgress(String currentProgress);

        /**
         * <p>
         * The current progress status.
         * </p>
         * <dl>
         * <dt>Validating</dt>
         * <dd>
         * <p>
         * Validating the deployment.
         * </p>
         * </dd>
         * <dt>DownloadingExtracting</dt>
         * <dd>
         * <p>
         * Downloading and extracting the bundle on the robot.
         * </p>
         * </dd>
         * <dt>ExecutingPreLaunch</dt>
         * <dd>
         * <p>
         * Executing pre-launch script(s) if provided.
         * </p>
         * </dd>
         * <dt>Launching</dt>
         * <dd>
         * <p>
         * Launching the robot application.
         * </p>
         * </dd>
         * <dt>ExecutingPostLaunch</dt>
         * <dd>
         * <p>
         * Executing post-launch script(s) if provided.
         * </p>
         * </dd>
         * <dt>Finished</dt>
         * <dd>
         * <p>
         * Deployment is complete.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param currentProgress
         *        The current progress status.</p>
         *        <dl>
         *        <dt>Validating</dt>
         *        <dd>
         *        <p>
         *        Validating the deployment.
         *        </p>
         *        </dd>
         *        <dt>DownloadingExtracting</dt>
         *        <dd>
         *        <p>
         *        Downloading and extracting the bundle on the robot.
         *        </p>
         *        </dd>
         *        <dt>ExecutingPreLaunch</dt>
         *        <dd>
         *        <p>
         *        Executing pre-launch script(s) if provided.
         *        </p>
         *        </dd>
         *        <dt>Launching</dt>
         *        <dd>
         *        <p>
         *        Launching the robot application.
         *        </p>
         *        </dd>
         *        <dt>ExecutingPostLaunch</dt>
         *        <dd>
         *        <p>
         *        Executing post-launch script(s) if provided.
         *        </p>
         *        </dd>
         *        <dt>Finished</dt>
         *        <dd>
         *        <p>
         *        Deployment is complete.
         *        </p>
         *        </dd>
         * @see RobotDeploymentStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotDeploymentStep
         */
        Builder currentProgress(RobotDeploymentStep currentProgress);

        /**
         * <p>
         * Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code>
         * step of the deployment. It is empty for other steps.
         * </p>
         * 
         * @param percentDone
         *        Precentage of the step that is done. This currently only applies to the
         *        <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentDone(Float percentDone);

        /**
         * <p>
         * Estimated amount of time in seconds remaining in the step. This currently only applies to the
         * <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
         * </p>
         * 
         * @param estimatedTimeRemainingSeconds
         *        Estimated amount of time in seconds remaining in the step. This currently only applies to the
         *        <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeRemainingSeconds(Integer estimatedTimeRemainingSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deployment job.
         * </p>
         * 
         * @param targetResource
         *        The Amazon Resource Name (ARN) of the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(String targetResource);
    }

    static final class BuilderImpl implements Builder {
        private String currentProgress;

        private Float percentDone;

        private Integer estimatedTimeRemainingSeconds;

        private String targetResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressDetail model) {
            currentProgress(model.currentProgress);
            percentDone(model.percentDone);
            estimatedTimeRemainingSeconds(model.estimatedTimeRemainingSeconds);
            targetResource(model.targetResource);
        }

        public final String getCurrentProgress() {
            return currentProgress;
        }

        @Override
        public final Builder currentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
            return this;
        }

        @Override
        public final Builder currentProgress(RobotDeploymentStep currentProgress) {
            this.currentProgress(currentProgress == null ? null : currentProgress.toString());
            return this;
        }

        public final void setCurrentProgress(String currentProgress) {
            this.currentProgress = currentProgress;
        }

        public final Float getPercentDone() {
            return percentDone;
        }

        @Override
        public final Builder percentDone(Float percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final void setPercentDone(Float percentDone) {
            this.percentDone = percentDone;
        }

        public final Integer getEstimatedTimeRemainingSeconds() {
            return estimatedTimeRemainingSeconds;
        }

        @Override
        public final Builder estimatedTimeRemainingSeconds(Integer estimatedTimeRemainingSeconds) {
            this.estimatedTimeRemainingSeconds = estimatedTimeRemainingSeconds;
            return this;
        }

        public final void setEstimatedTimeRemainingSeconds(Integer estimatedTimeRemainingSeconds) {
            this.estimatedTimeRemainingSeconds = estimatedTimeRemainingSeconds;
        }

        public final String getTargetResource() {
            return targetResource;
        }

        @Override
        public final Builder targetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final void setTargetResource(String targetResource) {
            this.targetResource = targetResource;
        }

        @Override
        public ProgressDetail build() {
            return new ProgressDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
