/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a simulation job batch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationJobBatchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationJobBatchSummary.Builder, SimulationJobBatchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SimulationJobBatchSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(SimulationJobBatchSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SimulationJobBatchSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SimulationJobBatchSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> FAILED_REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedRequestCount").getter(getter(SimulationJobBatchSummary::failedRequestCount))
            .setter(setter(Builder::failedRequestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequestCount").build())
            .build();

    private static final SdkField<Integer> PENDING_REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pendingRequestCount").getter(getter(SimulationJobBatchSummary::pendingRequestCount))
            .setter(setter(Builder::pendingRequestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingRequestCount").build())
            .build();

    private static final SdkField<Integer> CREATED_REQUEST_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("createdRequestCount").getter(getter(SimulationJobBatchSummary::createdRequestCount))
            .setter(setter(Builder::createdRequestCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRequestCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, STATUS_FIELD, FAILED_REQUEST_COUNT_FIELD, PENDING_REQUEST_COUNT_FIELD,
            CREATED_REQUEST_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant lastUpdatedAt;

    private final Instant createdAt;

    private final String status;

    private final Integer failedRequestCount;

    private final Integer pendingRequestCount;

    private final Integer createdRequestCount;

    private SimulationJobBatchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.failedRequestCount = builder.failedRequestCount;
        this.pendingRequestCount = builder.pendingRequestCount;
        this.createdRequestCount = builder.createdRequestCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job batch was last updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job batch was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job batch was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the simulation job batch.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The simulation job batch request is pending.
     * </p>
     * </dd>
     * <dt>InProgress</dt>
     * <dd>
     * <p>
     * The simulation job batch is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal
     * failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for
     * more information.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in
     * the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2)
     * when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
     * <code>Failed</code>).
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The simulation batch job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The simulation batch job is being cancelled.
     * </p>
     * </dd>
     * <dt>Completing</dt>
     * <dd>
     * <p>
     * The simulation batch job is completing.
     * </p>
     * </dd>
     * <dt>TimingOut</dt>
     * <dd>
     * <p>
     * The simulation job batch is timing out.
     * </p>
     * <p>
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing
     * request, the batch status will be <code>TimedOut</code>.
     * </p>
     * </dd>
     * <dt>TimedOut</dt>
     * <dd>
     * <p>
     * The simulation batch job timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobBatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job batch.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch request is pending.
     *         </p>
     *         </dd>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch failed. One or more simulation job requests could not be completed due to an
     *         internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
     *         <code>failureReason</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
     *         requests in the batch and none of the failed simulation job requests are due to
     *         <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state
     *         (for example, <code>Completed</code> or <code>Failed</code>).
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is being cancelled.
     *         </p>
     *         </dd>
     *         <dt>Completing</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is completing.
     *         </p>
     *         </dd>
     *         <dt>TimingOut</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is timing out.
     *         </p>
     *         <p>
     *         If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     *         <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
     *         failing request, the batch status will be <code>TimedOut</code>.
     *         </p>
     *         </dd>
     *         <dt>TimedOut</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job timed out.
     *         </p>
     *         </dd>
     * @see SimulationJobBatchStatus
     */
    public SimulationJobBatchStatus status() {
        return SimulationJobBatchStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the simulation job batch.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The simulation job batch request is pending.
     * </p>
     * </dd>
     * <dt>InProgress</dt>
     * <dd>
     * <p>
     * The simulation job batch is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal
     * failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for
     * more information.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in
     * the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2)
     * when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
     * <code>Failed</code>).
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The simulation batch job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The simulation batch job is being cancelled.
     * </p>
     * </dd>
     * <dt>Completing</dt>
     * <dd>
     * <p>
     * The simulation batch job is completing.
     * </p>
     * </dd>
     * <dt>TimingOut</dt>
     * <dd>
     * <p>
     * The simulation job batch is timing out.
     * </p>
     * <p>
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing
     * request, the batch status will be <code>TimedOut</code>.
     * </p>
     * </dd>
     * <dt>TimedOut</dt>
     * <dd>
     * <p>
     * The simulation batch job timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobBatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job batch.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch request is pending.
     *         </p>
     *         </dd>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch failed. One or more simulation job requests could not be completed due to an
     *         internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
     *         <code>failureReason</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
     *         requests in the batch and none of the failed simulation job requests are due to
     *         <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state
     *         (for example, <code>Completed</code> or <code>Failed</code>).
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is being cancelled.
     *         </p>
     *         </dd>
     *         <dt>Completing</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is completing.
     *         </p>
     *         </dd>
     *         <dt>TimingOut</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is timing out.
     *         </p>
     *         <p>
     *         If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     *         <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
     *         failing request, the batch status will be <code>TimedOut</code>.
     *         </p>
     *         </dd>
     *         <dt>TimedOut</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job timed out.
     *         </p>
     *         </dd>
     * @see SimulationJobBatchStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The number of failed simulation job requests.
     * </p>
     * 
     * @return The number of failed simulation job requests.
     */
    public Integer failedRequestCount() {
        return failedRequestCount;
    }

    /**
     * <p>
     * The number of pending simulation job requests.
     * </p>
     * 
     * @return The number of pending simulation job requests.
     */
    public Integer pendingRequestCount() {
        return pendingRequestCount;
    }

    /**
     * <p>
     * The number of created simulation job requests.
     * </p>
     * 
     * @return The number of created simulation job requests.
     */
    public Integer createdRequestCount() {
        return createdRequestCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdRequestCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobBatchSummary)) {
            return false;
        }
        SimulationJobBatchSummary other = (SimulationJobBatchSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failedRequestCount(), other.failedRequestCount())
                && Objects.equals(pendingRequestCount(), other.pendingRequestCount())
                && Objects.equals(createdRequestCount(), other.createdRequestCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SimulationJobBatchSummary").add("Arn", arn()).add("LastUpdatedAt", lastUpdatedAt())
                .add("CreatedAt", createdAt()).add("Status", statusAsString()).add("FailedRequestCount", failedRequestCount())
                .add("PendingRequestCount", pendingRequestCount()).add("CreatedRequestCount", createdRequestCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failedRequestCount":
            return Optional.ofNullable(clazz.cast(failedRequestCount()));
        case "pendingRequestCount":
            return Optional.ofNullable(clazz.cast(pendingRequestCount()));
        case "createdRequestCount":
            return Optional.ofNullable(clazz.cast(createdRequestCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobBatchSummary, T> g) {
        return obj -> g.apply((SimulationJobBatchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationJobBatchSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation job batch was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job batch was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the simulation job batch was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the simulation job batch.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The simulation job batch request is pending.
         * </p>
         * </dd>
         * <dt>InProgress</dt>
         * <dd>
         * <p>
         * The simulation job batch is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an
         * internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         * <code>failureReason</code> for more information.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests
         * in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and
         * (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
         * <code>Failed</code>).
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The simulation batch job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The simulation batch job is being cancelled.
         * </p>
         * </dd>
         * <dt>Completing</dt>
         * <dd>
         * <p>
         * The simulation batch job is completing.
         * </p>
         * </dd>
         * <dt>TimingOut</dt>
         * <dd>
         * <p>
         * The simulation job batch is timing out.
         * </p>
         * <p>
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
         * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
         * failing request, the batch status will be <code>TimedOut</code>.
         * </p>
         * </dd>
         * <dt>TimedOut</dt>
         * <dd>
         * <p>
         * The simulation batch job timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the simulation job batch.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch request is pending.
         *        </p>
         *        </dd>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch failed. One or more simulation job requests could not be completed due to an
         *        internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         *        <code>failureReason</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
         *        requests in the batch and none of the failed simulation job requests are due to
         *        <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal
         *        state (for example, <code>Completed</code> or <code>Failed</code>).
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is being cancelled.
         *        </p>
         *        </dd>
         *        <dt>Completing</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is completing.
         *        </p>
         *        </dd>
         *        <dt>TimingOut</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is timing out.
         *        </p>
         *        <p>
         *        If a batch timing out, and there are pending requests that were failing due to an internal failure
         *        (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are
         *        no such failing request, the batch status will be <code>TimedOut</code>.
         *        </p>
         *        </dd>
         *        <dt>TimedOut</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job timed out.
         *        </p>
         *        </dd>
         * @see SimulationJobBatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the simulation job batch.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The simulation job batch request is pending.
         * </p>
         * </dd>
         * <dt>InProgress</dt>
         * <dd>
         * <p>
         * The simulation job batch is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an
         * internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         * <code>failureReason</code> for more information.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests
         * in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and
         * (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
         * <code>Failed</code>).
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The simulation batch job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The simulation batch job is being cancelled.
         * </p>
         * </dd>
         * <dt>Completing</dt>
         * <dd>
         * <p>
         * The simulation batch job is completing.
         * </p>
         * </dd>
         * <dt>TimingOut</dt>
         * <dd>
         * <p>
         * The simulation job batch is timing out.
         * </p>
         * <p>
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
         * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
         * failing request, the batch status will be <code>TimedOut</code>.
         * </p>
         * </dd>
         * <dt>TimedOut</dt>
         * <dd>
         * <p>
         * The simulation batch job timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the simulation job batch.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch request is pending.
         *        </p>
         *        </dd>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch failed. One or more simulation job requests could not be completed due to an
         *        internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         *        <code>failureReason</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
         *        requests in the batch and none of the failed simulation job requests are due to
         *        <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal
         *        state (for example, <code>Completed</code> or <code>Failed</code>).
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is being cancelled.
         *        </p>
         *        </dd>
         *        <dt>Completing</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is completing.
         *        </p>
         *        </dd>
         *        <dt>TimingOut</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is timing out.
         *        </p>
         *        <p>
         *        If a batch timing out, and there are pending requests that were failing due to an internal failure
         *        (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are
         *        no such failing request, the batch status will be <code>TimedOut</code>.
         *        </p>
         *        </dd>
         *        <dt>TimedOut</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job timed out.
         *        </p>
         *        </dd>
         * @see SimulationJobBatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchStatus
         */
        Builder status(SimulationJobBatchStatus status);

        /**
         * <p>
         * The number of failed simulation job requests.
         * </p>
         * 
         * @param failedRequestCount
         *        The number of failed simulation job requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequestCount(Integer failedRequestCount);

        /**
         * <p>
         * The number of pending simulation job requests.
         * </p>
         * 
         * @param pendingRequestCount
         *        The number of pending simulation job requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRequestCount(Integer pendingRequestCount);

        /**
         * <p>
         * The number of created simulation job requests.
         * </p>
         * 
         * @param createdRequestCount
         *        The number of created simulation job requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRequestCount(Integer createdRequestCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant lastUpdatedAt;

        private Instant createdAt;

        private String status;

        private Integer failedRequestCount;

        private Integer pendingRequestCount;

        private Integer createdRequestCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobBatchSummary model) {
            arn(model.arn);
            lastUpdatedAt(model.lastUpdatedAt);
            createdAt(model.createdAt);
            status(model.status);
            failedRequestCount(model.failedRequestCount);
            pendingRequestCount(model.pendingRequestCount);
            createdRequestCount(model.createdRequestCount);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobBatchStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getFailedRequestCount() {
            return failedRequestCount;
        }

        @Override
        public final Builder failedRequestCount(Integer failedRequestCount) {
            this.failedRequestCount = failedRequestCount;
            return this;
        }

        public final void setFailedRequestCount(Integer failedRequestCount) {
            this.failedRequestCount = failedRequestCount;
        }

        public final Integer getPendingRequestCount() {
            return pendingRequestCount;
        }

        @Override
        public final Builder pendingRequestCount(Integer pendingRequestCount) {
            this.pendingRequestCount = pendingRequestCount;
            return this;
        }

        public final void setPendingRequestCount(Integer pendingRequestCount) {
            this.pendingRequestCount = pendingRequestCount;
        }

        public final Integer getCreatedRequestCount() {
            return createdRequestCount;
        }

        @Override
        public final Builder createdRequestCount(Integer createdRequestCount) {
            this.createdRequestCount = createdRequestCount;
            return this;
        }

        public final void setCreatedRequestCount(Integer createdRequestCount) {
            this.createdRequestCount = createdRequestCount;
        }

        @Override
        public SimulationJobBatchSummary build() {
            return new SimulationJobBatchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
