/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a simulation job request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationJobRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationJobRequest.Builder, SimulationJobRequest> {
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).memberName("outputLocation")
            .getter(getter(SimulationJobRequest::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("loggingConfig")
            .getter(getter(SimulationJobRequest::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()).build();

    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxJobDurationInSeconds").getter(getter(SimulationJobRequest::maxJobDurationInSeconds))
            .setter(setter(Builder::maxJobDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRole").getter(getter(SimulationJobRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureBehavior").getter(getter(SimulationJobRequest::failureBehaviorAsString))
            .setter(setter(Builder::failureBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_APPLICATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDefaultApplications").getter(getter(SimulationJobRequest::useDefaultApplications))
            .setter(setter(Builder::useDefaultApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultApplications").build())
            .build();

    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField
            .<List<RobotApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("robotApplications")
            .getter(getter(SimulationJobRequest::robotApplications))
            .setter(setter(Builder::robotApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RobotApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RobotApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField
            .<List<SimulationApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("simulationApplications")
            .getter(getter(SimulationJobRequest::simulationApplications))
            .setter(setter(Builder::simulationApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceConfig>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSourceConfig>> builder(MarshallingType.LIST)
            .memberName("dataSources")
            .getter(getter(SimulationJobRequest::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VPCConfig> VPC_CONFIG_FIELD = SdkField.<VPCConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(SimulationJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VPCConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<Compute> COMPUTE_FIELD = SdkField.<Compute> builder(MarshallingType.SDK_POJO)
            .memberName("compute").getter(getter(SimulationJobRequest::compute)).setter(setter(Builder::compute))
            .constructor(Compute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SimulationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD,
            LOGGING_CONFIG_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, IAM_ROLE_FIELD, FAILURE_BEHAVIOR_FIELD,
            USE_DEFAULT_APPLICATIONS_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD,
            VPC_CONFIG_FIELD, COMPUTE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final OutputLocation outputLocation;

    private final LoggingConfig loggingConfig;

    private final Long maxJobDurationInSeconds;

    private final String iamRole;

    private final String failureBehavior;

    private final Boolean useDefaultApplications;

    private final List<RobotApplicationConfig> robotApplications;

    private final List<SimulationApplicationConfig> simulationApplications;

    private final List<DataSourceConfig> dataSources;

    private final VPCConfig vpcConfig;

    private final Compute compute;

    private final Map<String, String> tags;

    private SimulationJobRequest(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.iamRole = builder.iamRole;
        this.failureBehavior = builder.failureBehavior;
        this.useDefaultApplications = builder.useDefaultApplications;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.vpcConfig = builder.vpcConfig;
        this.compute = builder.compute;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the OutputLocation property for this object.
     * 
     * @return The value of the OutputLocation property for this object.
     */
    public OutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * Returns the value of the LoggingConfig property for this object.
     * 
     * @return The value of the LoggingConfig property for this object.
     */
    public LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     * 
     * @return The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */
    public Long maxJobDurationInSeconds() {
        return maxJobDurationInSeconds;
    }

    /**
     * <p>
     * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     * 
     * @return The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
     *         associated policies on your behalf. This is how credentials are passed in to your simulation job.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior the simulation job.</p>
     *         <dl>
     *         <dt>Continue</dt>
     *         <dd>
     *         <p>
     *         Restart the simulation job in the same host instance.
     *         </p>
     *         </dd>
     *         <dt>Fail</dt>
     *         <dd>
     *         <p>
     *         Stop the simulation job and terminate the instance.
     *         </p>
     *         </dd>
     * @see FailureBehavior
     */
    public FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(failureBehavior);
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Restart the simulation job in the same host instance.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior the simulation job.</p>
     *         <dl>
     *         <dt>Continue</dt>
     *         <dd>
     *         <p>
     *         Restart the simulation job in the same host instance.
     *         </p>
     *         </dd>
     *         <dt>Fail</dt>
     *         <dd>
     *         <p>
     *         Stop the simulation job and terminate the instance.
     *         </p>
     *         </dd>
     * @see FailureBehavior
     */
    public String failureBehaviorAsString() {
        return failureBehavior;
    }

    /**
     * <p>
     * Boolean indicating whether to use default simulation tool applications.
     * </p>
     * 
     * @return Boolean indicating whether to use default simulation tool applications.
     */
    public Boolean useDefaultApplications() {
        return useDefaultApplications;
    }

    /**
     * Returns true if the RobotApplications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRobotApplications() {
        return robotApplications != null && !(robotApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The robot applications to use in the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRobotApplications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The robot applications to use in the simulation job.
     */
    public List<RobotApplicationConfig> robotApplications() {
        return robotApplications;
    }

    /**
     * Returns true if the SimulationApplications property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSimulationApplications() {
        return simulationApplications != null && !(simulationApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The simulation applications to use in the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSimulationApplications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The simulation applications to use in the simulation job.
     */
    public List<SimulationApplicationConfig> simulationApplications() {
        return simulationApplications;
    }

    /**
     * Returns true if the DataSources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
     * <code>/opt/robomaker/datasources/data_source_name</code>.
     * </p>
     * <note>
     * <p>
     * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify data sources to mount read-only files from S3 into your simulation. These files are available
     *         under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
     *         <p>
     *         There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
     *         </p>
     */
    public List<DataSourceConfig> dataSources() {
        return dataSources;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public VPCConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Compute information for the simulation job
     * </p>
     * 
     * @return Compute information for the simulation job
     */
    public Compute compute() {
        return compute;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the simulation job request.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultApplications());
        hashCode = 31 * hashCode + Objects.hashCode(hasRobotApplications() ? robotApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSimulationApplications() ? simulationApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(compute());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobRequest)) {
            return false;
        }
        SimulationJobRequest other = (SimulationJobRequest) obj;
        return Objects.equals(outputLocation(), other.outputLocation()) && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(maxJobDurationInSeconds(), other.maxJobDurationInSeconds())
                && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(failureBehaviorAsString(), other.failureBehaviorAsString())
                && Objects.equals(useDefaultApplications(), other.useDefaultApplications())
                && hasRobotApplications() == other.hasRobotApplications()
                && Objects.equals(robotApplications(), other.robotApplications())
                && hasSimulationApplications() == other.hasSimulationApplications()
                && Objects.equals(simulationApplications(), other.simulationApplications())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(compute(), other.compute())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SimulationJobRequest").add("OutputLocation", outputLocation())
                .add("LoggingConfig", loggingConfig()).add("MaxJobDurationInSeconds", maxJobDurationInSeconds())
                .add("IamRole", iamRole()).add("FailureBehavior", failureBehaviorAsString())
                .add("UseDefaultApplications", useDefaultApplications())
                .add("RobotApplications", hasRobotApplications() ? robotApplications() : null)
                .add("SimulationApplications", hasSimulationApplications() ? simulationApplications() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null).add("VpcConfig", vpcConfig())
                .add("Compute", compute()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "loggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "maxJobDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxJobDurationInSeconds()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "failureBehavior":
            return Optional.ofNullable(clazz.cast(failureBehaviorAsString()));
        case "useDefaultApplications":
            return Optional.ofNullable(clazz.cast(useDefaultApplications()));
        case "robotApplications":
            return Optional.ofNullable(clazz.cast(robotApplications()));
        case "simulationApplications":
            return Optional.ofNullable(clazz.cast(simulationApplications()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "compute":
            return Optional.ofNullable(clazz.cast(compute()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobRequest, T> g) {
        return obj -> g.apply((SimulationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationJobRequest> {
        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * @param outputLocation
         *        The new value for the OutputLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * This is a convenience that creates an instance of the {@link OutputLocation.Builder} avoiding the need to
         * create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * Sets the value of the LoggingConfig property for this object.
         *
         * @param loggingConfig
         *        The new value for the LoggingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * Sets the value of the LoggingConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link LoggingConfig.Builder} avoiding the need to
         * create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         * </p>
         * 
         * @param maxJobDurationInSeconds
         *        The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds);

        /**
         * <p>
         * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
         * associated policies on your behalf. This is how credentials are passed in to your simulation job.
         * </p>
         * 
         * @param iamRole
         *        The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
         *        associated policies on your behalf. This is how credentials are passed in to your simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The failure behavior the simulation job.
         * </p>
         * <dl>
         * <dt>Continue</dt>
         * <dd>
         * <p>
         * Restart the simulation job in the same host instance.
         * </p>
         * </dd>
         * <dt>Fail</dt>
         * <dd>
         * <p>
         * Stop the simulation job and terminate the instance.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureBehavior
         *        The failure behavior the simulation job.</p>
         *        <dl>
         *        <dt>Continue</dt>
         *        <dd>
         *        <p>
         *        Restart the simulation job in the same host instance.
         *        </p>
         *        </dd>
         *        <dt>Fail</dt>
         *        <dd>
         *        <p>
         *        Stop the simulation job and terminate the instance.
         *        </p>
         *        </dd>
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(String failureBehavior);

        /**
         * <p>
         * The failure behavior the simulation job.
         * </p>
         * <dl>
         * <dt>Continue</dt>
         * <dd>
         * <p>
         * Restart the simulation job in the same host instance.
         * </p>
         * </dd>
         * <dt>Fail</dt>
         * <dd>
         * <p>
         * Stop the simulation job and terminate the instance.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureBehavior
         *        The failure behavior the simulation job.</p>
         *        <dl>
         *        <dt>Continue</dt>
         *        <dd>
         *        <p>
         *        Restart the simulation job in the same host instance.
         *        </p>
         *        </dd>
         *        <dt>Fail</dt>
         *        <dd>
         *        <p>
         *        Stop the simulation job and terminate the instance.
         *        </p>
         *        </dd>
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(FailureBehavior failureBehavior);

        /**
         * <p>
         * Boolean indicating whether to use default simulation tool applications.
         * </p>
         * 
         * @param useDefaultApplications
         *        Boolean indicating whether to use default simulation tool applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultApplications(Boolean useDefaultApplications);

        /**
         * <p>
         * The robot applications to use in the simulation job.
         * </p>
         * 
         * @param robotApplications
         *        The robot applications to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(Collection<RobotApplicationConfig> robotApplications);

        /**
         * <p>
         * The robot applications to use in the simulation job.
         * </p>
         * 
         * @param robotApplications
         *        The robot applications to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(RobotApplicationConfig... robotApplications);

        /**
         * <p>
         * The robot applications to use in the simulation job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RobotApplicationConfig>.Builder} avoiding
         * the need to create one manually via {@link List<RobotApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RobotApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #robotApplications(List<RobotApplicationConfig>)}.
         * 
         * @param robotApplications
         *        a consumer that will call methods on {@link List<RobotApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotApplications(List<RobotApplicationConfig>)
         */
        Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications);

        /**
         * <p>
         * The simulation applications to use in the simulation job.
         * </p>
         * 
         * @param simulationApplications
         *        The simulation applications to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications);

        /**
         * <p>
         * The simulation applications to use in the simulation job.
         * </p>
         * 
         * @param simulationApplications
         *        The simulation applications to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(SimulationApplicationConfig... simulationApplications);

        /**
         * <p>
         * The simulation applications to use in the simulation job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationApplicationConfig>.Builder}
         * avoiding the need to create one manually via {@link List<SimulationApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #simulationApplications(List<SimulationApplicationConfig>)}.
         * 
         * @param simulationApplications
         *        a consumer that will call methods on {@link List<SimulationApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationApplications(List<SimulationApplicationConfig>)
         */
        Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note>
         * 
         * @param dataSources
         *        Specify data sources to mount read-only files from S3 into your simulation. These files are available
         *        under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
         *        <p>
         *        There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code>
         *        objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSourceConfig> dataSources);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note>
         * 
         * @param dataSources
         *        Specify data sources to mount read-only files from S3 into your simulation. These files are available
         *        under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
         *        <p>
         *        There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code>
         *        objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourceConfig... dataSources);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<DataSourceConfig>.Builder} avoiding
         * the need to create one manually via {@link List<DataSourceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(List<DataSourceConfig>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link List<DataSourceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(List<DataSourceConfig>)
         */
        Builder dataSources(Consumer<DataSourceConfig.Builder>... dataSources);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VPCConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link VPCConfig.Builder} avoiding the need to create
         * one manually via {@link VPCConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VPCConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VPCConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VPCConfig)
         */
        default Builder vpcConfig(Consumer<VPCConfig.Builder> vpcConfig) {
            return vpcConfig(VPCConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Compute information for the simulation job
         * </p>
         * 
         * @param compute
         *        Compute information for the simulation job
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compute(Compute compute);

        /**
         * <p>
         * Compute information for the simulation job
         * </p>
         * This is a convenience that creates an instance of the {@link Compute.Builder} avoiding the need to create one
         * manually via {@link Compute#builder()}.
         *
         * When the {@link Consumer} completes, {@link Compute.Builder#build()} is called immediately and its result is
         * passed to {@link #compute(Compute)}.
         * 
         * @param compute
         *        a consumer that will call methods on {@link Compute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compute(Compute)
         */
        default Builder compute(Consumer<Compute.Builder> compute) {
            return compute(Compute.builder().applyMutation(compute).build());
        }

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the simulation job request.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the simulation job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private OutputLocation outputLocation;

        private LoggingConfig loggingConfig;

        private Long maxJobDurationInSeconds;

        private String iamRole;

        private String failureBehavior;

        private Boolean useDefaultApplications;

        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();

        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceConfig> dataSources = DefaultSdkAutoConstructList.getInstance();

        private VPCConfig vpcConfig;

        private Compute compute;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobRequest model) {
            outputLocation(model.outputLocation);
            loggingConfig(model.loggingConfig);
            maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            iamRole(model.iamRole);
            failureBehavior(model.failureBehavior);
            useDefaultApplications(model.useDefaultApplications);
            robotApplications(model.robotApplications);
            simulationApplications(model.simulationApplications);
            dataSources(model.dataSources);
            vpcConfig(model.vpcConfig);
            compute(model.compute);
            tags(model.tags);
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final Long getMaxJobDurationInSeconds() {
            return maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final String getFailureBehavior() {
            return failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        public final Boolean getUseDefaultApplications() {
            return useDefaultApplications;
        }

        @Override
        public final Builder useDefaultApplications(Boolean useDefaultApplications) {
            this.useDefaultApplications = useDefaultApplications;
            return this;
        }

        public final void setUseDefaultApplications(Boolean useDefaultApplications) {
            this.useDefaultApplications = useDefaultApplications;
        }

        public final Collection<RobotApplicationConfig.Builder> getRobotApplications() {
            if (robotApplications instanceof SdkAutoConstructList) {
                return null;
            }
            return robotApplications != null ? robotApplications.stream().map(RobotApplicationConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig... robotApplications) {
            robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications) {
            robotApplications(Stream.of(robotApplications).map(c -> RobotApplicationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        public final Collection<SimulationApplicationConfig.Builder> getSimulationApplications() {
            if (simulationApplications instanceof SdkAutoConstructList) {
                return null;
            }
            return simulationApplications != null ? simulationApplications.stream().map(SimulationApplicationConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig... simulationApplications) {
            simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications) {
            simulationApplications(Stream.of(simulationApplications)
                    .map(c -> SimulationApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        public final Collection<DataSourceConfig.Builder> getDataSources() {
            if (dataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSources != null ? dataSources.stream().map(DataSourceConfig::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSourceConfig> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSourceConfig... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSourceConfig.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSourceConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSourceConfig.BuilderImpl> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copyFromBuilder(dataSources);
        }

        public final VPCConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VPCConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Compute.Builder getCompute() {
            return compute != null ? compute.toBuilder() : null;
        }

        @Override
        public final Builder compute(Compute compute) {
            this.compute = compute;
            return this;
        }

        public final void setCompute(Compute.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public SimulationJobRequest build() {
            return new SimulationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
