/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSimulationJobBatchRequest extends RoboMakerRequest implements
        ToCopyableBuilder<DescribeSimulationJobBatchRequest.Builder, DescribeSimulationJobBatchRequest> {
    private static final SdkField<String> BATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("batch")
            .getter(getter(DescribeSimulationJobBatchRequest::batch)).setter(setter(Builder::batch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_FIELD));

    private final String batch;

    private DescribeSimulationJobBatchRequest(BuilderImpl builder) {
        super(builder);
        this.batch = builder.batch;
    }

    /**
     * <p>
     * The id of the batch to describe.
     * </p>
     * 
     * @return The id of the batch to describe.
     */
    public String batch() {
        return batch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSimulationJobBatchRequest)) {
            return false;
        }
        DescribeSimulationJobBatchRequest other = (DescribeSimulationJobBatchRequest) obj;
        return Objects.equals(batch(), other.batch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSimulationJobBatchRequest").add("Batch", batch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batch":
            return Optional.ofNullable(clazz.cast(batch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSimulationJobBatchRequest, T> g) {
        return obj -> g.apply((DescribeSimulationJobBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSimulationJobBatchRequest> {
        /**
         * <p>
         * The id of the batch to describe.
         * </p>
         * 
         * @param batch
         *        The id of the batch to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batch(String batch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String batch;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSimulationJobBatchRequest model) {
            super(model);
            batch(model.batch);
        }

        public final String getBatch() {
            return batch;
        }

        @Override
        public final Builder batch(String batch) {
            this.batch = batch;
            return this;
        }

        public final void setBatch(String batch) {
            this.batch = batch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSimulationJobBatchRequest build() {
            return new DescribeSimulationJobBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
