/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterRobotResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DeregisterRobotResponse.Builder, DeregisterRobotResponse> {
    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(DeregisterRobotResponse::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<String> ROBOT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("robot")
            .getter(getter(DeregisterRobotResponse::robot)).setter(setter(Builder::robot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_FIELD, ROBOT_FIELD));

    private final String fleet;

    private final String robot;

    private DeregisterRobotResponse(BuilderImpl builder) {
        super(builder);
        this.fleet = builder.fleet;
        this.robot = builder.robot;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public String fleet() {
        return fleet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot.
     */
    public String robot() {
        return robot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(robot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterRobotResponse)) {
            return false;
        }
        DeregisterRobotResponse other = (DeregisterRobotResponse) obj;
        return Objects.equals(fleet(), other.fleet()) && Objects.equals(robot(), other.robot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeregisterRobotResponse").add("Fleet", fleet()).add("Robot", robot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "robot":
            return Optional.ofNullable(clazz.cast(robot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterRobotResponse, T> g) {
        return obj -> g.apply((DeregisterRobotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterRobotResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleet
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot.
         * </p>
         * 
         * @param robot
         *        The Amazon Resource Name (ARN) of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robot(String robot);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String fleet;

        private String robot;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterRobotResponse model) {
            super(model);
            fleet(model.fleet);
            robot(model.robot);
        }

        public final String getFleet() {
            return fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        public final String getRobot() {
            return robot;
        }

        @Override
        public final Builder robot(String robot) {
            this.robot = robot;
            return this;
        }

        public final void setRobot(String robot) {
            this.robot = robot;
        }

        @Override
        public DeregisterRobotResponse build() {
            return new DeregisterRobotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
