/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about worlds that finished.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FinishedWorldsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FinishedWorldsSummary.Builder, FinishedWorldsSummary> {
    private static final SdkField<Integer> FINISHED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("finishedCount").getter(getter(FinishedWorldsSummary::finishedCount))
            .setter(setter(Builder::finishedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedCount").build()).build();

    private static final SdkField<List<String>> SUCCEEDED_WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("succeededWorlds")
            .getter(getter(FinishedWorldsSummary::succeededWorlds))
            .setter(setter(Builder::succeededWorlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededWorlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FailureSummary> FAILURE_SUMMARY_FIELD = SdkField
            .<FailureSummary> builder(MarshallingType.SDK_POJO).memberName("failureSummary")
            .getter(getter(FinishedWorldsSummary::failureSummary)).setter(setter(Builder::failureSummary))
            .constructor(FailureSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINISHED_COUNT_FIELD,
            SUCCEEDED_WORLDS_FIELD, FAILURE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer finishedCount;

    private final List<String> succeededWorlds;

    private final FailureSummary failureSummary;

    private FinishedWorldsSummary(BuilderImpl builder) {
        this.finishedCount = builder.finishedCount;
        this.succeededWorlds = builder.succeededWorlds;
        this.failureSummary = builder.failureSummary;
    }

    /**
     * <p>
     * The total number of finished worlds.
     * </p>
     * 
     * @return The total number of finished worlds.
     */
    public Integer finishedCount() {
        return finishedCount;
    }

    /**
     * Returns true if the SucceededWorlds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSucceededWorlds() {
        return succeededWorlds != null && !(succeededWorlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of worlds that succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSucceededWorlds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of worlds that succeeded.
     */
    public List<String> succeededWorlds() {
        return succeededWorlds;
    }

    /**
     * <p>
     * Information about worlds that failed.
     * </p>
     * 
     * @return Information about worlds that failed.
     */
    public FailureSummary failureSummary() {
        return failureSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(finishedCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSucceededWorlds() ? succeededWorlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinishedWorldsSummary)) {
            return false;
        }
        FinishedWorldsSummary other = (FinishedWorldsSummary) obj;
        return Objects.equals(finishedCount(), other.finishedCount()) && hasSucceededWorlds() == other.hasSucceededWorlds()
                && Objects.equals(succeededWorlds(), other.succeededWorlds())
                && Objects.equals(failureSummary(), other.failureSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FinishedWorldsSummary").add("FinishedCount", finishedCount())
                .add("SucceededWorlds", hasSucceededWorlds() ? succeededWorlds() : null).add("FailureSummary", failureSummary())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "finishedCount":
            return Optional.ofNullable(clazz.cast(finishedCount()));
        case "succeededWorlds":
            return Optional.ofNullable(clazz.cast(succeededWorlds()));
        case "failureSummary":
            return Optional.ofNullable(clazz.cast(failureSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FinishedWorldsSummary, T> g) {
        return obj -> g.apply((FinishedWorldsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FinishedWorldsSummary> {
        /**
         * <p>
         * The total number of finished worlds.
         * </p>
         * 
         * @param finishedCount
         *        The total number of finished worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedCount(Integer finishedCount);

        /**
         * <p>
         * A list of worlds that succeeded.
         * </p>
         * 
         * @param succeededWorlds
         *        A list of worlds that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededWorlds(Collection<String> succeededWorlds);

        /**
         * <p>
         * A list of worlds that succeeded.
         * </p>
         * 
         * @param succeededWorlds
         *        A list of worlds that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededWorlds(String... succeededWorlds);

        /**
         * <p>
         * Information about worlds that failed.
         * </p>
         * 
         * @param failureSummary
         *        Information about worlds that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureSummary(FailureSummary failureSummary);

        /**
         * <p>
         * Information about worlds that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link FailureSummary.Builder} avoiding the need to
         * create one manually via {@link FailureSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailureSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #failureSummary(FailureSummary)}.
         * 
         * @param failureSummary
         *        a consumer that will call methods on {@link FailureSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureSummary(FailureSummary)
         */
        default Builder failureSummary(Consumer<FailureSummary.Builder> failureSummary) {
            return failureSummary(FailureSummary.builder().applyMutation(failureSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer finishedCount;

        private List<String> succeededWorlds = DefaultSdkAutoConstructList.getInstance();

        private FailureSummary failureSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(FinishedWorldsSummary model) {
            finishedCount(model.finishedCount);
            succeededWorlds(model.succeededWorlds);
            failureSummary(model.failureSummary);
        }

        public final Integer getFinishedCount() {
            return finishedCount;
        }

        @Override
        public final Builder finishedCount(Integer finishedCount) {
            this.finishedCount = finishedCount;
            return this;
        }

        public final void setFinishedCount(Integer finishedCount) {
            this.finishedCount = finishedCount;
        }

        public final Collection<String> getSucceededWorlds() {
            if (succeededWorlds instanceof SdkAutoConstructList) {
                return null;
            }
            return succeededWorlds;
        }

        @Override
        public final Builder succeededWorlds(Collection<String> succeededWorlds) {
            this.succeededWorlds = ArnsCopier.copy(succeededWorlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeededWorlds(String... succeededWorlds) {
            succeededWorlds(Arrays.asList(succeededWorlds));
            return this;
        }

        public final void setSucceededWorlds(Collection<String> succeededWorlds) {
            this.succeededWorlds = ArnsCopier.copy(succeededWorlds);
        }

        public final FailureSummary.Builder getFailureSummary() {
            return failureSummary != null ? failureSummary.toBuilder() : null;
        }

        @Override
        public final Builder failureSummary(FailureSummary failureSummary) {
            this.failureSummary = failureSummary;
            return this;
        }

        public final void setFailureSummary(FailureSummary.BuilderImpl failureSummary) {
            this.failureSummary = failureSummary != null ? failureSummary.build() : null;
        }

        @Override
        public FinishedWorldsSummary build() {
            return new FinishedWorldsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
