/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorldExportJobsResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListWorldExportJobsResponse.Builder, ListWorldExportJobsResponse> {
    private static final SdkField<List<WorldExportJobSummary>> WORLD_EXPORT_JOB_SUMMARIES_FIELD = SdkField
            .<List<WorldExportJobSummary>> builder(MarshallingType.LIST)
            .memberName("worldExportJobSummaries")
            .getter(getter(ListWorldExportJobsResponse::worldExportJobSummaries))
            .setter(setter(Builder::worldExportJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldExportJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorldExportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorldExportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorldExportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WORLD_EXPORT_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<WorldExportJobSummary> worldExportJobSummaries;

    private final String nextToken;

    private ListWorldExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.worldExportJobSummaries = builder.worldExportJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WorldExportJobSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasWorldExportJobSummaries() {
        return worldExportJobSummaries != null && !(worldExportJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for world export jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorldExportJobSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information for world export jobs.
     */
    public List<WorldExportJobSummary> worldExportJobSummaries() {
        return worldExportJobSummaries;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>ListWorldExportJobsRequest</code> again and assign that token to the request object's
     * <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken
     * parameter is set to null.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListWorldExportJobsRequest</code> again and assign that token to the request object's
     *         <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
     *         NextToken parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorldExportJobSummaries() ? worldExportJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldExportJobsResponse)) {
            return false;
        }
        ListWorldExportJobsResponse other = (ListWorldExportJobsResponse) obj;
        return hasWorldExportJobSummaries() == other.hasWorldExportJobSummaries()
                && Objects.equals(worldExportJobSummaries(), other.worldExportJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWorldExportJobsResponse")
                .add("WorldExportJobSummaries", hasWorldExportJobSummaries() ? worldExportJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "worldExportJobSummaries":
            return Optional.ofNullable(clazz.cast(worldExportJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorldExportJobsResponse, T> g) {
        return obj -> g.apply((ListWorldExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorldExportJobsResponse> {
        /**
         * <p>
         * Summary information for world export jobs.
         * </p>
         * 
         * @param worldExportJobSummaries
         *        Summary information for world export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldExportJobSummaries(Collection<WorldExportJobSummary> worldExportJobSummaries);

        /**
         * <p>
         * Summary information for world export jobs.
         * </p>
         * 
         * @param worldExportJobSummaries
         *        Summary information for world export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldExportJobSummaries(WorldExportJobSummary... worldExportJobSummaries);

        /**
         * <p>
         * Summary information for world export jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorldExportJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<WorldExportJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorldExportJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #worldExportJobSummaries(List<WorldExportJobSummary>)}.
         * 
         * @param worldExportJobSummaries
         *        a consumer that will call methods on {@link List<WorldExportJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worldExportJobSummaries(List<WorldExportJobSummary>)
         */
        Builder worldExportJobSummaries(Consumer<WorldExportJobSummary.Builder>... worldExportJobSummaries);

        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>ListWorldExportJobsRequest</code> again and assign that token to the request object's
         * <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken
         * parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListWorldExportJobsRequest</code> again and assign that token to the request object's
         *        <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
         *        NextToken parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<WorldExportJobSummary> worldExportJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldExportJobsResponse model) {
            super(model);
            worldExportJobSummaries(model.worldExportJobSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<WorldExportJobSummary.Builder> getWorldExportJobSummaries() {
            if (worldExportJobSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return worldExportJobSummaries != null ? worldExportJobSummaries.stream().map(WorldExportJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder worldExportJobSummaries(Collection<WorldExportJobSummary> worldExportJobSummaries) {
            this.worldExportJobSummaries = WorldExportJobSummariesCopier.copy(worldExportJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldExportJobSummaries(WorldExportJobSummary... worldExportJobSummaries) {
            worldExportJobSummaries(Arrays.asList(worldExportJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldExportJobSummaries(Consumer<WorldExportJobSummary.Builder>... worldExportJobSummaries) {
            worldExportJobSummaries(Stream.of(worldExportJobSummaries)
                    .map(c -> WorldExportJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorldExportJobSummaries(Collection<WorldExportJobSummary.BuilderImpl> worldExportJobSummaries) {
            this.worldExportJobSummaries = WorldExportJobSummariesCopier.copyFromBuilder(worldExportJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorldExportJobsResponse build() {
            return new ListWorldExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
