/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorldTemplateRequest extends RoboMakerRequest implements
        ToCopyableBuilder<UpdateWorldTemplateRequest.Builder, UpdateWorldTemplateRequest> {
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(UpdateWorldTemplateRequest::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorldTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateBody").getter(getter(UpdateWorldTemplateRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<TemplateLocation> TEMPLATE_LOCATION_FIELD = SdkField
            .<TemplateLocation> builder(MarshallingType.SDK_POJO).memberName("templateLocation")
            .getter(getter(UpdateWorldTemplateRequest::templateLocation)).setter(setter(Builder::templateLocation))
            .constructor(TemplateLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD, NAME_FIELD,
            TEMPLATE_BODY_FIELD, TEMPLATE_LOCATION_FIELD));

    private final String template;

    private final String name;

    private final String templateBody;

    private final TemplateLocation templateLocation;

    private UpdateWorldTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
        this.name = builder.name;
        this.templateBody = builder.templateBody;
        this.templateLocation = builder.templateLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world template to update.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world template to update.
     */
    public String template() {
        return template;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The world template body.
     * </p>
     * 
     * @return The world template body.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The location of the world template.
     * </p>
     * 
     * @return The location of the world template.
     */
    public TemplateLocation templateLocation() {
        return templateLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorldTemplateRequest)) {
            return false;
        }
        UpdateWorldTemplateRequest other = (UpdateWorldTemplateRequest) obj;
        return Objects.equals(template(), other.template()) && Objects.equals(name(), other.name())
                && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateLocation(), other.templateLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateWorldTemplateRequest").add("Template", template()).add("Name", name())
                .add("TemplateBody", templateBody()).add("TemplateLocation", templateLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "templateLocation":
            return Optional.ofNullable(clazz.cast(templateLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorldTemplateRequest, T> g) {
        return obj -> g.apply((UpdateWorldTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorldTemplateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (arn) of the world template to update.
         * </p>
         * 
         * @param template
         *        The Amazon Resource Name (arn) of the world template to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param name
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The world template body.
         * </p>
         * 
         * @param templateBody
         *        The world template body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The location of the world template.
         * </p>
         * 
         * @param templateLocation
         *        The location of the world template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateLocation(TemplateLocation templateLocation);

        /**
         * <p>
         * The location of the world template.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateLocation.Builder} avoiding the need to
         * create one manually via {@link TemplateLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #templateLocation(TemplateLocation)}.
         * 
         * @param templateLocation
         *        a consumer that will call methods on {@link TemplateLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateLocation(TemplateLocation)
         */
        default Builder templateLocation(Consumer<TemplateLocation.Builder> templateLocation) {
            return templateLocation(TemplateLocation.builder().applyMutation(templateLocation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String template;

        private String name;

        private String templateBody;

        private TemplateLocation templateLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorldTemplateRequest model) {
            super(model);
            template(model.template);
            name(model.name);
            templateBody(model.templateBody);
            templateLocation(model.templateLocation);
        }

        public final String getTemplate() {
            return template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final TemplateLocation.Builder getTemplateLocation() {
            return templateLocation != null ? templateLocation.toBuilder() : null;
        }

        @Override
        public final Builder templateLocation(TemplateLocation templateLocation) {
            this.templateLocation = templateLocation;
            return this;
        }

        public final void setTemplateLocation(TemplateLocation.BuilderImpl templateLocation) {
            this.templateLocation = templateLocation != null ? templateLocation.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorldTemplateRequest build() {
            return new UpdateWorldTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
