/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a world export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorldExportJobSummary.Builder, WorldExportJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WorldExportJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorldExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WorldExportJobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<String>> WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("worlds")
            .getter(getter(WorldExportJobSummary::worlds))
            .setter(setter(Builder::worlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, WORLDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final Instant createdAt;

    private final List<String> worlds;

    private WorldExportJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.worlds = builder.worlds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the world export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the world export job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public WorldExportJobStatus status() {
        return WorldExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world export job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world export job was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns true if the Worlds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWorlds() {
        return worlds != null && !(worlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of worlds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorlds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of worlds.
     */
    public List<String> worlds() {
        return worlds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorlds() ? worlds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldExportJobSummary)) {
            return false;
        }
        WorldExportJobSummary other = (WorldExportJobSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && hasWorlds() == other.hasWorlds()
                && Objects.equals(worlds(), other.worlds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WorldExportJobSummary").add("Arn", arn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("Worlds", hasWorlds() ? worlds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "worlds":
            return Optional.ofNullable(clazz.cast(worlds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldExportJobSummary, T> g) {
        return obj -> g.apply((WorldExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldExportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the world export job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the world export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(WorldExportJobStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world export job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A list of worlds.
         * </p>
         * 
         * @param worlds
         *        A list of worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(Collection<String> worlds);

        /**
         * <p>
         * A list of worlds.
         * </p>
         * 
         * @param worlds
         *        A list of worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(String... worlds);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant createdAt;

        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorldExportJobSummary model) {
            arn(model.arn);
            status(model.status);
            createdAt(model.createdAt);
            worlds(model.worlds);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<String> getWorlds() {
            if (worlds instanceof SdkAutoConstructList) {
                return null;
            }
            return worlds;
        }

        @Override
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worlds(String... worlds) {
            worlds(Arrays.asList(worlds));
            return this;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        @Override
        public WorldExportJobSummary build() {
            return new WorldExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
