/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeFleetResponse.Builder, DescribeFleetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeFleetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeFleetResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<Robot>> ROBOTS_FIELD = SdkField
            .<List<Robot>> builder(MarshallingType.LIST)
            .memberName("robots")
            .getter(getter(DescribeFleetResponse::robots))
            .setter(setter(Builder::robots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Robot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Robot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeFleetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastDeploymentStatus").getter(getter(DescribeFleetResponse::lastDeploymentStatusAsString))
            .setter(setter(Builder::lastDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentStatus").build())
            .build();

    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastDeploymentJob").getter(getter(DescribeFleetResponse::lastDeploymentJob))
            .setter(setter(Builder::lastDeploymentJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()).build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastDeploymentTime").getter(getter(DescribeFleetResponse::lastDeploymentTime))
            .setter(setter(Builder::lastDeploymentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeFleetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ROBOTS_FIELD, CREATED_AT_FIELD, LAST_DEPLOYMENT_STATUS_FIELD, LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD,
            TAGS_FIELD));

    private final String name;

    private final String arn;

    private final List<Robot> robots;

    private final Instant createdAt;

    private final String lastDeploymentStatus;

    private final String lastDeploymentJob;

    private final Instant lastDeploymentTime;

    private final Map<String, String> tags;

    private DescribeFleetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.robots = builder.robots;
        this.createdAt = builder.createdAt;
        this.lastDeploymentStatus = builder.lastDeploymentStatus;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns true if the Robots property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRobots() {
        return robots != null && !(robots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of robots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRobots()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of robots.
     */
    public final List<Robot> robots() {
        return robots;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the fleet was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the fleet was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the last deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastDeploymentStatus} will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus lastDeploymentStatus() {
        return DeploymentStatus.fromValue(lastDeploymentStatus);
    }

    /**
     * <p>
     * The status of the last deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastDeploymentStatus} will return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #lastDeploymentStatusAsString}.
     * </p>
     * 
     * @return The status of the last deployment.
     * @see DeploymentStatus
     */
    public final String lastDeploymentStatusAsString() {
        return lastDeploymentStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the last deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the last deployment job.
     */
    public final String lastDeploymentJob() {
        return lastDeploymentJob;
    }

    /**
     * <p>
     * The time of the last deployment.
     * </p>
     * 
     * @return The time of the last deployment.
     */
    public final Instant lastDeploymentTime() {
        return lastDeploymentTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of all tags added to the specified fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all tags added to the specified fleet.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRobots() ? robots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetResponse)) {
            return false;
        }
        DescribeFleetResponse other = (DescribeFleetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && hasRobots() == other.hasRobots()
                && Objects.equals(robots(), other.robots()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastDeploymentStatusAsString(), other.lastDeploymentStatusAsString())
                && Objects.equals(lastDeploymentJob(), other.lastDeploymentJob())
                && Objects.equals(lastDeploymentTime(), other.lastDeploymentTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetResponse").add("Name", name()).add("Arn", arn())
                .add("Robots", hasRobots() ? robots() : null).add("CreatedAt", createdAt())
                .add("LastDeploymentStatus", lastDeploymentStatusAsString()).add("LastDeploymentJob", lastDeploymentJob())
                .add("LastDeploymentTime", lastDeploymentTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "robots":
            return Optional.ofNullable(clazz.cast(robots()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastDeploymentStatus":
            return Optional.ofNullable(clazz.cast(lastDeploymentStatusAsString()));
        case "lastDeploymentJob":
            return Optional.ofNullable(clazz.cast(lastDeploymentJob()));
        case "lastDeploymentTime":
            return Optional.ofNullable(clazz.cast(lastDeploymentTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetResponse, T> g) {
        return obj -> g.apply((DescribeFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetResponse> {
        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of robots.
         * </p>
         * 
         * @param robots
         *        A list of robots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robots(Collection<Robot> robots);

        /**
         * <p>
         * A list of robots.
         * </p>
         * 
         * @param robots
         *        A list of robots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robots(Robot... robots);

        /**
         * <p>
         * A list of robots.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Robot>.Builder} avoiding the need to create
         * one manually via {@link List<Robot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Robot>.Builder#build()} is called immediately and its result
         * is passed to {@link #robots(List<Robot>)}.
         * 
         * @param robots
         *        a consumer that will call methods on {@link List<Robot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robots(List<Robot>)
         */
        Builder robots(Consumer<Robot.Builder>... robots);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the fleet was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the last deployment.
         * </p>
         * 
         * @param lastDeploymentStatus
         *        The status of the last deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder lastDeploymentStatus(String lastDeploymentStatus);

        /**
         * <p>
         * The status of the last deployment.
         * </p>
         * 
         * @param lastDeploymentStatus
         *        The status of the last deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the last deployment job.
         * </p>
         * 
         * @param lastDeploymentJob
         *        The Amazon Resource Name (ARN) of the last deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentJob(String lastDeploymentJob);

        /**
         * <p>
         * The time of the last deployment.
         * </p>
         * 
         * @param lastDeploymentTime
         *        The time of the last deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentTime(Instant lastDeploymentTime);

        /**
         * <p>
         * The list of all tags added to the specified fleet.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private List<Robot> robots = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String lastDeploymentStatus;

        private String lastDeploymentJob;

        private Instant lastDeploymentTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            robots(model.robots);
            createdAt(model.createdAt);
            lastDeploymentStatus(model.lastDeploymentStatus);
            lastDeploymentJob(model.lastDeploymentJob);
            lastDeploymentTime(model.lastDeploymentTime);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<Robot.Builder> getRobots() {
            if (robots instanceof SdkAutoConstructList) {
                return null;
            }
            return robots != null ? robots.stream().map(Robot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robots(Collection<Robot> robots) {
            this.robots = RobotsCopier.copy(robots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Robot... robots) {
            robots(Arrays.asList(robots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robots(Consumer<Robot.Builder>... robots) {
            robots(Stream.of(robots).map(c -> Robot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobots(Collection<Robot.BuilderImpl> robots) {
            this.robots = RobotsCopier.copyFromBuilder(robots);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getLastDeploymentStatus() {
            return lastDeploymentStatus;
        }

        @Override
        public final Builder lastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
            return this;
        }

        @Override
        public final Builder lastDeploymentStatus(DeploymentStatus lastDeploymentStatus) {
            this.lastDeploymentStatus(lastDeploymentStatus == null ? null : lastDeploymentStatus.toString());
            return this;
        }

        public final void setLastDeploymentStatus(String lastDeploymentStatus) {
            this.lastDeploymentStatus = lastDeploymentStatus;
        }

        public final String getLastDeploymentJob() {
            return lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        public final Instant getLastDeploymentTime() {
            return lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeFleetResponse build() {
            return new DescribeFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
