/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteWorldsResponse extends RoboMakerResponse implements
        ToCopyableBuilder<BatchDeleteWorldsResponse.Builder, BatchDeleteWorldsResponse> {
    private static final SdkField<List<String>> UNPROCESSED_WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("unprocessedWorlds")
            .getter(getter(BatchDeleteWorldsResponse::unprocessedWorlds))
            .setter(setter(Builder::unprocessedWorlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedWorlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_WORLDS_FIELD));

    private final List<String> unprocessedWorlds;

    private BatchDeleteWorldsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedWorlds = builder.unprocessedWorlds;
    }

    /**
     * Returns true if the UnprocessedWorlds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedWorlds() {
        return unprocessedWorlds != null && !(unprocessedWorlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unprocessed worlds associated with the call. These worlds were not deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedWorlds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unprocessed worlds associated with the call. These worlds were not deleted.
     */
    public final List<String> unprocessedWorlds() {
        return unprocessedWorlds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedWorlds() ? unprocessedWorlds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteWorldsResponse)) {
            return false;
        }
        BatchDeleteWorldsResponse other = (BatchDeleteWorldsResponse) obj;
        return hasUnprocessedWorlds() == other.hasUnprocessedWorlds()
                && Objects.equals(unprocessedWorlds(), other.unprocessedWorlds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteWorldsResponse")
                .add("UnprocessedWorlds", hasUnprocessedWorlds() ? unprocessedWorlds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unprocessedWorlds":
            return Optional.ofNullable(clazz.cast(unprocessedWorlds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteWorldsResponse, T> g) {
        return obj -> g.apply((BatchDeleteWorldsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteWorldsResponse> {
        /**
         * <p>
         * A list of unprocessed worlds associated with the call. These worlds were not deleted.
         * </p>
         * 
         * @param unprocessedWorlds
         *        A list of unprocessed worlds associated with the call. These worlds were not deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedWorlds(Collection<String> unprocessedWorlds);

        /**
         * <p>
         * A list of unprocessed worlds associated with the call. These worlds were not deleted.
         * </p>
         * 
         * @param unprocessedWorlds
         *        A list of unprocessed worlds associated with the call. These worlds were not deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedWorlds(String... unprocessedWorlds);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<String> unprocessedWorlds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteWorldsResponse model) {
            super(model);
            unprocessedWorlds(model.unprocessedWorlds);
        }

        public final Collection<String> getUnprocessedWorlds() {
            if (unprocessedWorlds instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedWorlds;
        }

        @Override
        public final Builder unprocessedWorlds(Collection<String> unprocessedWorlds) {
            this.unprocessedWorlds = ArnsCopier.copy(unprocessedWorlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedWorlds(String... unprocessedWorlds) {
            unprocessedWorlds(Arrays.asList(unprocessedWorlds));
            return this;
        }

        public final void setUnprocessedWorlds(Collection<String> unprocessedWorlds) {
            this.unprocessedWorlds = ArnsCopier.copy(unprocessedWorlds);
        }

        @Override
        public BatchDeleteWorldsResponse build() {
            return new BatchDeleteWorldsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
