/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfig.Builder, DeploymentConfig> {
    private static final SdkField<Integer> CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("concurrentDeploymentPercentage")
            .getter(getter(DeploymentConfig::concurrentDeploymentPercentage))
            .setter(setter(Builder::concurrentDeploymentPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentDeploymentPercentage")
                    .build()).build();

    private static final SdkField<Integer> FAILURE_THRESHOLD_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("failureThresholdPercentage")
            .getter(getter(DeploymentConfig::failureThresholdPercentage))
            .setter(setter(Builder::failureThresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureThresholdPercentage").build())
            .build();

    private static final SdkField<Long> ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("robotDeploymentTimeoutInSeconds")
            .getter(getter(DeploymentConfig::robotDeploymentTimeoutInSeconds))
            .setter(setter(Builder::robotDeploymentTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotDeploymentTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<S3Object> DOWNLOAD_CONDITION_FILE_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("downloadConditionFile").getter(getter(DeploymentConfig::downloadConditionFile))
            .setter(setter(Builder::downloadConditionFile)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadConditionFile").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD, FAILURE_THRESHOLD_PERCENTAGE_FIELD,
            ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD, DOWNLOAD_CONDITION_FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer concurrentDeploymentPercentage;

    private final Integer failureThresholdPercentage;

    private final Long robotDeploymentTimeoutInSeconds;

    private final S3Object downloadConditionFile;

    private DeploymentConfig(BuilderImpl builder) {
        this.concurrentDeploymentPercentage = builder.concurrentDeploymentPercentage;
        this.failureThresholdPercentage = builder.failureThresholdPercentage;
        this.robotDeploymentTimeoutInSeconds = builder.robotDeploymentTimeoutInSeconds;
        this.downloadConditionFile = builder.downloadConditionFile;
    }

    /**
     * <p>
     * The percentage of robots receiving the deployment at the same time.
     * </p>
     * 
     * @return The percentage of robots receiving the deployment at the same time.
     */
    public final Integer concurrentDeploymentPercentage() {
        return concurrentDeploymentPercentage;
    }

    /**
     * <p>
     * The percentage of deployments that need to fail before stopping deployment.
     * </p>
     * 
     * @return The percentage of deployments that need to fail before stopping deployment.
     */
    public final Integer failureThresholdPercentage() {
        return failureThresholdPercentage;
    }

    /**
     * <p>
     * The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1
     * minute and 7 days. The default is 5 hours.
     * </p>
     * 
     * @return The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time
     *         between 1 minute and 7 days. The default is 5 hours.
     */
    public final Long robotDeploymentTimeoutInSeconds() {
        return robotDeploymentTimeoutInSeconds;
    }

    /**
     * <p>
     * The download condition file.
     * </p>
     * 
     * @return The download condition file.
     */
    public final S3Object downloadConditionFile() {
        return downloadConditionFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(concurrentDeploymentPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(failureThresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(robotDeploymentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(downloadConditionFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig) obj;
        return Objects.equals(concurrentDeploymentPercentage(), other.concurrentDeploymentPercentage())
                && Objects.equals(failureThresholdPercentage(), other.failureThresholdPercentage())
                && Objects.equals(robotDeploymentTimeoutInSeconds(), other.robotDeploymentTimeoutInSeconds())
                && Objects.equals(downloadConditionFile(), other.downloadConditionFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentConfig").add("ConcurrentDeploymentPercentage", concurrentDeploymentPercentage())
                .add("FailureThresholdPercentage", failureThresholdPercentage())
                .add("RobotDeploymentTimeoutInSeconds", robotDeploymentTimeoutInSeconds())
                .add("DownloadConditionFile", downloadConditionFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "concurrentDeploymentPercentage":
            return Optional.ofNullable(clazz.cast(concurrentDeploymentPercentage()));
        case "failureThresholdPercentage":
            return Optional.ofNullable(clazz.cast(failureThresholdPercentage()));
        case "robotDeploymentTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(robotDeploymentTimeoutInSeconds()));
        case "downloadConditionFile":
            return Optional.ofNullable(clazz.cast(downloadConditionFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfig> {
        /**
         * <p>
         * The percentage of robots receiving the deployment at the same time.
         * </p>
         * 
         * @param concurrentDeploymentPercentage
         *        The percentage of robots receiving the deployment at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentDeploymentPercentage(Integer concurrentDeploymentPercentage);

        /**
         * <p>
         * The percentage of deployments that need to fail before stopping deployment.
         * </p>
         * 
         * @param failureThresholdPercentage
         *        The percentage of deployments that need to fail before stopping deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThresholdPercentage(Integer failureThresholdPercentage);

        /**
         * <p>
         * The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1
         * minute and 7 days. The default is 5 hours.
         * </p>
         * 
         * @param robotDeploymentTimeoutInSeconds
         *        The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time
         *        between 1 minute and 7 days. The default is 5 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds);

        /**
         * <p>
         * The download condition file.
         * </p>
         * 
         * @param downloadConditionFile
         *        The download condition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadConditionFile(S3Object downloadConditionFile);

        /**
         * <p>
         * The download condition file.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Object.Builder} avoiding the need to create
         * one manually via {@link S3Object#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #downloadConditionFile(S3Object)}.
         * 
         * @param downloadConditionFile
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downloadConditionFile(S3Object)
         */
        default Builder downloadConditionFile(Consumer<S3Object.Builder> downloadConditionFile) {
            return downloadConditionFile(S3Object.builder().applyMutation(downloadConditionFile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer concurrentDeploymentPercentage;

        private Integer failureThresholdPercentage;

        private Long robotDeploymentTimeoutInSeconds;

        private S3Object downloadConditionFile;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            concurrentDeploymentPercentage(model.concurrentDeploymentPercentage);
            failureThresholdPercentage(model.failureThresholdPercentage);
            robotDeploymentTimeoutInSeconds(model.robotDeploymentTimeoutInSeconds);
            downloadConditionFile(model.downloadConditionFile);
        }

        public final Integer getConcurrentDeploymentPercentage() {
            return concurrentDeploymentPercentage;
        }

        @Override
        public final Builder concurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
            return this;
        }

        public final void setConcurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
        }

        public final Integer getFailureThresholdPercentage() {
            return failureThresholdPercentage;
        }

        @Override
        public final Builder failureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
            return this;
        }

        public final void setFailureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
        }

        public final Long getRobotDeploymentTimeoutInSeconds() {
            return robotDeploymentTimeoutInSeconds;
        }

        @Override
        public final Builder robotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
            return this;
        }

        public final void setRobotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
        }

        public final S3Object.Builder getDownloadConditionFile() {
            return downloadConditionFile != null ? downloadConditionFile.toBuilder() : null;
        }

        @Override
        public final Builder downloadConditionFile(S3Object downloadConditionFile) {
            this.downloadConditionFile = downloadConditionFile;
            return this;
        }

        public final void setDownloadConditionFile(S3Object.BuilderImpl downloadConditionFile) {
            this.downloadConditionFile = downloadConditionFile != null ? downloadConditionFile.build() : null;
        }

        @Override
        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
