/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorldResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, DescribeWorldResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DescribeWorldResponse.getter(DescribeWorldResponse::arn)).setter(DescribeWorldResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> GENERATION_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationJob").getter(DescribeWorldResponse.getter(DescribeWorldResponse::generationJob)).setter(DescribeWorldResponse.setter(Builder::generationJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationJob").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(DescribeWorldResponse.getter(DescribeWorldResponse::template)).setter(DescribeWorldResponse.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeWorldResponse.getter(DescribeWorldResponse::createdAt)).setter(DescribeWorldResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeWorldResponse.getter(DescribeWorldResponse::tags)).setter(DescribeWorldResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, GENERATION_JOB_FIELD, TEMPLATE_FIELD, CREATED_AT_FIELD, TAGS_FIELD));
    private final String arn;
    private final String generationJob;
    private final String template;
    private final Instant createdAt;
    private final Map<String, String> tags;

    private DescribeWorldResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.generationJob = builder.generationJob;
        this.template = builder.template;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String generationJob() {
        return this.generationJob;
    }

    public final String template() {
        return this.template;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorldResponse)) {
            return false;
        }
        DescribeWorldResponse other = (DescribeWorldResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.generationJob(), other.generationJob()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorldResponse").add("Arn", (Object)this.arn()).add("GenerationJob", (Object)this.generationJob()).add("Template", (Object)this.template()).add("CreatedAt", (Object)this.createdAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "generationJob": {
                return Optional.ofNullable(clazz.cast(this.generationJob()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorldResponse, T> g) {
        return obj -> g.apply((DescribeWorldResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String generationJob;
        private String template;
        private Instant createdAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorldResponse model) {
            super(model);
            this.arn(model.arn);
            this.generationJob(model.generationJob);
            this.template(model.template);
            this.createdAt(model.createdAt);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getGenerationJob() {
            return this.generationJob;
        }

        @Override
        public final Builder generationJob(String generationJob) {
            this.generationJob = generationJob;
            return this;
        }

        public final void setGenerationJob(String generationJob) {
            this.generationJob = generationJob;
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeWorldResponse build() {
            return new DescribeWorldResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorldResponse> {
        public Builder arn(String var1);

        public Builder generationJob(String var1);

        public Builder template(String var1);

        public Builder createdAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

