/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeSimulationJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<BatchDescribeSimulationJobResponse.Builder, BatchDescribeSimulationJobResponse> {
    private static final SdkField<List<SimulationJob>> JOBS_FIELD = SdkField
            .<List<SimulationJob>> builder(MarshallingType.LIST)
            .memberName("jobs")
            .getter(getter(BatchDescribeSimulationJobResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> UNPROCESSED_JOBS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("unprocessedJobs")
            .getter(getter(BatchDescribeSimulationJobResponse::unprocessedJobs))
            .setter(setter(Builder::unprocessedJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            UNPROCESSED_JOBS_FIELD));

    private final List<SimulationJob> jobs;

    private final List<String> unprocessedJobs;

    private BatchDescribeSimulationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.unprocessedJobs = builder.unprocessedJobs;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of simulation jobs.
     */
    public final List<SimulationJob> jobs() {
        return jobs;
    }

    /**
     * Returns true if the UnprocessedJobs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedJobs() {
        return unprocessedJobs != null && !(unprocessedJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unprocessed simulation job Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unprocessed simulation job Amazon Resource Names (ARNs).
     */
    public final List<String> unprocessedJobs() {
        return unprocessedJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedJobs() ? unprocessedJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeSimulationJobResponse)) {
            return false;
        }
        BatchDescribeSimulationJobResponse other = (BatchDescribeSimulationJobResponse) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && hasUnprocessedJobs() == other.hasUnprocessedJobs()
                && Objects.equals(unprocessedJobs(), other.unprocessedJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeSimulationJobResponse").add("Jobs", hasJobs() ? jobs() : null)
                .add("UnprocessedJobs", hasUnprocessedJobs() ? unprocessedJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "unprocessedJobs":
            return Optional.ofNullable(clazz.cast(unprocessedJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeSimulationJobResponse, T> g) {
        return obj -> g.apply((BatchDescribeSimulationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeSimulationJobResponse> {
        /**
         * <p>
         * A list of simulation jobs.
         * </p>
         * 
         * @param jobs
         *        A list of simulation jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<SimulationJob> jobs);

        /**
         * <p>
         * A list of simulation jobs.
         * </p>
         * 
         * @param jobs
         *        A list of simulation jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(SimulationJob... jobs);

        /**
         * <p>
         * A list of simulation jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJob>.Builder} avoiding the need
         * to create one manually via {@link List<SimulationJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobs(List<SimulationJob>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<SimulationJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<SimulationJob>)
         */
        Builder jobs(Consumer<SimulationJob.Builder>... jobs);

        /**
         * <p>
         * A list of unprocessed simulation job Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param unprocessedJobs
         *        A list of unprocessed simulation job Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedJobs(Collection<String> unprocessedJobs);

        /**
         * <p>
         * A list of unprocessed simulation job Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param unprocessedJobs
         *        A list of unprocessed simulation job Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedJobs(String... unprocessedJobs);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<SimulationJob> jobs = DefaultSdkAutoConstructList.getInstance();

        private List<String> unprocessedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeSimulationJobResponse model) {
            super(model);
            jobs(model.jobs);
            unprocessedJobs(model.unprocessedJobs);
        }

        public final List<SimulationJob.Builder> getJobs() {
            List<SimulationJob.Builder> result = SimulationJobsCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder jobs(Collection<SimulationJob> jobs) {
            this.jobs = SimulationJobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(SimulationJob... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<SimulationJob.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> SimulationJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<SimulationJob.BuilderImpl> jobs) {
            this.jobs = SimulationJobsCopier.copyFromBuilder(jobs);
        }

        public final Collection<String> getUnprocessedJobs() {
            if (unprocessedJobs instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedJobs;
        }

        @Override
        public final Builder unprocessedJobs(Collection<String> unprocessedJobs) {
            this.unprocessedJobs = ArnsCopier.copy(unprocessedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedJobs(String... unprocessedJobs) {
            unprocessedJobs(Arrays.asList(unprocessedJobs));
            return this;
        }

        public final void setUnprocessedJobs(Collection<String> unprocessedJobs) {
            this.unprocessedJobs = ArnsCopier.copy(unprocessedJobs);
        }

        @Override
        public BatchDescribeSimulationJobResponse build() {
            return new BatchDescribeSimulationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
