/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRobotApplicationRequest extends RoboMakerRequest implements
        ToCopyableBuilder<UpdateRobotApplicationRequest.Builder, UpdateRobotApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(UpdateRobotApplicationRequest::application))
            .setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<List<SourceConfig>> SOURCES_FIELD = SdkField
            .<List<SourceConfig>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(UpdateRobotApplicationRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField
            .<RobotSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("robotSoftwareSuite")
            .getter(getter(UpdateRobotApplicationRequest::robotSoftwareSuite)).setter(setter(Builder::robotSoftwareSuite))
            .constructor(RobotSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build())
            .build();

    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentRevisionId").getter(getter(UpdateRobotApplicationRequest::currentRevisionId))
            .setter(setter(Builder::currentRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            SOURCES_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, CURRENT_REVISION_ID_FIELD));

    private final String application;

    private final List<SourceConfig> sources;

    private final RobotSoftwareSuite robotSoftwareSuite;

    private final String currentRevisionId;

    private UpdateRobotApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.sources = builder.sources;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.currentRevisionId = builder.currentRevisionId;
    }

    /**
     * <p>
     * The application information for the robot application.
     * </p>
     * 
     * @return The application information for the robot application.
     */
    public final String application() {
        return application;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the robot application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sources of the robot application.
     */
    public final List<SourceConfig> sources() {
        return sources;
    }

    /**
     * <p>
     * The robot software suite (ROS distribution) used by the robot application.
     * </p>
     * 
     * @return The robot software suite (ROS distribution) used by the robot application.
     */
    public final RobotSoftwareSuite robotSoftwareSuite() {
        return robotSoftwareSuite;
    }

    /**
     * <p>
     * The revision id for the robot application.
     * </p>
     * 
     * @return The revision id for the robot application.
     */
    public final String currentRevisionId() {
        return currentRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRobotApplicationRequest)) {
            return false;
        }
        UpdateRobotApplicationRequest other = (UpdateRobotApplicationRequest) obj;
        return Objects.equals(application(), other.application()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(robotSoftwareSuite(), other.robotSoftwareSuite())
                && Objects.equals(currentRevisionId(), other.currentRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRobotApplicationRequest").add("Application", application())
                .add("Sources", hasSources() ? sources() : null).add("RobotSoftwareSuite", robotSoftwareSuite())
                .add("CurrentRevisionId", currentRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "robotSoftwareSuite":
            return Optional.ofNullable(clazz.cast(robotSoftwareSuite()));
        case "currentRevisionId":
            return Optional.ofNullable(clazz.cast(currentRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRobotApplicationRequest, T> g) {
        return obj -> g.apply((UpdateRobotApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRobotApplicationRequest> {
        /**
         * <p>
         * The application information for the robot application.
         * </p>
         * 
         * @param application
         *        The application information for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The sources of the robot application.
         * </p>
         * 
         * @param sources
         *        The sources of the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SourceConfig> sources);

        /**
         * <p>
         * The sources of the robot application.
         * </p>
         * 
         * @param sources
         *        The sources of the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SourceConfig... sources);

        /**
         * <p>
         * The sources of the robot application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceConfig>.Builder} avoiding the need to
         * create one manually via {@link List<SourceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<SourceConfig>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<SourceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<SourceConfig>)
         */
        Builder sources(Consumer<SourceConfig.Builder>... sources);

        /**
         * <p>
         * The robot software suite (ROS distribution) used by the robot application.
         * </p>
         * 
         * @param robotSoftwareSuite
         *        The robot software suite (ROS distribution) used by the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite);

        /**
         * <p>
         * The robot software suite (ROS distribution) used by the robot application.
         * </p>
         * This is a convenience that creates an instance of the {@link RobotSoftwareSuite.Builder} avoiding the need to
         * create one manually via {@link RobotSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link RobotSoftwareSuite.Builder#build()} is called immediately and its
         * result is passed to {@link #robotSoftwareSuite(RobotSoftwareSuite)}.
         * 
         * @param robotSoftwareSuite
         *        a consumer that will call methods on {@link RobotSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotSoftwareSuite(RobotSoftwareSuite)
         */
        default Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return robotSoftwareSuite(RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite).build());
        }

        /**
         * <p>
         * The revision id for the robot application.
         * </p>
         * 
         * @param currentRevisionId
         *        The revision id for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevisionId(String currentRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String application;

        private List<SourceConfig> sources = DefaultSdkAutoConstructList.getInstance();

        private RobotSoftwareSuite robotSoftwareSuite;

        private String currentRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRobotApplicationRequest model) {
            super(model);
            application(model.application);
            sources(model.sources);
            robotSoftwareSuite(model.robotSoftwareSuite);
            currentRevisionId(model.currentRevisionId);
        }

        public final String getApplication() {
            return application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final List<SourceConfig.Builder> getSources() {
            List<SourceConfig.Builder> result = SourceConfigsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sources(Collection<SourceConfig> sources) {
            this.sources = SourceConfigsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfig... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfig.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SourceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<SourceConfig.BuilderImpl> sources) {
            this.sources = SourceConfigsCopier.copyFromBuilder(sources);
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return robotSoftwareSuite != null ? robotSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        public final String getCurrentRevisionId() {
            return currentRevisionId;
        }

        @Override
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRobotApplicationRequest build() {
            return new UpdateRobotApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
