/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSimulationApplicationRequest extends RoboMakerRequest implements
        ToCopyableBuilder<CreateSimulationApplicationRequest.Builder, CreateSimulationApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSimulationApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<SourceConfig>> SOURCES_FIELD = SdkField
            .<List<SourceConfig>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(CreateSimulationApplicationRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SimulationSoftwareSuite> SIMULATION_SOFTWARE_SUITE_FIELD = SdkField
            .<SimulationSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("simulationSoftwareSuite")
            .getter(getter(CreateSimulationApplicationRequest::simulationSoftwareSuite))
            .setter(setter(Builder::simulationSoftwareSuite)).constructor(SimulationSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationSoftwareSuite").build())
            .build();

    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField
            .<RobotSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("robotSoftwareSuite")
            .getter(getter(CreateSimulationApplicationRequest::robotSoftwareSuite)).setter(setter(Builder::robotSoftwareSuite))
            .constructor(RobotSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build())
            .build();

    private static final SdkField<RenderingEngine> RENDERING_ENGINE_FIELD = SdkField
            .<RenderingEngine> builder(MarshallingType.SDK_POJO).memberName("renderingEngine")
            .getter(getter(CreateSimulationApplicationRequest::renderingEngine)).setter(setter(Builder::renderingEngine))
            .constructor(RenderingEngine::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingEngine").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSimulationApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCES_FIELD,
            SIMULATION_SOFTWARE_SUITE_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, RENDERING_ENGINE_FIELD, TAGS_FIELD));

    private final String name;

    private final List<SourceConfig> sources;

    private final SimulationSoftwareSuite simulationSoftwareSuite;

    private final RobotSoftwareSuite robotSoftwareSuite;

    private final RenderingEngine renderingEngine;

    private final Map<String, String> tags;

    private CreateSimulationApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sources = builder.sources;
        this.simulationSoftwareSuite = builder.simulationSoftwareSuite;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.renderingEngine = builder.renderingEngine;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the simulation application.
     * </p>
     * 
     * @return The name of the simulation application.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sources of the simulation application.
     */
    public final List<SourceConfig> sources() {
        return sources;
    }

    /**
     * <p>
     * The simulation software suite used by the simulation application.
     * </p>
     * 
     * @return The simulation software suite used by the simulation application.
     */
    public final SimulationSoftwareSuite simulationSoftwareSuite() {
        return simulationSoftwareSuite;
    }

    /**
     * <p>
     * The robot software suite (ROS distribution) used by the simulation application.
     * </p>
     * 
     * @return The robot software suite (ROS distribution) used by the simulation application.
     */
    public final RobotSoftwareSuite robotSoftwareSuite() {
        return robotSoftwareSuite;
    }

    /**
     * <p>
     * The rendering engine for the simulation application.
     * </p>
     * 
     * @return The rendering engine for the simulation application.
     */
    public final RenderingEngine renderingEngine() {
        return renderingEngine;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the simulation application.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(simulationSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(renderingEngine());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationApplicationRequest)) {
            return false;
        }
        CreateSimulationApplicationRequest other = (CreateSimulationApplicationRequest) obj;
        return Objects.equals(name(), other.name()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources())
                && Objects.equals(simulationSoftwareSuite(), other.simulationSoftwareSuite())
                && Objects.equals(robotSoftwareSuite(), other.robotSoftwareSuite())
                && Objects.equals(renderingEngine(), other.renderingEngine()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSimulationApplicationRequest").add("Name", name())
                .add("Sources", hasSources() ? sources() : null).add("SimulationSoftwareSuite", simulationSoftwareSuite())
                .add("RobotSoftwareSuite", robotSoftwareSuite()).add("RenderingEngine", renderingEngine())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "simulationSoftwareSuite":
            return Optional.ofNullable(clazz.cast(simulationSoftwareSuite()));
        case "robotSoftwareSuite":
            return Optional.ofNullable(clazz.cast(robotSoftwareSuite()));
        case "renderingEngine":
            return Optional.ofNullable(clazz.cast(renderingEngine()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationApplicationRequest, T> g) {
        return obj -> g.apply((CreateSimulationApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSimulationApplicationRequest> {
        /**
         * <p>
         * The name of the simulation application.
         * </p>
         * 
         * @param name
         *        The name of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SourceConfig> sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SourceConfig... sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceConfig>.Builder} avoiding the need to
         * create one manually via {@link List<SourceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<SourceConfig>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<SourceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<SourceConfig>)
         */
        Builder sources(Consumer<SourceConfig.Builder>... sources);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * 
         * @param simulationSoftwareSuite
         *        The simulation software suite used by the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link SimulationSoftwareSuite.Builder} avoiding the
         * need to create one manually via {@link SimulationSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimulationSoftwareSuite.Builder#build()} is called immediately
         * and its result is passed to {@link #simulationSoftwareSuite(SimulationSoftwareSuite)}.
         * 
         * @param simulationSoftwareSuite
         *        a consumer that will call methods on {@link SimulationSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationSoftwareSuite(SimulationSoftwareSuite)
         */
        default Builder simulationSoftwareSuite(Consumer<SimulationSoftwareSuite.Builder> simulationSoftwareSuite) {
            return simulationSoftwareSuite(SimulationSoftwareSuite.builder().applyMutation(simulationSoftwareSuite).build());
        }

        /**
         * <p>
         * The robot software suite (ROS distribution) used by the simulation application.
         * </p>
         * 
         * @param robotSoftwareSuite
         *        The robot software suite (ROS distribution) used by the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite);

        /**
         * <p>
         * The robot software suite (ROS distribution) used by the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link RobotSoftwareSuite.Builder} avoiding the need to
         * create one manually via {@link RobotSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link RobotSoftwareSuite.Builder#build()} is called immediately and its
         * result is passed to {@link #robotSoftwareSuite(RobotSoftwareSuite)}.
         * 
         * @param robotSoftwareSuite
         *        a consumer that will call methods on {@link RobotSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotSoftwareSuite(RobotSoftwareSuite)
         */
        default Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return robotSoftwareSuite(RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite).build());
        }

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * 
         * @param renderingEngine
         *        The rendering engine for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingEngine(RenderingEngine renderingEngine);

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link RenderingEngine.Builder} avoiding the need to
         * create one manually via {@link RenderingEngine#builder()}.
         *
         * When the {@link Consumer} completes, {@link RenderingEngine.Builder#build()} is called immediately and its
         * result is passed to {@link #renderingEngine(RenderingEngine)}.
         * 
         * @param renderingEngine
         *        a consumer that will call methods on {@link RenderingEngine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingEngine(RenderingEngine)
         */
        default Builder renderingEngine(Consumer<RenderingEngine.Builder> renderingEngine) {
            return renderingEngine(RenderingEngine.builder().applyMutation(renderingEngine).build());
        }

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the simulation application.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String name;

        private List<SourceConfig> sources = DefaultSdkAutoConstructList.getInstance();

        private SimulationSoftwareSuite simulationSoftwareSuite;

        private RobotSoftwareSuite robotSoftwareSuite;

        private RenderingEngine renderingEngine;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationApplicationRequest model) {
            super(model);
            name(model.name);
            sources(model.sources);
            simulationSoftwareSuite(model.simulationSoftwareSuite);
            robotSoftwareSuite(model.robotSoftwareSuite);
            renderingEngine(model.renderingEngine);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<SourceConfig.Builder> getSources() {
            List<SourceConfig.Builder> result = SourceConfigsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sources(Collection<SourceConfig> sources) {
            this.sources = SourceConfigsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfig... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfig.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SourceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<SourceConfig.BuilderImpl> sources) {
            this.sources = SourceConfigsCopier.copyFromBuilder(sources);
        }

        public final SimulationSoftwareSuite.Builder getSimulationSoftwareSuite() {
            return simulationSoftwareSuite != null ? simulationSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        public final void setSimulationSoftwareSuite(SimulationSoftwareSuite.BuilderImpl simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite != null ? simulationSoftwareSuite.build() : null;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return robotSoftwareSuite != null ? robotSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        public final RenderingEngine.Builder getRenderingEngine() {
            return renderingEngine != null ? renderingEngine.toBuilder() : null;
        }

        @Override
        public final Builder renderingEngine(RenderingEngine renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        public final void setRenderingEngine(RenderingEngine.BuilderImpl renderingEngine) {
            this.renderingEngine = renderingEngine != null ? renderingEngine.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSimulationApplicationRequest build() {
            return new CreateSimulationApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
