/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application configuration information for a robot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RobotApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RobotApplicationConfig.Builder, RobotApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(RobotApplicationConfig::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationVersion").getter(getter(RobotApplicationConfig::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.<LaunchConfig> builder(MarshallingType.SDK_POJO)
            .memberName("launchConfig").getter(getter(RobotApplicationConfig::launchConfig))
            .setter(setter(Builder::launchConfig)).constructor(LaunchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()).build();

    private static final SdkField<List<UploadConfiguration>> UPLOAD_CONFIGURATIONS_FIELD = SdkField
            .<List<UploadConfiguration>> builder(MarshallingType.LIST)
            .memberName("uploadConfigurations")
            .getter(getter(RobotApplicationConfig::uploadConfigurations))
            .setter(setter(Builder::uploadConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UploadConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(UploadConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDefaultUploadConfigurations")
            .getter(getter(RobotApplicationConfig::useDefaultUploadConfigurations))
            .setter(setter(Builder::useDefaultUploadConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultUploadConfigurations")
                    .build()).build();

    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField
            .<List<Tool>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(RobotApplicationConfig::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_TOOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDefaultTools").getter(getter(RobotApplicationConfig::useDefaultTools))
            .setter(setter(Builder::useDefaultTools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultTools").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, UPLOAD_CONFIGURATIONS_FIELD, USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD,
            TOOLS_FIELD, USE_DEFAULT_TOOLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String application;

    private final String applicationVersion;

    private final LaunchConfig launchConfig;

    private final List<UploadConfiguration> uploadConfigurations;

    private final Boolean useDefaultUploadConfigurations;

    private final List<Tool> tools;

    private final Boolean useDefaultTools;

    private RobotApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.uploadConfigurations = builder.uploadConfigurations;
        this.useDefaultUploadConfigurations = builder.useDefaultUploadConfigurations;
        this.tools = builder.tools;
        this.useDefaultTools = builder.useDefaultTools;
    }

    /**
     * <p>
     * The application information for the robot application.
     * </p>
     * 
     * @return The application information for the robot application.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The version of the robot application.
     * </p>
     * 
     * @return The version of the robot application.
     */
    public final String applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The launch configuration for the robot application.
     * </p>
     * 
     * @return The launch configuration for the robot application.
     */
    public final LaunchConfig launchConfig() {
        return launchConfig;
    }

    /**
     * Returns true if the UploadConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUploadConfigurations() {
        return uploadConfigurations != null && !(uploadConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The upload configurations for the robot application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUploadConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The upload configurations for the robot application.
     */
    public final List<UploadConfiguration> uploadConfigurations() {
        return uploadConfigurations;
    }

    /**
     * <p>
     * A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
     * <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.
     * </p>
     * <p>
     * If you set this value, you must specify an <code>outputLocation</code>.
     * </p>
     * 
     * @return A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
     *         <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be
     *         recorded.</p>
     *         <p>
     *         If you set this value, you must specify an <code>outputLocation</code>.
     */
    public final Boolean useDefaultUploadConfigurations() {
        return useDefaultUploadConfigurations;
    }

    /**
     * Returns true if the Tools property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about tools configured for the robot application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTools()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about tools configured for the robot application.
     */
    public final List<Tool> tools() {
        return tools;
    }

    /**
     * <p>
     * A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt, terminal
     * and rosbag record. The default is <code>False</code>.
     * </p>
     * 
     * @return A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt,
     *         terminal and rosbag record. The default is <code>False</code>.
     */
    public final Boolean useDefaultTools() {
        return useDefaultTools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasUploadConfigurations() ? uploadConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultUploadConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultTools());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotApplicationConfig)) {
            return false;
        }
        RobotApplicationConfig other = (RobotApplicationConfig) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(launchConfig(), other.launchConfig())
                && hasUploadConfigurations() == other.hasUploadConfigurations()
                && Objects.equals(uploadConfigurations(), other.uploadConfigurations())
                && Objects.equals(useDefaultUploadConfigurations(), other.useDefaultUploadConfigurations())
                && hasTools() == other.hasTools() && Objects.equals(tools(), other.tools())
                && Objects.equals(useDefaultTools(), other.useDefaultTools());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RobotApplicationConfig").add("Application", application())
                .add("ApplicationVersion", applicationVersion()).add("LaunchConfig", launchConfig())
                .add("UploadConfigurations", hasUploadConfigurations() ? uploadConfigurations() : null)
                .add("UseDefaultUploadConfigurations", useDefaultUploadConfigurations())
                .add("Tools", hasTools() ? tools() : null).add("UseDefaultTools", useDefaultTools()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "launchConfig":
            return Optional.ofNullable(clazz.cast(launchConfig()));
        case "uploadConfigurations":
            return Optional.ofNullable(clazz.cast(uploadConfigurations()));
        case "useDefaultUploadConfigurations":
            return Optional.ofNullable(clazz.cast(useDefaultUploadConfigurations()));
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "useDefaultTools":
            return Optional.ofNullable(clazz.cast(useDefaultTools()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotApplicationConfig, T> g) {
        return obj -> g.apply((RobotApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RobotApplicationConfig> {
        /**
         * <p>
         * The application information for the robot application.
         * </p>
         * 
         * @param application
         *        The application information for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The version of the robot application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(String applicationVersion);

        /**
         * <p>
         * The launch configuration for the robot application.
         * </p>
         * 
         * @param launchConfig
         *        The launch configuration for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfig(LaunchConfig launchConfig);

        /**
         * <p>
         * The launch configuration for the robot application.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchConfig.Builder} avoiding the need to
         * create one manually via {@link LaunchConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #launchConfig(LaunchConfig)}.
         * 
         * @param launchConfig
         *        a consumer that will call methods on {@link LaunchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfig(LaunchConfig)
         */
        default Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return launchConfig(LaunchConfig.builder().applyMutation(launchConfig).build());
        }

        /**
         * <p>
         * The upload configurations for the robot application.
         * </p>
         * 
         * @param uploadConfigurations
         *        The upload configurations for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations);

        /**
         * <p>
         * The upload configurations for the robot application.
         * </p>
         * 
         * @param uploadConfigurations
         *        The upload configurations for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadConfigurations(UploadConfiguration... uploadConfigurations);

        /**
         * <p>
         * The upload configurations for the robot application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UploadConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<UploadConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UploadConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #uploadConfigurations(List<UploadConfiguration>)}.
         * 
         * @param uploadConfigurations
         *        a consumer that will call methods on {@link List<UploadConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadConfigurations(List<UploadConfiguration>)
         */
        Builder uploadConfigurations(Consumer<UploadConfiguration.Builder>... uploadConfigurations);

        /**
         * <p>
         * A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
         * <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.
         * </p>
         * <p>
         * If you set this value, you must specify an <code>outputLocation</code>.
         * </p>
         * 
         * @param useDefaultUploadConfigurations
         *        A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
         *        <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be
         *        recorded.</p>
         *        <p>
         *        If you set this value, you must specify an <code>outputLocation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations);

        /**
         * <p>
         * Information about tools configured for the robot application.
         * </p>
         * 
         * @param tools
         *        Information about tools configured for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<Tool> tools);

        /**
         * <p>
         * Information about tools configured for the robot application.
         * </p>
         * 
         * @param tools
         *        Information about tools configured for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Tool... tools);

        /**
         * <p>
         * Information about tools configured for the robot application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tool>.Builder} avoiding the need to create
         * one manually via {@link List<Tool>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tool>.Builder#build()} is called immediately and its result
         * is passed to {@link #tools(List<Tool>)}.
         * 
         * @param tools
         *        a consumer that will call methods on {@link List<Tool>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tools(List<Tool>)
         */
        Builder tools(Consumer<Tool.Builder>... tools);

        /**
         * <p>
         * A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt,
         * terminal and rosbag record. The default is <code>False</code>.
         * </p>
         * 
         * @param useDefaultTools
         *        A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt,
         *        terminal and rosbag record. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDefaultTools(Boolean useDefaultTools);
    }

    static final class BuilderImpl implements Builder {
        private String application;

        private String applicationVersion;

        private LaunchConfig launchConfig;

        private List<UploadConfiguration> uploadConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultUploadConfigurations;

        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultTools;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotApplicationConfig model) {
            application(model.application);
            applicationVersion(model.applicationVersion);
            launchConfig(model.launchConfig);
            uploadConfigurations(model.uploadConfigurations);
            useDefaultUploadConfigurations(model.useDefaultUploadConfigurations);
            tools(model.tools);
            useDefaultTools(model.useDefaultTools);
        }

        public final String getApplication() {
            return application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return launchConfig != null ? launchConfig.toBuilder() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        public final List<UploadConfiguration.Builder> getUploadConfigurations() {
            List<UploadConfiguration.Builder> result = UploadConfigurationsCopier.copyToBuilder(this.uploadConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copy(uploadConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(UploadConfiguration... uploadConfigurations) {
            uploadConfigurations(Arrays.asList(uploadConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(Consumer<UploadConfiguration.Builder>... uploadConfigurations) {
            uploadConfigurations(Stream.of(uploadConfigurations).map(c -> UploadConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUploadConfigurations(Collection<UploadConfiguration.BuilderImpl> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copyFromBuilder(uploadConfigurations);
        }

        public final Boolean getUseDefaultUploadConfigurations() {
            return useDefaultUploadConfigurations;
        }

        @Override
        public final Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
            return this;
        }

        public final void setUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder>... tools) {
            tools(Stream.of(tools).map(c -> Tool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsCopier.copyFromBuilder(tools);
        }

        public final Boolean getUseDefaultTools() {
            return useDefaultTools;
        }

        @Override
        public final Builder useDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
            return this;
        }

        public final void setUseDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
        }

        @Override
        public RobotApplicationConfig build() {
            return new RobotApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
