/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSimulationJobRequest extends RoboMakerRequest implements
        ToCopyableBuilder<CreateSimulationJobRequest.Builder, CreateSimulationJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateSimulationJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).memberName("outputLocation")
            .getter(getter(CreateSimulationJobRequest::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).memberName("loggingConfig")
            .getter(getter(CreateSimulationJobRequest::loggingConfig)).setter(setter(Builder::loggingConfig))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()).build();

    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxJobDurationInSeconds").getter(getter(CreateSimulationJobRequest::maxJobDurationInSeconds))
            .setter(setter(Builder::maxJobDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRole").getter(getter(CreateSimulationJobRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureBehavior").getter(getter(CreateSimulationJobRequest::failureBehaviorAsString))
            .setter(setter(Builder::failureBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()).build();

    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField
            .<List<RobotApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("robotApplications")
            .getter(getter(CreateSimulationJobRequest::robotApplications))
            .setter(setter(Builder::robotApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RobotApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RobotApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField
            .<List<SimulationApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("simulationApplications")
            .getter(getter(CreateSimulationJobRequest::simulationApplications))
            .setter(setter(Builder::simulationApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSourceConfig>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSourceConfig>> builder(MarshallingType.LIST)
            .memberName("dataSources")
            .getter(getter(CreateSimulationJobRequest::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSimulationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VPCConfig> VPC_CONFIG_FIELD = SdkField.<VPCConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(CreateSimulationJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VPCConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<Compute> COMPUTE_FIELD = SdkField.<Compute> builder(MarshallingType.SDK_POJO)
            .memberName("compute").getter(getter(CreateSimulationJobRequest::compute)).setter(setter(Builder::compute))
            .constructor(Compute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            OUTPUT_LOCATION_FIELD, LOGGING_CONFIG_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, IAM_ROLE_FIELD,
            FAILURE_BEHAVIOR_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD,
            VPC_CONFIG_FIELD, COMPUTE_FIELD));

    private final String clientRequestToken;

    private final OutputLocation outputLocation;

    private final LoggingConfig loggingConfig;

    private final Long maxJobDurationInSeconds;

    private final String iamRole;

    private final String failureBehavior;

    private final List<RobotApplicationConfig> robotApplications;

    private final List<SimulationApplicationConfig> simulationApplications;

    private final List<DataSourceConfig> dataSources;

    private final Map<String, String> tags;

    private final VPCConfig vpcConfig;

    private final Compute compute;

    private CreateSimulationJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.iamRole = builder.iamRole;
        this.failureBehavior = builder.failureBehavior;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.compute = builder.compute;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     * 
     * @return Location for output files generated by the simulation job.
     */
    public final OutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The logging configuration.
     * </p>
     * 
     * @return The logging configuration.
     */
    public final LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When
     * <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to
     * <code>Completed</code>.
     * </p>
     * 
     * @return The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When
     *         <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to
     *         <code>Completed</code>.
     */
    public final Long maxJobDurationInSeconds() {
        return maxJobDurationInSeconds;
    }

    /**
     * <p>
     * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf. This is how credentials are passed in to your simulation job.
     * </p>
     * 
     * @return The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
     *         associated policies on your behalf. This is how credentials are passed in to your simulation job.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior the simulation job.</p>
     *         <dl>
     *         <dt>Continue</dt>
     *         <dd>
     *         <p>
     *         Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
     *         </p>
     *         </dd>
     *         <dt>Fail</dt>
     *         <dd>
     *         <p>
     *         Stop the simulation job and terminate the instance.
     *         </p>
     *         </dd>
     * @see FailureBehavior
     */
    public final FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(failureBehavior);
    }

    /**
     * <p>
     * The failure behavior the simulation job.
     * </p>
     * <dl>
     * <dt>Continue</dt>
     * <dd>
     * <p>
     * Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
     * </p>
     * </dd>
     * <dt>Fail</dt>
     * <dd>
     * <p>
     * Stop the simulation job and terminate the instance.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior the simulation job.</p>
     *         <dl>
     *         <dt>Continue</dt>
     *         <dd>
     *         <p>
     *         Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
     *         </p>
     *         </dd>
     *         <dt>Fail</dt>
     *         <dd>
     *         <p>
     *         Stop the simulation job and terminate the instance.
     *         </p>
     *         </dd>
     * @see FailureBehavior
     */
    public final String failureBehaviorAsString() {
        return failureBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the RobotApplications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRobotApplications() {
        return robotApplications != null && !(robotApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The robot application to use in the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRobotApplications} method.
     * </p>
     * 
     * @return The robot application to use in the simulation job.
     */
    public final List<RobotApplicationConfig> robotApplications() {
        return robotApplications;
    }

    /**
     * For responses, this returns true if the service returned a value for the SimulationApplications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSimulationApplications() {
        return simulationApplications != null && !(simulationApplications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The simulation application to use in the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSimulationApplications} method.
     * </p>
     * 
     * @return The simulation application to use in the simulation job.
     */
    public final List<SimulationApplicationConfig> simulationApplications() {
        return simulationApplications;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
     * <code>/opt/robomaker/datasources/data_source_name</code>.
     * </p>
     * <note>
     * <p>
     * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return Specify data sources to mount read-only files from S3 into your simulation. These files are available
     *         under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
     *         <p>
     *         There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
     *         </p>
     */
    public final List<DataSourceConfig> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the simulation job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security
     * group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one
     * subnet ID.
     * </p>
     * 
     * @return If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of
     *         security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one
     *         security group and one subnet ID.
     */
    public final VPCConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Compute information for the simulation job.
     * </p>
     * 
     * @return Compute information for the simulation job.
     */
    public final Compute compute() {
        return compute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRobotApplications() ? robotApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSimulationApplications() ? simulationApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(compute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSimulationJobRequest)) {
            return false;
        }
        CreateSimulationJobRequest other = (CreateSimulationJobRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(maxJobDurationInSeconds(), other.maxJobDurationInSeconds())
                && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(failureBehaviorAsString(), other.failureBehaviorAsString())
                && hasRobotApplications() == other.hasRobotApplications()
                && Objects.equals(robotApplications(), other.robotApplications())
                && hasSimulationApplications() == other.hasSimulationApplications()
                && Objects.equals(simulationApplications(), other.simulationApplications())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(compute(), other.compute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSimulationJobRequest").add("ClientRequestToken", clientRequestToken())
                .add("OutputLocation", outputLocation()).add("LoggingConfig", loggingConfig())
                .add("MaxJobDurationInSeconds", maxJobDurationInSeconds()).add("IamRole", iamRole())
                .add("FailureBehavior", failureBehaviorAsString())
                .add("RobotApplications", hasRobotApplications() ? robotApplications() : null)
                .add("SimulationApplications", hasSimulationApplications() ? simulationApplications() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null).add("Tags", hasTags() ? tags() : null)
                .add("VpcConfig", vpcConfig()).add("Compute", compute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "loggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "maxJobDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxJobDurationInSeconds()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "failureBehavior":
            return Optional.ofNullable(clazz.cast(failureBehaviorAsString()));
        case "robotApplications":
            return Optional.ofNullable(clazz.cast(robotApplications()));
        case "simulationApplications":
            return Optional.ofNullable(clazz.cast(simulationApplications()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "compute":
            return Optional.ofNullable(clazz.cast(compute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSimulationJobRequest, T> g) {
        return obj -> g.apply((CreateSimulationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSimulationJobRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Location for output files generated by the simulation job.
         * </p>
         * 
         * @param outputLocation
         *        Location for output files generated by the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * <p>
         * Location for output files generated by the simulation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputLocation.Builder} avoiding the need
         * to create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The logging configuration.
         * </p>
         * 
         * @param loggingConfig
         *        The logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * The logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfig.Builder} avoiding the need
         * to create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When
         * <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to
         * <code>Completed</code>.
         * </p>
         * 
         * @param maxJobDurationInSeconds
         *        The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When
         *        <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to
         *        <code>Completed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds);

        /**
         * <p>
         * The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
         * associated policies on your behalf. This is how credentials are passed in to your simulation job.
         * </p>
         * 
         * @param iamRole
         *        The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its
         *        associated policies on your behalf. This is how credentials are passed in to your simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The failure behavior the simulation job.
         * </p>
         * <dl>
         * <dt>Continue</dt>
         * <dd>
         * <p>
         * Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
         * </p>
         * </dd>
         * <dt>Fail</dt>
         * <dd>
         * <p>
         * Stop the simulation job and terminate the instance.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureBehavior
         *        The failure behavior the simulation job.</p>
         *        <dl>
         *        <dt>Continue</dt>
         *        <dd>
         *        <p>
         *        Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
         *        </p>
         *        </dd>
         *        <dt>Fail</dt>
         *        <dd>
         *        <p>
         *        Stop the simulation job and terminate the instance.
         *        </p>
         *        </dd>
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(String failureBehavior);

        /**
         * <p>
         * The failure behavior the simulation job.
         * </p>
         * <dl>
         * <dt>Continue</dt>
         * <dd>
         * <p>
         * Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
         * </p>
         * </dd>
         * <dt>Fail</dt>
         * <dd>
         * <p>
         * Stop the simulation job and terminate the instance.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureBehavior
         *        The failure behavior the simulation job.</p>
         *        <dl>
         *        <dt>Continue</dt>
         *        <dd>
         *        <p>
         *        Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.
         *        </p>
         *        </dd>
         *        <dt>Fail</dt>
         *        <dd>
         *        <p>
         *        Stop the simulation job and terminate the instance.
         *        </p>
         *        </dd>
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(FailureBehavior failureBehavior);

        /**
         * <p>
         * The robot application to use in the simulation job.
         * </p>
         * 
         * @param robotApplications
         *        The robot application to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(Collection<RobotApplicationConfig> robotApplications);

        /**
         * <p>
         * The robot application to use in the simulation job.
         * </p>
         * 
         * @param robotApplications
         *        The robot application to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(RobotApplicationConfig... robotApplications);

        /**
         * <p>
         * The robot application to use in the simulation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RobotApplicationConfig>.Builder}
         * avoiding the need to create one manually via {@link List<RobotApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RobotApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #robotApplications(List<RobotApplicationConfig>)}.
         * 
         * @param robotApplications
         *        a consumer that will call methods on {@link List<RobotApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotApplications(List<RobotApplicationConfig>)
         */
        Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications);

        /**
         * <p>
         * The simulation application to use in the simulation job.
         * </p>
         * 
         * @param simulationApplications
         *        The simulation application to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications);

        /**
         * <p>
         * The simulation application to use in the simulation job.
         * </p>
         * 
         * @param simulationApplications
         *        The simulation application to use in the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(SimulationApplicationConfig... simulationApplications);

        /**
         * <p>
         * The simulation application to use in the simulation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <SimulationApplicationConfig>.Builder} avoiding the need to create one manually via {@link List
         * <SimulationApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #simulationApplications(List<SimulationApplicationConfig>)}.
         * 
         * @param simulationApplications
         *        a consumer that will call methods on {@link List<SimulationApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationApplications(List<SimulationApplicationConfig>)
         */
        Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note>
         * 
         * @param dataSources
         *        Specify data sources to mount read-only files from S3 into your simulation. These files are available
         *        under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
         *        <p>
         *        There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code>
         *        objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSourceConfig> dataSources);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note>
         * 
         * @param dataSources
         *        Specify data sources to mount read-only files from S3 into your simulation. These files are available
         *        under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
         *        <p>
         *        There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code>
         *        objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourceConfig... dataSources);

        /**
         * <p>
         * Specify data sources to mount read-only files from S3 into your simulation. These files are available under
         * <code>/opt/robomaker/datasources/data_source_name</code>.
         * </p>
         * <note>
         * <p>
         * There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<DataSourceConfig>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(List<DataSourceConfig>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link List<DataSourceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(List<DataSourceConfig>)
         */
        Builder dataSources(Consumer<DataSourceConfig.Builder>... dataSources);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the simulation job.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of
         * security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security
         * group and one subnet ID.
         * </p>
         * 
         * @param vpcConfig
         *        If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of
         *        security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one
         *        security group and one subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VPCConfig vpcConfig);

        /**
         * <p>
         * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of
         * security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security
         * group and one subnet ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link VPCConfig.Builder} avoiding the need to
         * create one manually via {@link VPCConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VPCConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VPCConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VPCConfig)
         */
        default Builder vpcConfig(Consumer<VPCConfig.Builder> vpcConfig) {
            return vpcConfig(VPCConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Compute information for the simulation job.
         * </p>
         * 
         * @param compute
         *        Compute information for the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compute(Compute compute);

        /**
         * <p>
         * Compute information for the simulation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link Compute.Builder} avoiding the need to
         * create one manually via {@link Compute#builder()}.
         *
         * When the {@link Consumer} completes, {@link Compute.Builder#build()} is called immediately and its result is
         * passed to {@link #compute(Compute)}.
         * 
         * @param compute
         *        a consumer that will call methods on {@link Compute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compute(Compute)
         */
        default Builder compute(Consumer<Compute.Builder> compute) {
            return compute(Compute.builder().applyMutation(compute).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private OutputLocation outputLocation;

        private LoggingConfig loggingConfig;

        private Long maxJobDurationInSeconds;

        private String iamRole;

        private String failureBehavior;

        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();

        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();

        private List<DataSourceConfig> dataSources = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VPCConfig vpcConfig;

        private Compute compute;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSimulationJobRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            outputLocation(model.outputLocation);
            loggingConfig(model.loggingConfig);
            maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            iamRole(model.iamRole);
            failureBehavior(model.failureBehavior);
            robotApplications(model.robotApplications);
            simulationApplications(model.simulationApplications);
            dataSources(model.dataSources);
            tags(model.tags);
            vpcConfig(model.vpcConfig);
            compute(model.compute);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final Long getMaxJobDurationInSeconds() {
            return maxJobDurationInSeconds;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final String getFailureBehavior() {
            return failureBehavior;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final List<RobotApplicationConfig.Builder> getRobotApplications() {
            List<RobotApplicationConfig.Builder> result = RobotApplicationConfigsCopier.copyToBuilder(this.robotApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig... robotApplications) {
            robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications) {
            robotApplications(Stream.of(robotApplications).map(c -> RobotApplicationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SimulationApplicationConfig.Builder> getSimulationApplications() {
            List<SimulationApplicationConfig.Builder> result = SimulationApplicationConfigsCopier
                    .copyToBuilder(this.simulationApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig... simulationApplications) {
            simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications) {
            simulationApplications(Stream.of(simulationApplications)
                    .map(c -> SimulationApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceConfig.Builder> getDataSources() {
            List<DataSourceConfig.Builder> result = DataSourceConfigsCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSourceConfig.BuilderImpl> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSourceConfig> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSourceConfig... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSourceConfig.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSourceConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VPCConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VPCConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Compute.Builder getCompute() {
            return compute != null ? compute.toBuilder() : null;
        }

        public final void setCompute(Compute.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        @Override
        public final Builder compute(Compute compute) {
            this.compute = compute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSimulationJobRequest build() {
            return new CreateSimulationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
