/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a world export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorldExportJobSummary.Builder, WorldExportJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WorldExportJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorldExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WorldExportJobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<String>> WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("worlds")
            .getter(getter(WorldExportJobSummary::worlds))
            .setter(setter(Builder::worlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).memberName("outputLocation")
            .getter(getter(WorldExportJobSummary::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, WORLDS_FIELD, OUTPUT_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final Instant createdAt;

    private final List<String> worlds;

    private final OutputLocation outputLocation;

    private WorldExportJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.worlds = builder.worlds;
        this.outputLocation = builder.outputLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the world export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the world export job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public final WorldExportJobStatus status() {
        return WorldExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world export job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world export job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Worlds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorlds() {
        return worlds != null && !(worlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of worlds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorlds} method.
     * </p>
     * 
     * @return A list of worlds.
     */
    public final List<String> worlds() {
        return worlds;
    }

    /**
     * Returns the value of the OutputLocation property for this object.
     * 
     * @return The value of the OutputLocation property for this object.
     */
    public final OutputLocation outputLocation() {
        return outputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorlds() ? worlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldExportJobSummary)) {
            return false;
        }
        WorldExportJobSummary other = (WorldExportJobSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && hasWorlds() == other.hasWorlds()
                && Objects.equals(worlds(), other.worlds()) && Objects.equals(outputLocation(), other.outputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorldExportJobSummary").add("Arn", arn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("Worlds", hasWorlds() ? worlds() : null)
                .add("OutputLocation", outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "worlds":
            return Optional.ofNullable(clazz.cast(worlds()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldExportJobSummary, T> g) {
        return obj -> g.apply((WorldExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldExportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the world export job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the world export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(WorldExportJobStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world export job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A list of worlds.
         * </p>
         * 
         * @param worlds
         *        A list of worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(Collection<String> worlds);

        /**
         * <p>
         * A list of worlds.
         * </p>
         * 
         * @param worlds
         *        A list of worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(String... worlds);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * @param outputLocation
         *        The new value for the OutputLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputLocation.Builder} avoiding the need
         * to create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant createdAt;

        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();

        private OutputLocation outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldExportJobSummary model) {
            arn(model.arn);
            status(model.status);
            createdAt(model.createdAt);
            worlds(model.worlds);
            outputLocation(model.outputLocation);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Collection<String> getWorlds() {
            if (worlds instanceof SdkAutoConstructList) {
                return null;
            }
            return worlds;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        @Override
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worlds(String... worlds) {
            worlds(Arrays.asList(worlds));
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        @Override
        public WorldExportJobSummary build() {
            return new WorldExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
