/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeploymentJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeDeploymentJobResponse.Builder, DescribeDeploymentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeDeploymentJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(DescribeDeploymentJobResponse::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeDeploymentJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("deploymentConfig")
            .getter(getter(DescribeDeploymentJobResponse::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()).build();

    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField
            .<List<DeploymentApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("deploymentApplicationConfigs")
            .getter(getter(DescribeDeploymentJobResponse::deploymentApplicationConfigs))
            .setter(setter(Builder::deploymentApplicationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DescribeDeploymentJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(DescribeDeploymentJobResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeDeploymentJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<RobotDeployment>> ROBOT_DEPLOYMENT_SUMMARY_FIELD = SdkField
            .<List<RobotDeployment>> builder(MarshallingType.LIST)
            .memberName("robotDeploymentSummary")
            .getter(getter(DescribeDeploymentJobResponse::robotDeploymentSummary))
            .setter(setter(Builder::robotDeploymentSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotDeploymentSummary").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RobotDeployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(RobotDeployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeDeploymentJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLEET_FIELD,
            STATUS_FIELD, DEPLOYMENT_CONFIG_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, FAILURE_REASON_FIELD,
            FAILURE_CODE_FIELD, CREATED_AT_FIELD, ROBOT_DEPLOYMENT_SUMMARY_FIELD, TAGS_FIELD));

    private final String arn;

    private final String fleet;

    private final String status;

    private final DeploymentConfig deploymentConfig;

    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;

    private final String failureReason;

    private final String failureCode;

    private final Instant createdAt;

    private final List<RobotDeployment> robotDeploymentSummary;

    private final Map<String, String> tags;

    private DescribeDeploymentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.fleet = builder.fleet;
        this.status = builder.status;
        this.deploymentConfig = builder.deploymentConfig;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.createdAt = builder.createdAt;
        this.robotDeploymentSummary = builder.robotDeploymentSummary;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deployment job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public final String fleet() {
        return fleet;
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The deployment configuration.
     * </p>
     * 
     * @return The deployment configuration.
     */
    public final DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentApplicationConfigs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeploymentApplicationConfigs() {
        return deploymentApplicationConfigs != null && !(deploymentApplicationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deployment application configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentApplicationConfigs} method.
     * </p>
     * 
     * @return The deployment application configuration.
     */
    public final List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return deploymentApplicationConfigs;
    }

    /**
     * <p>
     * A short description of the reason why the deployment job failed.
     * </p>
     * 
     * @return A short description of the reason why the deployment job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The deployment job failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The deployment job failure code.
     * @see DeploymentJobErrorCode
     */
    public final DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The deployment job failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The deployment job failure code.
     * @see DeploymentJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the deployment job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the deployment job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the RobotDeploymentSummary property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRobotDeploymentSummary() {
        return robotDeploymentSummary != null && !(robotDeploymentSummary instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of robot deployment summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRobotDeploymentSummary} method.
     * </p>
     * 
     * @return A list of robot deployment summaries.
     */
    public final List<RobotDeployment> robotDeploymentSummary() {
        return robotDeploymentSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of all tags added to the specified deployment job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of all tags added to the specified deployment job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasRobotDeploymentSummary() ? robotDeploymentSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentJobResponse)) {
            return false;
        }
        DescribeDeploymentJobResponse other = (DescribeDeploymentJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(fleet(), other.fleet())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(deploymentConfig(), other.deploymentConfig())
                && hasDeploymentApplicationConfigs() == other.hasDeploymentApplicationConfigs()
                && Objects.equals(deploymentApplicationConfigs(), other.deploymentApplicationConfigs())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && hasRobotDeploymentSummary() == other.hasRobotDeploymentSummary()
                && Objects.equals(robotDeploymentSummary(), other.robotDeploymentSummary()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeploymentJobResponse").add("Arn", arn()).add("Fleet", fleet())
                .add("Status", statusAsString()).add("DeploymentConfig", deploymentConfig())
                .add("DeploymentApplicationConfigs", hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null)
                .add("FailureReason", failureReason()).add("FailureCode", failureCodeAsString()).add("CreatedAt", createdAt())
                .add("RobotDeploymentSummary", hasRobotDeploymentSummary() ? robotDeploymentSummary() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "deploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "deploymentApplicationConfigs":
            return Optional.ofNullable(clazz.cast(deploymentApplicationConfigs()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "robotDeploymentSummary":
            return Optional.ofNullable(clazz.cast(robotDeploymentSummary()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeploymentJobResponse, T> g) {
        return obj -> g.apply((DescribeDeploymentJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeploymentJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deployment job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleet
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * 
         * @param deploymentConfig
         *        The deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfig.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DeploymentApplicationConfig>.Builder} avoiding the need to create one manually via {@link List
         * <DeploymentApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)}.
         * 
         * @param deploymentApplicationConfigs
         *        a consumer that will call methods on {@link List<DeploymentApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)
         */
        Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs);

        /**
         * <p>
         * A short description of the reason why the deployment job failed.
         * </p>
         * 
         * @param failureReason
         *        A short description of the reason why the deployment job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The deployment job failure code.
         * </p>
         * 
         * @param failureCode
         *        The deployment job failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The deployment job failure code.
         * </p>
         * 
         * @param failureCode
         *        The deployment job failure code.
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(DeploymentJobErrorCode failureCode);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the deployment job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the deployment job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A list of robot deployment summaries.
         * </p>
         * 
         * @param robotDeploymentSummary
         *        A list of robot deployment summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotDeploymentSummary(Collection<RobotDeployment> robotDeploymentSummary);

        /**
         * <p>
         * A list of robot deployment summaries.
         * </p>
         * 
         * @param robotDeploymentSummary
         *        A list of robot deployment summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotDeploymentSummary(RobotDeployment... robotDeploymentSummary);

        /**
         * <p>
         * A list of robot deployment summaries.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RobotDeployment>.Builder} avoiding
         * the need to create one manually via {@link List<RobotDeployment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RobotDeployment>.Builder#build()} is called immediately and
         * its result is passed to {@link #robotDeploymentSummary(List<RobotDeployment>)}.
         * 
         * @param robotDeploymentSummary
         *        a consumer that will call methods on {@link List<RobotDeployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotDeploymentSummary(List<RobotDeployment>)
         */
        Builder robotDeploymentSummary(Consumer<RobotDeployment.Builder>... robotDeploymentSummary);

        /**
         * <p>
         * The list of all tags added to the specified deployment job.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the specified deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String fleet;

        private String status;

        private DeploymentConfig deploymentConfig;

        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();

        private String failureReason;

        private String failureCode;

        private Instant createdAt;

        private List<RobotDeployment> robotDeploymentSummary = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentJobResponse model) {
            super(model);
            arn(model.arn);
            fleet(model.fleet);
            status(model.status);
            deploymentConfig(model.deploymentConfig);
            deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            createdAt(model.createdAt);
            robotDeploymentSummary(model.robotDeploymentSummary);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFleet() {
            return fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final List<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            List<DeploymentApplicationConfig.Builder> result = DeploymentApplicationConfigsCopier
                    .copyToBuilder(this.deploymentApplicationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentApplicationConfigs(
                Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(
                Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs)
                    .map(c -> DeploymentApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<RobotDeployment.Builder> getRobotDeploymentSummary() {
            List<RobotDeployment.Builder> result = RobotDeploymentSummaryCopier.copyToBuilder(this.robotDeploymentSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRobotDeploymentSummary(Collection<RobotDeployment.BuilderImpl> robotDeploymentSummary) {
            this.robotDeploymentSummary = RobotDeploymentSummaryCopier.copyFromBuilder(robotDeploymentSummary);
        }

        @Override
        public final Builder robotDeploymentSummary(Collection<RobotDeployment> robotDeploymentSummary) {
            this.robotDeploymentSummary = RobotDeploymentSummaryCopier.copy(robotDeploymentSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotDeploymentSummary(RobotDeployment... robotDeploymentSummary) {
            robotDeploymentSummary(Arrays.asList(robotDeploymentSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotDeploymentSummary(Consumer<RobotDeployment.Builder>... robotDeploymentSummary) {
            robotDeploymentSummary(Stream.of(robotDeploymentSummary).map(c -> RobotDeployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeDeploymentJobResponse build() {
            return new DescribeDeploymentJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
