/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a failed create simulation job request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedCreateSimulationJobRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedCreateSimulationJobRequest.Builder, FailedCreateSimulationJobRequest> {
    private static final SdkField<SimulationJobRequest> REQUEST_FIELD = SdkField
            .<SimulationJobRequest> builder(MarshallingType.SDK_POJO).memberName("request")
            .getter(getter(FailedCreateSimulationJobRequest::request)).setter(setter(Builder::request))
            .constructor(SimulationJobRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(FailedCreateSimulationJobRequest::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(FailedCreateSimulationJobRequest::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<Instant> FAILED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("failedAt").getter(getter(FailedCreateSimulationJobRequest::failedAt)).setter(setter(Builder::failedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD,
            FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, FAILED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimulationJobRequest request;

    private final String failureReason;

    private final String failureCode;

    private final Instant failedAt;

    private FailedCreateSimulationJobRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.failedAt = builder.failedAt;
    }

    /**
     * <p>
     * The simulation job request.
     * </p>
     * 
     * @return The simulation job request.
     */
    public final SimulationJobRequest request() {
        return request;
    }

    /**
     * <p>
     * The failure reason of the simulation job request.
     * </p>
     * 
     * @return The failure reason of the simulation job request.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see SimulationJobErrorCode
     */
    public final SimulationJobErrorCode failureCode() {
        return SimulationJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see SimulationJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job batch failed.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job batch failed.
     */
    public final Instant failedAt() {
        return failedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateSimulationJobRequest)) {
            return false;
        }
        FailedCreateSimulationJobRequest other = (FailedCreateSimulationJobRequest) obj;
        return Objects.equals(request(), other.request()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failedAt(), other.failedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedCreateSimulationJobRequest").add("Request", request())
                .add("FailureReason", failureReason()).add("FailureCode", failureCodeAsString()).add("FailedAt", failedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "request":
            return Optional.ofNullable(clazz.cast(request()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failedAt":
            return Optional.ofNullable(clazz.cast(failedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedCreateSimulationJobRequest, T> g) {
        return obj -> g.apply((FailedCreateSimulationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedCreateSimulationJobRequest> {
        /**
         * <p>
         * The simulation job request.
         * </p>
         * 
         * @param request
         *        The simulation job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(SimulationJobRequest request);

        /**
         * <p>
         * The simulation job request.
         * </p>
         * This is a convenience that creates an instance of the {@link SimulationJobRequest.Builder} avoiding the need
         * to create one manually via {@link SimulationJobRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimulationJobRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #request(SimulationJobRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link SimulationJobRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(SimulationJobRequest)
         */
        default Builder request(Consumer<SimulationJobRequest.Builder> request) {
            return request(SimulationJobRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * The failure reason of the simulation job request.
         * </p>
         * 
         * @param failureReason
         *        The failure reason of the simulation job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see SimulationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see SimulationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobErrorCode
         */
        Builder failureCode(SimulationJobErrorCode failureCode);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job batch failed.
         * </p>
         * 
         * @param failedAt
         *        The time, in milliseconds since the epoch, when the simulation job batch failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAt(Instant failedAt);
    }

    static final class BuilderImpl implements Builder {
        private SimulationJobRequest request;

        private String failureReason;

        private String failureCode;

        private Instant failedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateSimulationJobRequest model) {
            request(model.request);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            failedAt(model.failedAt);
        }

        public final SimulationJobRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(SimulationJobRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        @Transient
        public final Builder request(SimulationJobRequest request) {
            this.request = request;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        @Transient
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        @Transient
        public final Builder failureCode(SimulationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Instant getFailedAt() {
            return failedAt;
        }

        public final void setFailedAt(Instant failedAt) {
            this.failedAt = failedAt;
        }

        @Override
        @Transient
        public final Builder failedAt(Instant failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        @Override
        public FailedCreateSimulationJobRequest build() {
            return new FailedCreateSimulationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
