/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRobotApplicationRequest extends RoboMakerRequest implements
        ToCopyableBuilder<DeleteRobotApplicationRequest.Builder, DeleteRobotApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(DeleteRobotApplicationRequest::application))
            .setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationVersion").getter(getter(DeleteRobotApplicationRequest::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            APPLICATION_VERSION_FIELD));

    private final String application;

    private final String applicationVersion;

    private DeleteRobotApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the the robot application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the the robot application.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The version of the robot application to delete.
     * </p>
     * 
     * @return The version of the robot application to delete.
     */
    public final String applicationVersion() {
        return applicationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRobotApplicationRequest)) {
            return false;
        }
        DeleteRobotApplicationRequest other = (DeleteRobotApplicationRequest) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(applicationVersion(), other.applicationVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRobotApplicationRequest").add("Application", application())
                .add("ApplicationVersion", applicationVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRobotApplicationRequest, T> g) {
        return obj -> g.apply((DeleteRobotApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRobotApplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the the robot application.
         * </p>
         * 
         * @param application
         *        The Amazon Resource Name (ARN) of the the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The version of the robot application to delete.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the robot application to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(String applicationVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String application;

        private String applicationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRobotApplicationRequest model) {
            super(model);
            application(model.application);
            applicationVersion(model.applicationVersion);
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        @Transient
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        @Transient
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRobotApplicationRequest build() {
            return new DeleteRobotApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
