/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentJobsResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListDeploymentJobsResponse.Builder, ListDeploymentJobsResponse> {
    private static final SdkField<List<DeploymentJob>> DEPLOYMENT_JOBS_FIELD = SdkField
            .<List<DeploymentJob>> builder(MarshallingType.LIST)
            .memberName("deploymentJobs")
            .getter(getter(ListDeploymentJobsResponse::deploymentJobs))
            .setter(setter(Builder::deploymentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeploymentJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeploymentJob> deploymentJobs;

    private final String nextToken;

    private ListDeploymentJobsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentJobs = builder.deploymentJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentJobs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentJobs() {
        return deploymentJobs != null && !(deploymentJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of deployment jobs that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentJobs} method.
     * </p>
     * 
     * @return A list of deployment jobs that meet the criteria of the request.
     */
    public final List<DeploymentJob> deploymentJobs() {
        return deploymentJobs;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code>
     * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListDeploymentJobs</code> again and assign that token to the request object's
     *         <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
     *         NextToken parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentJobs() ? deploymentJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentJobsResponse)) {
            return false;
        }
        ListDeploymentJobsResponse other = (ListDeploymentJobsResponse) obj;
        return hasDeploymentJobs() == other.hasDeploymentJobs() && Objects.equals(deploymentJobs(), other.deploymentJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeploymentJobsResponse")
                .add("DeploymentJobs", hasDeploymentJobs() ? deploymentJobs() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentJobs":
            return Optional.ofNullable(clazz.cast(deploymentJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentJobsResponse, T> g) {
        return obj -> g.apply((ListDeploymentJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeploymentJobsResponse> {
        /**
         * <p>
         * A list of deployment jobs that meet the criteria of the request.
         * </p>
         * 
         * @param deploymentJobs
         *        A list of deployment jobs that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentJobs(Collection<DeploymentJob> deploymentJobs);

        /**
         * <p>
         * A list of deployment jobs that meet the criteria of the request.
         * </p>
         * 
         * @param deploymentJobs
         *        A list of deployment jobs that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentJobs(DeploymentJob... deploymentJobs);

        /**
         * <p>
         * A list of deployment jobs that meet the criteria of the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeploymentJob>.Builder} avoiding the need
         * to create one manually via {@link List<DeploymentJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentJobs(List<DeploymentJob>)}.
         * 
         * @param deploymentJobs
         *        a consumer that will call methods on {@link List<DeploymentJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentJobs(List<DeploymentJob>)
         */
        Builder deploymentJobs(Consumer<DeploymentJob.Builder>... deploymentJobs);

        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code>
         * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to
         * null.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListDeploymentJobs</code> again and assign that token to the request object's
         *        <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
         *        NextToken parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<DeploymentJob> deploymentJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentJobsResponse model) {
            super(model);
            deploymentJobs(model.deploymentJobs);
            nextToken(model.nextToken);
        }

        public final List<DeploymentJob.Builder> getDeploymentJobs() {
            List<DeploymentJob.Builder> result = DeploymentJobsCopier.copyToBuilder(this.deploymentJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentJobs(Collection<DeploymentJob.BuilderImpl> deploymentJobs) {
            this.deploymentJobs = DeploymentJobsCopier.copyFromBuilder(deploymentJobs);
        }

        @Override
        @Transient
        public final Builder deploymentJobs(Collection<DeploymentJob> deploymentJobs) {
            this.deploymentJobs = DeploymentJobsCopier.copy(deploymentJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deploymentJobs(DeploymentJob... deploymentJobs) {
            deploymentJobs(Arrays.asList(deploymentJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deploymentJobs(Consumer<DeploymentJob.Builder>... deploymentJobs) {
            deploymentJobs(Stream.of(deploymentJobs).map(c -> DeploymentJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeploymentJobsResponse build() {
            return new ListDeploymentJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
