/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a simulation application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationApplicationSummary.Builder, SimulationApplicationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SimulationApplicationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SimulationApplicationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(SimulationApplicationSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(SimulationApplicationSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField
            .<RobotSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("robotSoftwareSuite")
            .getter(getter(SimulationApplicationSummary::robotSoftwareSuite)).setter(setter(Builder::robotSoftwareSuite))
            .constructor(RobotSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build())
            .build();

    private static final SdkField<SimulationSoftwareSuite> SIMULATION_SOFTWARE_SUITE_FIELD = SdkField
            .<SimulationSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("simulationSoftwareSuite")
            .getter(getter(SimulationApplicationSummary::simulationSoftwareSuite))
            .setter(setter(Builder::simulationSoftwareSuite)).constructor(SimulationSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationSoftwareSuite").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            VERSION_FIELD, LAST_UPDATED_AT_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, SIMULATION_SOFTWARE_SUITE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String version;

    private final Instant lastUpdatedAt;

    private final RobotSoftwareSuite robotSoftwareSuite;

    private final SimulationSoftwareSuite simulationSoftwareSuite;

    private SimulationApplicationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.version = builder.version;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.simulationSoftwareSuite = builder.simulationSoftwareSuite;
    }

    /**
     * <p>
     * The name of the simulation application.
     * </p>
     * 
     * @return The name of the simulation application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation application.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The version of the simulation application.
     * </p>
     * 
     * @return The version of the simulation application.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation application was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation application was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Information about a robot software suite (ROS distribution).
     * </p>
     * 
     * @return Information about a robot software suite (ROS distribution).
     */
    public final RobotSoftwareSuite robotSoftwareSuite() {
        return robotSoftwareSuite;
    }

    /**
     * <p>
     * Information about a simulation software suite.
     * </p>
     * 
     * @return Information about a simulation software suite.
     */
    public final SimulationSoftwareSuite simulationSoftwareSuite() {
        return simulationSoftwareSuite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(simulationSoftwareSuite());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationSummary)) {
            return false;
        }
        SimulationApplicationSummary other = (SimulationApplicationSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(version(), other.version()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(robotSoftwareSuite(), other.robotSoftwareSuite())
                && Objects.equals(simulationSoftwareSuite(), other.simulationSoftwareSuite());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationApplicationSummary").add("Name", name()).add("Arn", arn()).add("Version", version())
                .add("LastUpdatedAt", lastUpdatedAt()).add("RobotSoftwareSuite", robotSoftwareSuite())
                .add("SimulationSoftwareSuite", simulationSoftwareSuite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "robotSoftwareSuite":
            return Optional.ofNullable(clazz.cast(robotSoftwareSuite()));
        case "simulationSoftwareSuite":
            return Optional.ofNullable(clazz.cast(simulationSoftwareSuite()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationApplicationSummary, T> g) {
        return obj -> g.apply((SimulationApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationApplicationSummary> {
        /**
         * <p>
         * The name of the simulation application.
         * </p>
         * 
         * @param name
         *        The name of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the simulation application.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The version of the simulation application.
         * </p>
         * 
         * @param version
         *        The version of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation application was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Information about a robot software suite (ROS distribution).
         * </p>
         * 
         * @param robotSoftwareSuite
         *        Information about a robot software suite (ROS distribution).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite);

        /**
         * <p>
         * Information about a robot software suite (ROS distribution).
         * </p>
         * This is a convenience that creates an instance of the {@link RobotSoftwareSuite.Builder} avoiding the need to
         * create one manually via {@link RobotSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link RobotSoftwareSuite.Builder#build()} is called immediately and its
         * result is passed to {@link #robotSoftwareSuite(RobotSoftwareSuite)}.
         * 
         * @param robotSoftwareSuite
         *        a consumer that will call methods on {@link RobotSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotSoftwareSuite(RobotSoftwareSuite)
         */
        default Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return robotSoftwareSuite(RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite).build());
        }

        /**
         * <p>
         * Information about a simulation software suite.
         * </p>
         * 
         * @param simulationSoftwareSuite
         *        Information about a simulation software suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite);

        /**
         * <p>
         * Information about a simulation software suite.
         * </p>
         * This is a convenience that creates an instance of the {@link SimulationSoftwareSuite.Builder} avoiding the
         * need to create one manually via {@link SimulationSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimulationSoftwareSuite.Builder#build()} is called immediately
         * and its result is passed to {@link #simulationSoftwareSuite(SimulationSoftwareSuite)}.
         * 
         * @param simulationSoftwareSuite
         *        a consumer that will call methods on {@link SimulationSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationSoftwareSuite(SimulationSoftwareSuite)
         */
        default Builder simulationSoftwareSuite(Consumer<SimulationSoftwareSuite.Builder> simulationSoftwareSuite) {
            return simulationSoftwareSuite(SimulationSoftwareSuite.builder().applyMutation(simulationSoftwareSuite).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String version;

        private Instant lastUpdatedAt;

        private RobotSoftwareSuite robotSoftwareSuite;

        private SimulationSoftwareSuite simulationSoftwareSuite;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationApplicationSummary model) {
            name(model.name);
            arn(model.arn);
            version(model.version);
            lastUpdatedAt(model.lastUpdatedAt);
            robotSoftwareSuite(model.robotSoftwareSuite);
            simulationSoftwareSuite(model.simulationSoftwareSuite);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return robotSoftwareSuite != null ? robotSoftwareSuite.toBuilder() : null;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        @Override
        @Transient
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final SimulationSoftwareSuite.Builder getSimulationSoftwareSuite() {
            return simulationSoftwareSuite != null ? simulationSoftwareSuite.toBuilder() : null;
        }

        public final void setSimulationSoftwareSuite(SimulationSoftwareSuite.BuilderImpl simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite != null ? simulationSoftwareSuite.build() : null;
        }

        @Override
        @Transient
        public final Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        @Override
        public SimulationApplicationSummary build() {
            return new SimulationApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
