/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSimulationJobBatchRequest extends RoboMakerRequest implements
        ToCopyableBuilder<StartSimulationJobBatchRequest.Builder, StartSimulationJobBatchRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartSimulationJobBatchRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<BatchPolicy> BATCH_POLICY_FIELD = SdkField.<BatchPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("batchPolicy").getter(getter(StartSimulationJobBatchRequest::batchPolicy))
            .setter(setter(Builder::batchPolicy)).constructor(BatchPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPolicy").build()).build();

    private static final SdkField<List<SimulationJobRequest>> CREATE_SIMULATION_JOB_REQUESTS_FIELD = SdkField
            .<List<SimulationJobRequest>> builder(MarshallingType.LIST)
            .memberName("createSimulationJobRequests")
            .getter(getter(StartSimulationJobBatchRequest::createSimulationJobRequests))
            .setter(setter(Builder::createSimulationJobRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createSimulationJobRequests")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJobRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJobRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartSimulationJobBatchRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            BATCH_POLICY_FIELD, CREATE_SIMULATION_JOB_REQUESTS_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final BatchPolicy batchPolicy;

    private final List<SimulationJobRequest> createSimulationJobRequests;

    private final Map<String, String> tags;

    private StartSimulationJobBatchRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.batchPolicy = builder.batchPolicy;
        this.createSimulationJobRequests = builder.createSimulationJobRequests;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The batch policy.
     * </p>
     * 
     * @return The batch policy.
     */
    public final BatchPolicy batchPolicy() {
        return batchPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateSimulationJobRequests property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateSimulationJobRequests() {
        return createSimulationJobRequests != null && !(createSimulationJobRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation job requests to create in the batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateSimulationJobRequests} method.
     * </p>
     * 
     * @return A list of simulation job requests to create in the batch.
     */
    public final List<SimulationJobRequest> createSimulationJobRequests() {
        return createSimulationJobRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the deployment job batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the deployment job batch.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(batchPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateSimulationJobRequests() ? createSimulationJobRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSimulationJobBatchRequest)) {
            return false;
        }
        StartSimulationJobBatchRequest other = (StartSimulationJobBatchRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(batchPolicy(), other.batchPolicy())
                && hasCreateSimulationJobRequests() == other.hasCreateSimulationJobRequests()
                && Objects.equals(createSimulationJobRequests(), other.createSimulationJobRequests())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSimulationJobBatchRequest").add("ClientRequestToken", clientRequestToken())
                .add("BatchPolicy", batchPolicy())
                .add("CreateSimulationJobRequests", hasCreateSimulationJobRequests() ? createSimulationJobRequests() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "batchPolicy":
            return Optional.ofNullable(clazz.cast(batchPolicy()));
        case "createSimulationJobRequests":
            return Optional.ofNullable(clazz.cast(createSimulationJobRequests()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSimulationJobBatchRequest, T> g) {
        return obj -> g.apply((StartSimulationJobBatchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSimulationJobBatchRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The batch policy.
         * </p>
         * 
         * @param batchPolicy
         *        The batch policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPolicy(BatchPolicy batchPolicy);

        /**
         * <p>
         * The batch policy.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchPolicy.Builder} avoiding the need to create
         * one manually via {@link BatchPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchPolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #batchPolicy(BatchPolicy)}.
         * 
         * @param batchPolicy
         *        a consumer that will call methods on {@link BatchPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchPolicy(BatchPolicy)
         */
        default Builder batchPolicy(Consumer<BatchPolicy.Builder> batchPolicy) {
            return batchPolicy(BatchPolicy.builder().applyMutation(batchPolicy).build());
        }

        /**
         * <p>
         * A list of simulation job requests to create in the batch.
         * </p>
         * 
         * @param createSimulationJobRequests
         *        A list of simulation job requests to create in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSimulationJobRequests(Collection<SimulationJobRequest> createSimulationJobRequests);

        /**
         * <p>
         * A list of simulation job requests to create in the batch.
         * </p>
         * 
         * @param createSimulationJobRequests
         *        A list of simulation job requests to create in the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSimulationJobRequests(SimulationJobRequest... createSimulationJobRequests);

        /**
         * <p>
         * A list of simulation job requests to create in the batch.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJobRequest>.Builder} avoiding the
         * need to create one manually via {@link List<SimulationJobRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJobRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #createSimulationJobRequests(List<SimulationJobRequest>)}.
         * 
         * @param createSimulationJobRequests
         *        a consumer that will call methods on {@link List<SimulationJobRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createSimulationJobRequests(List<SimulationJobRequest>)
         */
        Builder createSimulationJobRequests(Consumer<SimulationJobRequest.Builder>... createSimulationJobRequests);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the deployment job batch.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the deployment job batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private BatchPolicy batchPolicy;

        private List<SimulationJobRequest> createSimulationJobRequests = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSimulationJobBatchRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            batchPolicy(model.batchPolicy);
            createSimulationJobRequests(model.createSimulationJobRequests);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final BatchPolicy.Builder getBatchPolicy() {
            return batchPolicy != null ? batchPolicy.toBuilder() : null;
        }

        public final void setBatchPolicy(BatchPolicy.BuilderImpl batchPolicy) {
            this.batchPolicy = batchPolicy != null ? batchPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder batchPolicy(BatchPolicy batchPolicy) {
            this.batchPolicy = batchPolicy;
            return this;
        }

        public final List<SimulationJobRequest.Builder> getCreateSimulationJobRequests() {
            List<SimulationJobRequest.Builder> result = CreateSimulationJobRequestsCopier
                    .copyToBuilder(this.createSimulationJobRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateSimulationJobRequests(Collection<SimulationJobRequest.BuilderImpl> createSimulationJobRequests) {
            this.createSimulationJobRequests = CreateSimulationJobRequestsCopier.copyFromBuilder(createSimulationJobRequests);
        }

        @Override
        @Transient
        public final Builder createSimulationJobRequests(Collection<SimulationJobRequest> createSimulationJobRequests) {
            this.createSimulationJobRequests = CreateSimulationJobRequestsCopier.copy(createSimulationJobRequests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createSimulationJobRequests(SimulationJobRequest... createSimulationJobRequests) {
            createSimulationJobRequests(Arrays.asList(createSimulationJobRequests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder createSimulationJobRequests(Consumer<SimulationJobRequest.Builder>... createSimulationJobRequests) {
            createSimulationJobRequests(Stream.of(createSimulationJobRequests)
                    .map(c -> SimulationJobRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSimulationJobBatchRequest build() {
            return new StartSimulationJobBatchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
