/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSimulationJobBatchResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeSimulationJobBatchResponse.Builder, DescribeSimulationJobBatchResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeSimulationJobBatchResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeSimulationJobBatchResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(DescribeSimulationJobBatchResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeSimulationJobBatchResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(DescribeSimulationJobBatchResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<BatchPolicy> BATCH_POLICY_FIELD = SdkField.<BatchPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("batchPolicy").getter(getter(DescribeSimulationJobBatchResponse::batchPolicy))
            .setter(setter(Builder::batchPolicy)).constructor(BatchPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPolicy").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(DescribeSimulationJobBatchResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DescribeSimulationJobBatchResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<List<FailedCreateSimulationJobRequest>> FAILED_REQUESTS_FIELD = SdkField
            .<List<FailedCreateSimulationJobRequest>> builder(MarshallingType.LIST)
            .memberName("failedRequests")
            .getter(getter(DescribeSimulationJobBatchResponse::failedRequests))
            .setter(setter(Builder::failedRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedCreateSimulationJobRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCreateSimulationJobRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SimulationJobRequest>> PENDING_REQUESTS_FIELD = SdkField
            .<List<SimulationJobRequest>> builder(MarshallingType.LIST)
            .memberName("pendingRequests")
            .getter(getter(DescribeSimulationJobBatchResponse::pendingRequests))
            .setter(setter(Builder::pendingRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJobRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJobRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SimulationJobSummary>> CREATED_REQUESTS_FIELD = SdkField
            .<List<SimulationJobSummary>> builder(MarshallingType.LIST)
            .memberName("createdRequests")
            .getter(getter(DescribeSimulationJobBatchResponse::createdRequests))
            .setter(setter(Builder::createdRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeSimulationJobBatchResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            LAST_UPDATED_AT_FIELD, CREATED_AT_FIELD, CLIENT_REQUEST_TOKEN_FIELD, BATCH_POLICY_FIELD, FAILURE_CODE_FIELD,
            FAILURE_REASON_FIELD, FAILED_REQUESTS_FIELD, PENDING_REQUESTS_FIELD, CREATED_REQUESTS_FIELD, TAGS_FIELD));

    private final String arn;

    private final String status;

    private final Instant lastUpdatedAt;

    private final Instant createdAt;

    private final String clientRequestToken;

    private final BatchPolicy batchPolicy;

    private final String failureCode;

    private final String failureReason;

    private final List<FailedCreateSimulationJobRequest> failedRequests;

    private final List<SimulationJobRequest> pendingRequests;

    private final List<SimulationJobSummary> createdRequests;

    private final Map<String, String> tags;

    private DescribeSimulationJobBatchResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.createdAt = builder.createdAt;
        this.clientRequestToken = builder.clientRequestToken;
        this.batchPolicy = builder.batchPolicy;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.failedRequests = builder.failedRequests;
        this.pendingRequests = builder.pendingRequests;
        this.createdRequests = builder.createdRequests;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the batch.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the batch.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the batch.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The simulation job batch request is pending.
     * </p>
     * </dd>
     * <dt>InProgress</dt>
     * <dd>
     * <p>
     * The simulation job batch is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal
     * failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for
     * more information.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in
     * the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2)
     * when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
     * <code>Failed</code>).
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The simulation batch job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The simulation batch job is being cancelled.
     * </p>
     * </dd>
     * <dt>Completing</dt>
     * <dd>
     * <p>
     * The simulation batch job is completing.
     * </p>
     * </dd>
     * <dt>TimingOut</dt>
     * <dd>
     * <p>
     * The simulation job batch is timing out.
     * </p>
     * <p>
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing
     * request, the batch status will be <code>TimedOut</code>.
     * </p>
     * </dd>
     * <dt>TimedOut</dt>
     * <dd>
     * <p>
     * The simulation batch job timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobBatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch request is pending.
     *         </p>
     *         </dd>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch failed. One or more simulation job requests could not be completed due to an
     *         internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
     *         <code>failureReason</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
     *         requests in the batch and none of the failed simulation job requests are due to
     *         <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state
     *         (for example, <code>Completed</code> or <code>Failed</code>).
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is being cancelled.
     *         </p>
     *         </dd>
     *         <dt>Completing</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is completing.
     *         </p>
     *         </dd>
     *         <dt>TimingOut</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is timing out.
     *         </p>
     *         <p>
     *         If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     *         <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
     *         failing request, the batch status will be <code>TimedOut</code>.
     *         </p>
     *         </dd>
     *         <dt>TimedOut</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job timed out.
     *         </p>
     *         </dd>
     * @see SimulationJobBatchStatus
     */
    public final SimulationJobBatchStatus status() {
        return SimulationJobBatchStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the batch.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The simulation job batch request is pending.
     * </p>
     * </dd>
     * <dt>InProgress</dt>
     * <dd>
     * <p>
     * The simulation job batch is in progress.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal
     * failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for
     * more information.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in
     * the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2)
     * when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
     * <code>Failed</code>).
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The simulation batch job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The simulation batch job is being cancelled.
     * </p>
     * </dd>
     * <dt>Completing</dt>
     * <dd>
     * <p>
     * The simulation batch job is completing.
     * </p>
     * </dd>
     * <dt>TimingOut</dt>
     * <dd>
     * <p>
     * The simulation job batch is timing out.
     * </p>
     * <p>
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing
     * request, the batch status will be <code>TimedOut</code>.
     * </p>
     * </dd>
     * <dt>TimedOut</dt>
     * <dd>
     * <p>
     * The simulation batch job timed out.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobBatchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch request is pending.
     *         </p>
     *         </dd>
     *         <dt>InProgress</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is in progress.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch failed. One or more simulation job requests could not be completed due to an
     *         internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
     *         <code>failureReason</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
     *         requests in the batch and none of the failed simulation job requests are due to
     *         <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state
     *         (for example, <code>Completed</code> or <code>Failed</code>).
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is being cancelled.
     *         </p>
     *         </dd>
     *         <dt>Completing</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job is completing.
     *         </p>
     *         </dd>
     *         <dt>TimingOut</dt>
     *         <dd>
     *         <p>
     *         The simulation job batch is timing out.
     *         </p>
     *         <p>
     *         If a batch timing out, and there are pending requests that were failing due to an internal failure (like
     *         <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
     *         failing request, the batch status will be <code>TimedOut</code>.
     *         </p>
     *         </dd>
     *         <dt>TimedOut</dt>
     *         <dd>
     *         <p>
     *         The simulation batch job timed out.
     *         </p>
     *         </dd>
     * @see SimulationJobBatchStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job batch was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job batch was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job batch was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The batch policy.
     * </p>
     * 
     * @return The batch policy.
     */
    public final BatchPolicy batchPolicy() {
        return batchPolicy;
    }

    /**
     * <p>
     * The failure code of the simulation job batch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobBatchErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job batch.
     * @see SimulationJobBatchErrorCode
     */
    public final SimulationJobBatchErrorCode failureCode() {
        return SimulationJobBatchErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the simulation job batch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobBatchErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job batch.
     * @see SimulationJobBatchErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The reason the simulation job batch failed.
     * </p>
     * 
     * @return The reason the simulation job batch failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * Returns true if the FailedRequests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailedRequests() {
        return failedRequests != null && !(failedRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of failed create simulation job requests. The request failed to be created into a simulation job. Failed
     * requests do not have a simulation job ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of failed create simulation job requests. The request failed to be created into a simulation job.
     *         Failed requests do not have a simulation job ID.
     */
    public final List<FailedCreateSimulationJobRequest> failedRequests() {
        return failedRequests;
    }

    /**
     * Returns true if the PendingRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPendingRequests() {
        return pendingRequests != null && !(pendingRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPendingRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
     */
    public final List<SimulationJobRequest> pendingRequests() {
        return pendingRequests;
    }

    /**
     * Returns true if the CreatedRequests property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCreatedRequests() {
        return createdRequests != null && !(createdRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of created simulation job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreatedRequests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of created simulation job summaries.
     */
    public final List<SimulationJobSummary> createdRequests() {
        return createdRequests;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the simulation job batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the simulation job batch.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(batchPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedRequests() ? failedRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingRequests() ? pendingRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatedRequests() ? createdRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSimulationJobBatchResponse)) {
            return false;
        }
        DescribeSimulationJobBatchResponse other = (DescribeSimulationJobBatchResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(batchPolicy(), other.batchPolicy())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureReason(), other.failureReason()) && hasFailedRequests() == other.hasFailedRequests()
                && Objects.equals(failedRequests(), other.failedRequests()) && hasPendingRequests() == other.hasPendingRequests()
                && Objects.equals(pendingRequests(), other.pendingRequests())
                && hasCreatedRequests() == other.hasCreatedRequests()
                && Objects.equals(createdRequests(), other.createdRequests()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSimulationJobBatchResponse").add("Arn", arn()).add("Status", statusAsString())
                .add("LastUpdatedAt", lastUpdatedAt()).add("CreatedAt", createdAt())
                .add("ClientRequestToken", clientRequestToken()).add("BatchPolicy", batchPolicy())
                .add("FailureCode", failureCodeAsString()).add("FailureReason", failureReason())
                .add("FailedRequests", hasFailedRequests() ? failedRequests() : null)
                .add("PendingRequests", hasPendingRequests() ? pendingRequests() : null)
                .add("CreatedRequests", hasCreatedRequests() ? createdRequests() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "batchPolicy":
            return Optional.ofNullable(clazz.cast(batchPolicy()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failedRequests":
            return Optional.ofNullable(clazz.cast(failedRequests()));
        case "pendingRequests":
            return Optional.ofNullable(clazz.cast(pendingRequests()));
        case "createdRequests":
            return Optional.ofNullable(clazz.cast(createdRequests()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSimulationJobBatchResponse, T> g) {
        return obj -> g.apply((DescribeSimulationJobBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSimulationJobBatchResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the batch.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the batch.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The simulation job batch request is pending.
         * </p>
         * </dd>
         * <dt>InProgress</dt>
         * <dd>
         * <p>
         * The simulation job batch is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an
         * internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         * <code>failureReason</code> for more information.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests
         * in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and
         * (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
         * <code>Failed</code>).
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The simulation batch job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The simulation batch job is being cancelled.
         * </p>
         * </dd>
         * <dt>Completing</dt>
         * <dd>
         * <p>
         * The simulation batch job is completing.
         * </p>
         * </dd>
         * <dt>TimingOut</dt>
         * <dd>
         * <p>
         * The simulation job batch is timing out.
         * </p>
         * <p>
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
         * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
         * failing request, the batch status will be <code>TimedOut</code>.
         * </p>
         * </dd>
         * <dt>TimedOut</dt>
         * <dd>
         * <p>
         * The simulation batch job timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the batch.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch request is pending.
         *        </p>
         *        </dd>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch failed. One or more simulation job requests could not be completed due to an
         *        internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         *        <code>failureReason</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
         *        requests in the batch and none of the failed simulation job requests are due to
         *        <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal
         *        state (for example, <code>Completed</code> or <code>Failed</code>).
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is being cancelled.
         *        </p>
         *        </dd>
         *        <dt>Completing</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is completing.
         *        </p>
         *        </dd>
         *        <dt>TimingOut</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is timing out.
         *        </p>
         *        <p>
         *        If a batch timing out, and there are pending requests that were failing due to an internal failure
         *        (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are
         *        no such failing request, the batch status will be <code>TimedOut</code>.
         *        </p>
         *        </dd>
         *        <dt>TimedOut</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job timed out.
         *        </p>
         *        </dd>
         * @see SimulationJobBatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the batch.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The simulation job batch request is pending.
         * </p>
         * </dd>
         * <dt>InProgress</dt>
         * <dd>
         * <p>
         * The simulation job batch is in progress.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an
         * internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         * <code>failureReason</code> for more information.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests
         * in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and
         * (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or
         * <code>Failed</code>).
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The simulation batch job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The simulation batch job is being cancelled.
         * </p>
         * </dd>
         * <dt>Completing</dt>
         * <dd>
         * <p>
         * The simulation batch job is completing.
         * </p>
         * </dd>
         * <dt>TimingOut</dt>
         * <dd>
         * <p>
         * The simulation job batch is timing out.
         * </p>
         * <p>
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like
         * <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such
         * failing request, the batch status will be <code>TimedOut</code>.
         * </p>
         * </dd>
         * <dt>TimedOut</dt>
         * <dd>
         * <p>
         * The simulation batch job timed out.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the batch.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch request is pending.
         *        </p>
         *        </dd>
         *        <dt>InProgress</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is in progress.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch failed. One or more simulation job requests could not be completed due to an
         *        internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and
         *        <code>failureReason</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job completed. A batch is complete when (1) there are no pending simulation job
         *        requests in the batch and none of the failed simulation job requests are due to
         *        <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal
         *        state (for example, <code>Completed</code> or <code>Failed</code>).
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is being cancelled.
         *        </p>
         *        </dd>
         *        <dt>Completing</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job is completing.
         *        </p>
         *        </dd>
         *        <dt>TimingOut</dt>
         *        <dd>
         *        <p>
         *        The simulation job batch is timing out.
         *        </p>
         *        <p>
         *        If a batch timing out, and there are pending requests that were failing due to an internal failure
         *        (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are
         *        no such failing request, the batch status will be <code>TimedOut</code>.
         *        </p>
         *        </dd>
         *        <dt>TimedOut</dt>
         *        <dd>
         *        <p>
         *        The simulation batch job timed out.
         *        </p>
         *        </dd>
         * @see SimulationJobBatchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchStatus
         */
        Builder status(SimulationJobBatchStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job batch was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation job batch was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job batch was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the simulation job batch was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The batch policy.
         * </p>
         * 
         * @param batchPolicy
         *        The batch policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPolicy(BatchPolicy batchPolicy);

        /**
         * <p>
         * The batch policy.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchPolicy.Builder} avoiding the need to create
         * one manually via {@link BatchPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchPolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #batchPolicy(BatchPolicy)}.
         * 
         * @param batchPolicy
         *        a consumer that will call methods on {@link BatchPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchPolicy(BatchPolicy)
         */
        default Builder batchPolicy(Consumer<BatchPolicy.Builder> batchPolicy) {
            return batchPolicy(BatchPolicy.builder().applyMutation(batchPolicy).build());
        }

        /**
         * <p>
         * The failure code of the simulation job batch.
         * </p>
         * 
         * @param failureCode
         *        The failure code of the simulation job batch.
         * @see SimulationJobBatchErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the simulation job batch.
         * </p>
         * 
         * @param failureCode
         *        The failure code of the simulation job batch.
         * @see SimulationJobBatchErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobBatchErrorCode
         */
        Builder failureCode(SimulationJobBatchErrorCode failureCode);

        /**
         * <p>
         * The reason the simulation job batch failed.
         * </p>
         * 
         * @param failureReason
         *        The reason the simulation job batch failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * A list of failed create simulation job requests. The request failed to be created into a simulation job.
         * Failed requests do not have a simulation job ID.
         * </p>
         * 
         * @param failedRequests
         *        A list of failed create simulation job requests. The request failed to be created into a simulation
         *        job. Failed requests do not have a simulation job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(Collection<FailedCreateSimulationJobRequest> failedRequests);

        /**
         * <p>
         * A list of failed create simulation job requests. The request failed to be created into a simulation job.
         * Failed requests do not have a simulation job ID.
         * </p>
         * 
         * @param failedRequests
         *        A list of failed create simulation job requests. The request failed to be created into a simulation
         *        job. Failed requests do not have a simulation job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRequests(FailedCreateSimulationJobRequest... failedRequests);

        /**
         * <p>
         * A list of failed create simulation job requests. The request failed to be created into a simulation job.
         * Failed requests do not have a simulation job ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedCreateSimulationJobRequest>.Builder}
         * avoiding the need to create one manually via {@link List<FailedCreateSimulationJobRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedCreateSimulationJobRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #failedRequests(List<FailedCreateSimulationJobRequest>)}.
         * 
         * @param failedRequests
         *        a consumer that will call methods on {@link List<FailedCreateSimulationJobRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedRequests(List<FailedCreateSimulationJobRequest>)
         */
        Builder failedRequests(Consumer<FailedCreateSimulationJobRequest.Builder>... failedRequests);

        /**
         * <p>
         * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
         * </p>
         * 
         * @param pendingRequests
         *        A list of pending simulation job requests. These requests have not yet been created into simulation
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRequests(Collection<SimulationJobRequest> pendingRequests);

        /**
         * <p>
         * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
         * </p>
         * 
         * @param pendingRequests
         *        A list of pending simulation job requests. These requests have not yet been created into simulation
         *        jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRequests(SimulationJobRequest... pendingRequests);

        /**
         * <p>
         * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJobRequest>.Builder} avoiding the
         * need to create one manually via {@link List<SimulationJobRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJobRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #pendingRequests(List<SimulationJobRequest>)}.
         * 
         * @param pendingRequests
         *        a consumer that will call methods on {@link List<SimulationJobRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingRequests(List<SimulationJobRequest>)
         */
        Builder pendingRequests(Consumer<SimulationJobRequest.Builder>... pendingRequests);

        /**
         * <p>
         * A list of created simulation job summaries.
         * </p>
         * 
         * @param createdRequests
         *        A list of created simulation job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRequests(Collection<SimulationJobSummary> createdRequests);

        /**
         * <p>
         * A list of created simulation job summaries.
         * </p>
         * 
         * @param createdRequests
         *        A list of created simulation job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRequests(SimulationJobSummary... createdRequests);

        /**
         * <p>
         * A list of created simulation job summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJobSummary>.Builder} avoiding the
         * need to create one manually via {@link List<SimulationJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJobSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #createdRequests(List<SimulationJobSummary>)}.
         * 
         * @param createdRequests
         *        a consumer that will call methods on {@link List<SimulationJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdRequests(List<SimulationJobSummary>)
         */
        Builder createdRequests(Consumer<SimulationJobSummary.Builder>... createdRequests);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the simulation job batch.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the simulation job batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant lastUpdatedAt;

        private Instant createdAt;

        private String clientRequestToken;

        private BatchPolicy batchPolicy;

        private String failureCode;

        private String failureReason;

        private List<FailedCreateSimulationJobRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private List<SimulationJobRequest> pendingRequests = DefaultSdkAutoConstructList.getInstance();

        private List<SimulationJobSummary> createdRequests = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSimulationJobBatchResponse model) {
            super(model);
            arn(model.arn);
            status(model.status);
            lastUpdatedAt(model.lastUpdatedAt);
            createdAt(model.createdAt);
            clientRequestToken(model.clientRequestToken);
            batchPolicy(model.batchPolicy);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
            failedRequests(model.failedRequests);
            pendingRequests(model.pendingRequests);
            createdRequests(model.createdRequests);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobBatchStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final BatchPolicy.Builder getBatchPolicy() {
            return batchPolicy != null ? batchPolicy.toBuilder() : null;
        }

        @Override
        public final Builder batchPolicy(BatchPolicy batchPolicy) {
            this.batchPolicy = batchPolicy;
            return this;
        }

        public final void setBatchPolicy(BatchPolicy.BuilderImpl batchPolicy) {
            this.batchPolicy = batchPolicy != null ? batchPolicy.build() : null;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobBatchErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final List<FailedCreateSimulationJobRequest.Builder> getFailedRequests() {
            List<FailedCreateSimulationJobRequest.Builder> result = FailedCreateSimulationJobRequestsCopier
                    .copyToBuilder(this.failedRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedRequests(Collection<FailedCreateSimulationJobRequest> failedRequests) {
            this.failedRequests = FailedCreateSimulationJobRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedCreateSimulationJobRequest... failedRequests) {
            failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedCreateSimulationJobRequest.Builder>... failedRequests) {
            failedRequests(Stream.of(failedRequests)
                    .map(c -> FailedCreateSimulationJobRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedRequests(Collection<FailedCreateSimulationJobRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedCreateSimulationJobRequestsCopier.copyFromBuilder(failedRequests);
        }

        public final List<SimulationJobRequest.Builder> getPendingRequests() {
            List<SimulationJobRequest.Builder> result = CreateSimulationJobRequestsCopier.copyToBuilder(this.pendingRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pendingRequests(Collection<SimulationJobRequest> pendingRequests) {
            this.pendingRequests = CreateSimulationJobRequestsCopier.copy(pendingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(SimulationJobRequest... pendingRequests) {
            pendingRequests(Arrays.asList(pendingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Consumer<SimulationJobRequest.Builder>... pendingRequests) {
            pendingRequests(Stream.of(pendingRequests).map(c -> SimulationJobRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPendingRequests(Collection<SimulationJobRequest.BuilderImpl> pendingRequests) {
            this.pendingRequests = CreateSimulationJobRequestsCopier.copyFromBuilder(pendingRequests);
        }

        public final List<SimulationJobSummary.Builder> getCreatedRequests() {
            List<SimulationJobSummary.Builder> result = SimulationJobSummariesCopier.copyToBuilder(this.createdRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder createdRequests(Collection<SimulationJobSummary> createdRequests) {
            this.createdRequests = SimulationJobSummariesCopier.copy(createdRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdRequests(SimulationJobSummary... createdRequests) {
            createdRequests(Arrays.asList(createdRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdRequests(Consumer<SimulationJobSummary.Builder>... createdRequests) {
            createdRequests(Stream.of(createdRequests).map(c -> SimulationJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCreatedRequests(Collection<SimulationJobSummary.BuilderImpl> createdRequests) {
            this.createdRequests = SimulationJobSummariesCopier.copyFromBuilder(createdRequests);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeSimulationJobBatchResponse build() {
            return new DescribeSimulationJobBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
