/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorldTemplatesResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListWorldTemplatesResponse.Builder, ListWorldTemplatesResponse> {
    private static final SdkField<List<TemplateSummary>> TEMPLATE_SUMMARIES_FIELD = SdkField
            .<List<TemplateSummary>> builder(MarshallingType.LIST)
            .memberName("templateSummaries")
            .getter(getter(ListWorldTemplatesResponse::templateSummaries))
            .setter(setter(Builder::templateSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorldTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TemplateSummary> templateSummaries;

    private final String nextToken;

    private ListWorldTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templateSummaries = builder.templateSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TemplateSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTemplateSummaries() {
        return templateSummaries != null && !(templateSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTemplateSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information for templates.
     */
    public final List<TemplateSummary> templateSummaries() {
        return templateSummaries;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code>
     * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListWorldTemplates</code> again and assign that token to the request object's
     *         <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
     *         NextToken parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateSummaries() ? templateSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldTemplatesResponse)) {
            return false;
        }
        ListWorldTemplatesResponse other = (ListWorldTemplatesResponse) obj;
        return hasTemplateSummaries() == other.hasTemplateSummaries()
                && Objects.equals(templateSummaries(), other.templateSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorldTemplatesResponse")
                .add("TemplateSummaries", hasTemplateSummaries() ? templateSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateSummaries":
            return Optional.ofNullable(clazz.cast(templateSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorldTemplatesResponse, T> g) {
        return obj -> g.apply((ListWorldTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorldTemplatesResponse> {
        /**
         * <p>
         * Summary information for templates.
         * </p>
         * 
         * @param templateSummaries
         *        Summary information for templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSummaries(Collection<TemplateSummary> templateSummaries);

        /**
         * <p>
         * Summary information for templates.
         * </p>
         * 
         * @param templateSummaries
         *        Summary information for templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSummaries(TemplateSummary... templateSummaries);

        /**
         * <p>
         * Summary information for templates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateSummary>.Builder} avoiding the need
         * to create one manually via {@link List<TemplateSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #templateSummaries(List<TemplateSummary>)}.
         * 
         * @param templateSummaries
         *        a consumer that will call methods on {@link List<TemplateSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateSummaries(List<TemplateSummary>)
         */
        Builder templateSummaries(Consumer<TemplateSummary.Builder>... templateSummaries);

        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code>
         * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to
         * null.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListWorldTemplates</code> again and assign that token to the request object's
         *        <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
         *        NextToken parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<TemplateSummary> templateSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldTemplatesResponse model) {
            super(model);
            templateSummaries(model.templateSummaries);
            nextToken(model.nextToken);
        }

        public final List<TemplateSummary.Builder> getTemplateSummaries() {
            List<TemplateSummary.Builder> result = TemplateSummariesCopier.copyToBuilder(this.templateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder templateSummaries(Collection<TemplateSummary> templateSummaries) {
            this.templateSummaries = TemplateSummariesCopier.copy(templateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummaries(TemplateSummary... templateSummaries) {
            templateSummaries(Arrays.asList(templateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateSummaries(Consumer<TemplateSummary.Builder>... templateSummaries) {
            templateSummaries(Stream.of(templateSummaries).map(c -> TemplateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTemplateSummaries(Collection<TemplateSummary.BuilderImpl> templateSummaries) {
            this.templateSummaries = TemplateSummariesCopier.copyFromBuilder(templateSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorldTemplatesResponse build() {
            return new ListWorldTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
