/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a failed world.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldFailure implements SdkPojo, Serializable, ToCopyableBuilder<WorldFailure.Builder, WorldFailure> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(WorldFailure::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> SAMPLE_FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleFailureReason").getter(getter(WorldFailure::sampleFailureReason))
            .setter(setter(Builder::sampleFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleFailureReason").build())
            .build();

    private static final SdkField<Integer> FAILURE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failureCount").getter(getter(WorldFailure::failureCount)).setter(setter(Builder::failureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD,
            SAMPLE_FAILURE_REASON_FIELD, FAILURE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureCode;

    private final String sampleFailureReason;

    private final Integer failureCount;

    private WorldFailure(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.sampleFailureReason = builder.sampleFailureReason;
        this.failureCount = builder.failureCount;
    }

    /**
     * <p>
     * The failure code of the world export job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldGenerationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world export job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobErrorCode
     */
    public final WorldGenerationJobErrorCode failureCode() {
        return WorldGenerationJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the world export job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldGenerationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world export job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The sample reason why the world failed. World errors are aggregated. A sample is used as the
     * <code>sampleFailureReason</code>.
     * </p>
     * 
     * @return The sample reason why the world failed. World errors are aggregated. A sample is used as the
     *         <code>sampleFailureReason</code>.
     */
    public final String sampleFailureReason() {
        return sampleFailureReason;
    }

    /**
     * <p>
     * The number of failed worlds.
     * </p>
     * 
     * @return The number of failed worlds.
     */
    public final Integer failureCount() {
        return failureCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldFailure)) {
            return false;
        }
        WorldFailure other = (WorldFailure) obj;
        return Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(sampleFailureReason(), other.sampleFailureReason())
                && Objects.equals(failureCount(), other.failureCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorldFailure").add("FailureCode", failureCodeAsString())
                .add("SampleFailureReason", sampleFailureReason()).add("FailureCount", failureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "sampleFailureReason":
            return Optional.ofNullable(clazz.cast(sampleFailureReason()));
        case "failureCount":
            return Optional.ofNullable(clazz.cast(failureCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldFailure, T> g) {
        return obj -> g.apply((WorldFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldFailure> {
        /**
         * <p>
         * The failure code of the world export job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world export job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the world export job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world export job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobErrorCode
         */
        Builder failureCode(WorldGenerationJobErrorCode failureCode);

        /**
         * <p>
         * The sample reason why the world failed. World errors are aggregated. A sample is used as the
         * <code>sampleFailureReason</code>.
         * </p>
         * 
         * @param sampleFailureReason
         *        The sample reason why the world failed. World errors are aggregated. A sample is used as the
         *        <code>sampleFailureReason</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleFailureReason(String sampleFailureReason);

        /**
         * <p>
         * The number of failed worlds.
         * </p>
         * 
         * @param failureCount
         *        The number of failed worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCount(Integer failureCount);
    }

    static final class BuilderImpl implements Builder {
        private String failureCode;

        private String sampleFailureReason;

        private Integer failureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldFailure model) {
            failureCode(model.failureCode);
            sampleFailureReason(model.sampleFailureReason);
            failureCount(model.failureCount);
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldGenerationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getSampleFailureReason() {
            return sampleFailureReason;
        }

        @Override
        public final Builder sampleFailureReason(String sampleFailureReason) {
            this.sampleFailureReason = sampleFailureReason;
            return this;
        }

        public final void setSampleFailureReason(String sampleFailureReason) {
            this.sampleFailureReason = sampleFailureReason;
        }

        public final Integer getFailureCount() {
            return failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        @Override
        public WorldFailure build() {
            return new WorldFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
