/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information for a simulation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationJobSummary.Builder, SimulationJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SimulationJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(SimulationJobSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SimulationJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SimulationJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> SIMULATION_APPLICATION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("simulationApplicationNames")
            .getter(getter(SimulationJobSummary::simulationApplicationNames))
            .setter(setter(Builder::simulationApplicationNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplicationNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROBOT_APPLICATION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("robotApplicationNames")
            .getter(getter(SimulationJobSummary::robotApplicationNames))
            .setter(setter(Builder::robotApplicationNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplicationNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_SOURCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dataSourceNames")
            .getter(getter(SimulationJobSummary::dataSourceNames))
            .setter(setter(Builder::dataSourceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeType").getter(getter(SimulationJobSummary::computeTypeAsString))
            .setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD, SIMULATION_APPLICATION_NAMES_FIELD, ROBOT_APPLICATION_NAMES_FIELD,
            DATA_SOURCE_NAMES_FIELD, COMPUTE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String status;

    private final List<String> simulationApplicationNames;

    private final List<String> robotApplicationNames;

    private final List<String> dataSourceNames;

    private final String computeType;

    private SimulationJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.simulationApplicationNames = builder.simulationApplicationNames;
        this.robotApplicationNames = builder.robotApplicationNames;
        this.dataSourceNames = builder.dataSourceNames;
        this.computeType = builder.computeType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the simulation job.
     * </p>
     * 
     * @return The name of the simulation job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job.
     * @see SimulationJobStatus
     */
    public final SimulationJobStatus status() {
        return SimulationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job.
     * @see SimulationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SimulationApplicationNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSimulationApplicationNames() {
        return simulationApplicationNames != null && !(simulationApplicationNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation job simulation application names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSimulationApplicationNames} method.
     * </p>
     * 
     * @return A list of simulation job simulation application names.
     */
    public final List<String> simulationApplicationNames() {
        return simulationApplicationNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the RobotApplicationNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRobotApplicationNames() {
        return robotApplicationNames != null && !(robotApplicationNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation job robot application names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRobotApplicationNames} method.
     * </p>
     * 
     * @return A list of simulation job robot application names.
     */
    public final List<String> robotApplicationNames() {
        return robotApplicationNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSourceNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSourceNames() {
        return dataSourceNames != null && !(dataSourceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSourceNames} method.
     * </p>
     * 
     * @return The names of the data sources.
     */
    public final List<String> dataSourceNames() {
        return dataSourceNames;
    }

    /**
     * <p>
     * The compute type for the simulation job summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The compute type for the simulation job summary.
     * @see ComputeType
     */
    public final ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * The compute type for the simulation job summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The compute type for the simulation job summary.
     * @see ComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSimulationApplicationNames() ? simulationApplicationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRobotApplicationNames() ? robotApplicationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSourceNames() ? dataSourceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobSummary)) {
            return false;
        }
        SimulationJobSummary other = (SimulationJobSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasSimulationApplicationNames() == other.hasSimulationApplicationNames()
                && Objects.equals(simulationApplicationNames(), other.simulationApplicationNames())
                && hasRobotApplicationNames() == other.hasRobotApplicationNames()
                && Objects.equals(robotApplicationNames(), other.robotApplicationNames())
                && hasDataSourceNames() == other.hasDataSourceNames()
                && Objects.equals(dataSourceNames(), other.dataSourceNames())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationJobSummary").add("Arn", arn()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Name", name()).add("Status", statusAsString())
                .add("SimulationApplicationNames", hasSimulationApplicationNames() ? simulationApplicationNames() : null)
                .add("RobotApplicationNames", hasRobotApplicationNames() ? robotApplicationNames() : null)
                .add("DataSourceNames", hasDataSourceNames() ? dataSourceNames() : null)
                .add("ComputeType", computeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "simulationApplicationNames":
            return Optional.ofNullable(clazz.cast(simulationApplicationNames()));
        case "robotApplicationNames":
            return Optional.ofNullable(clazz.cast(robotApplicationNames()));
        case "dataSourceNames":
            return Optional.ofNullable(clazz.cast(dataSourceNames()));
        case "computeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobSummary, T> g) {
        return obj -> g.apply((SimulationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the simulation job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the simulation job.
         * </p>
         * 
         * @param name
         *        The name of the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the simulation job.
         * </p>
         * 
         * @param status
         *        The status of the simulation job.
         * @see SimulationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the simulation job.
         * </p>
         * 
         * @param status
         *        The status of the simulation job.
         * @see SimulationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobStatus
         */
        Builder status(SimulationJobStatus status);

        /**
         * <p>
         * A list of simulation job simulation application names.
         * </p>
         * 
         * @param simulationApplicationNames
         *        A list of simulation job simulation application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplicationNames(Collection<String> simulationApplicationNames);

        /**
         * <p>
         * A list of simulation job simulation application names.
         * </p>
         * 
         * @param simulationApplicationNames
         *        A list of simulation job simulation application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplicationNames(String... simulationApplicationNames);

        /**
         * <p>
         * A list of simulation job robot application names.
         * </p>
         * 
         * @param robotApplicationNames
         *        A list of simulation job robot application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplicationNames(Collection<String> robotApplicationNames);

        /**
         * <p>
         * A list of simulation job robot application names.
         * </p>
         * 
         * @param robotApplicationNames
         *        A list of simulation job robot application names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplicationNames(String... robotApplicationNames);

        /**
         * <p>
         * The names of the data sources.
         * </p>
         * 
         * @param dataSourceNames
         *        The names of the data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceNames(Collection<String> dataSourceNames);

        /**
         * <p>
         * The names of the data sources.
         * </p>
         * 
         * @param dataSourceNames
         *        The names of the data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceNames(String... dataSourceNames);

        /**
         * <p>
         * The compute type for the simulation job summary.
         * </p>
         * 
         * @param computeType
         *        The compute type for the simulation job summary.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * The compute type for the simulation job summary.
         * </p>
         * 
         * @param computeType
         *        The compute type for the simulation job summary.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant lastUpdatedAt;

        private String name;

        private String status;

        private List<String> simulationApplicationNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> robotApplicationNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataSourceNames = DefaultSdkAutoConstructList.getInstance();

        private String computeType;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobSummary model) {
            arn(model.arn);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            status(model.status);
            simulationApplicationNames(model.simulationApplicationNames);
            robotApplicationNames(model.robotApplicationNames);
            dataSourceNames(model.dataSourceNames);
            computeType(model.computeType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SimulationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSimulationApplicationNames() {
            if (simulationApplicationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return simulationApplicationNames;
        }

        public final void setSimulationApplicationNames(Collection<String> simulationApplicationNames) {
            this.simulationApplicationNames = SimulationApplicationNamesCopier.copy(simulationApplicationNames);
        }

        @Override
        @Transient
        public final Builder simulationApplicationNames(Collection<String> simulationApplicationNames) {
            this.simulationApplicationNames = SimulationApplicationNamesCopier.copy(simulationApplicationNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder simulationApplicationNames(String... simulationApplicationNames) {
            simulationApplicationNames(Arrays.asList(simulationApplicationNames));
            return this;
        }

        public final Collection<String> getRobotApplicationNames() {
            if (robotApplicationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return robotApplicationNames;
        }

        public final void setRobotApplicationNames(Collection<String> robotApplicationNames) {
            this.robotApplicationNames = RobotApplicationNamesCopier.copy(robotApplicationNames);
        }

        @Override
        @Transient
        public final Builder robotApplicationNames(Collection<String> robotApplicationNames) {
            this.robotApplicationNames = RobotApplicationNamesCopier.copy(robotApplicationNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder robotApplicationNames(String... robotApplicationNames) {
            robotApplicationNames(Arrays.asList(robotApplicationNames));
            return this;
        }

        public final Collection<String> getDataSourceNames() {
            if (dataSourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSourceNames;
        }

        public final void setDataSourceNames(Collection<String> dataSourceNames) {
            this.dataSourceNames = DataSourceNamesCopier.copy(dataSourceNames);
        }

        @Override
        @Transient
        public final Builder dataSourceNames(Collection<String> dataSourceNames) {
            this.dataSourceNames = DataSourceNamesCopier.copy(dataSourceNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSourceNames(String... dataSourceNames) {
            dataSourceNames(Arrays.asList(dataSourceNames));
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        @Transient
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        @Transient
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        @Override
        public SimulationJobSummary build() {
            return new SimulationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
