/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSimulationApplicationRequest extends RoboMakerRequest implements
        ToCopyableBuilder<UpdateSimulationApplicationRequest.Builder, UpdateSimulationApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(UpdateSimulationApplicationRequest::application))
            .setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<List<SourceConfig>> SOURCES_FIELD = SdkField
            .<List<SourceConfig>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(UpdateSimulationApplicationRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SimulationSoftwareSuite> SIMULATION_SOFTWARE_SUITE_FIELD = SdkField
            .<SimulationSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("simulationSoftwareSuite")
            .getter(getter(UpdateSimulationApplicationRequest::simulationSoftwareSuite))
            .setter(setter(Builder::simulationSoftwareSuite)).constructor(SimulationSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationSoftwareSuite").build())
            .build();

    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField
            .<RobotSoftwareSuite> builder(MarshallingType.SDK_POJO).memberName("robotSoftwareSuite")
            .getter(getter(UpdateSimulationApplicationRequest::robotSoftwareSuite)).setter(setter(Builder::robotSoftwareSuite))
            .constructor(RobotSoftwareSuite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build())
            .build();

    private static final SdkField<RenderingEngine> RENDERING_ENGINE_FIELD = SdkField
            .<RenderingEngine> builder(MarshallingType.SDK_POJO).memberName("renderingEngine")
            .getter(getter(UpdateSimulationApplicationRequest::renderingEngine)).setter(setter(Builder::renderingEngine))
            .constructor(RenderingEngine::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingEngine").build()).build();

    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentRevisionId").getter(getter(UpdateSimulationApplicationRequest::currentRevisionId))
            .setter(setter(Builder::currentRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()).build();

    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.<Environment> builder(MarshallingType.SDK_POJO)
            .memberName("environment").getter(getter(UpdateSimulationApplicationRequest::environment))
            .setter(setter(Builder::environment)).constructor(Environment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            SOURCES_FIELD, SIMULATION_SOFTWARE_SUITE_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, RENDERING_ENGINE_FIELD,
            CURRENT_REVISION_ID_FIELD, ENVIRONMENT_FIELD));

    private final String application;

    private final List<SourceConfig> sources;

    private final SimulationSoftwareSuite simulationSoftwareSuite;

    private final RobotSoftwareSuite robotSoftwareSuite;

    private final RenderingEngine renderingEngine;

    private final String currentRevisionId;

    private final Environment environment;

    private UpdateSimulationApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.sources = builder.sources;
        this.simulationSoftwareSuite = builder.simulationSoftwareSuite;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.renderingEngine = builder.renderingEngine;
        this.currentRevisionId = builder.currentRevisionId;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The application information for the simulation application.
     * </p>
     * 
     * @return The application information for the simulation application.
     */
    public final String application() {
        return application;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources of the simulation application.
     */
    public final List<SourceConfig> sources() {
        return sources;
    }

    /**
     * <p>
     * The simulation software suite used by the simulation application.
     * </p>
     * 
     * @return The simulation software suite used by the simulation application.
     */
    public final SimulationSoftwareSuite simulationSoftwareSuite() {
        return simulationSoftwareSuite;
    }

    /**
     * <p>
     * Information about the robot software suite (ROS distribution).
     * </p>
     * 
     * @return Information about the robot software suite (ROS distribution).
     */
    public final RobotSoftwareSuite robotSoftwareSuite() {
        return robotSoftwareSuite;
    }

    /**
     * <p>
     * The rendering engine for the simulation application.
     * </p>
     * 
     * @return The rendering engine for the simulation application.
     */
    public final RenderingEngine renderingEngine() {
        return renderingEngine;
    }

    /**
     * <p>
     * The revision id for the robot application.
     * </p>
     * 
     * @return The revision id for the robot application.
     */
    public final String currentRevisionId() {
        return currentRevisionId;
    }

    /**
     * <p>
     * The object that contains the Docker image URI for your simulation application.
     * </p>
     * 
     * @return The object that contains the Docker image URI for your simulation application.
     */
    public final Environment environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(simulationSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(renderingEngine());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSimulationApplicationRequest)) {
            return false;
        }
        UpdateSimulationApplicationRequest other = (UpdateSimulationApplicationRequest) obj;
        return Objects.equals(application(), other.application()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources())
                && Objects.equals(simulationSoftwareSuite(), other.simulationSoftwareSuite())
                && Objects.equals(robotSoftwareSuite(), other.robotSoftwareSuite())
                && Objects.equals(renderingEngine(), other.renderingEngine())
                && Objects.equals(currentRevisionId(), other.currentRevisionId())
                && Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSimulationApplicationRequest").add("Application", application())
                .add("Sources", hasSources() ? sources() : null).add("SimulationSoftwareSuite", simulationSoftwareSuite())
                .add("RobotSoftwareSuite", robotSoftwareSuite()).add("RenderingEngine", renderingEngine())
                .add("CurrentRevisionId", currentRevisionId()).add("Environment", environment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "simulationSoftwareSuite":
            return Optional.ofNullable(clazz.cast(simulationSoftwareSuite()));
        case "robotSoftwareSuite":
            return Optional.ofNullable(clazz.cast(robotSoftwareSuite()));
        case "renderingEngine":
            return Optional.ofNullable(clazz.cast(renderingEngine()));
        case "currentRevisionId":
            return Optional.ofNullable(clazz.cast(currentRevisionId()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSimulationApplicationRequest, T> g) {
        return obj -> g.apply((UpdateSimulationApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSimulationApplicationRequest> {
        /**
         * <p>
         * The application information for the simulation application.
         * </p>
         * 
         * @param application
         *        The application information for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<SourceConfig> sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * 
         * @param sources
         *        The sources of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(SourceConfig... sources);

        /**
         * <p>
         * The sources of the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceConfig>.Builder} avoiding the need to
         * create one manually via {@link List<SourceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<SourceConfig>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<SourceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<SourceConfig>)
         */
        Builder sources(Consumer<SourceConfig.Builder>... sources);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * 
         * @param simulationSoftwareSuite
         *        The simulation software suite used by the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite);

        /**
         * <p>
         * The simulation software suite used by the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link SimulationSoftwareSuite.Builder} avoiding the
         * need to create one manually via {@link SimulationSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimulationSoftwareSuite.Builder#build()} is called immediately
         * and its result is passed to {@link #simulationSoftwareSuite(SimulationSoftwareSuite)}.
         * 
         * @param simulationSoftwareSuite
         *        a consumer that will call methods on {@link SimulationSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationSoftwareSuite(SimulationSoftwareSuite)
         */
        default Builder simulationSoftwareSuite(Consumer<SimulationSoftwareSuite.Builder> simulationSoftwareSuite) {
            return simulationSoftwareSuite(SimulationSoftwareSuite.builder().applyMutation(simulationSoftwareSuite).build());
        }

        /**
         * <p>
         * Information about the robot software suite (ROS distribution).
         * </p>
         * 
         * @param robotSoftwareSuite
         *        Information about the robot software suite (ROS distribution).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite);

        /**
         * <p>
         * Information about the robot software suite (ROS distribution).
         * </p>
         * This is a convenience that creates an instance of the {@link RobotSoftwareSuite.Builder} avoiding the need to
         * create one manually via {@link RobotSoftwareSuite#builder()}.
         *
         * When the {@link Consumer} completes, {@link RobotSoftwareSuite.Builder#build()} is called immediately and its
         * result is passed to {@link #robotSoftwareSuite(RobotSoftwareSuite)}.
         * 
         * @param robotSoftwareSuite
         *        a consumer that will call methods on {@link RobotSoftwareSuite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotSoftwareSuite(RobotSoftwareSuite)
         */
        default Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return robotSoftwareSuite(RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite).build());
        }

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * 
         * @param renderingEngine
         *        The rendering engine for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingEngine(RenderingEngine renderingEngine);

        /**
         * <p>
         * The rendering engine for the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link RenderingEngine.Builder} avoiding the need to
         * create one manually via {@link RenderingEngine#builder()}.
         *
         * When the {@link Consumer} completes, {@link RenderingEngine.Builder#build()} is called immediately and its
         * result is passed to {@link #renderingEngine(RenderingEngine)}.
         * 
         * @param renderingEngine
         *        a consumer that will call methods on {@link RenderingEngine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingEngine(RenderingEngine)
         */
        default Builder renderingEngine(Consumer<RenderingEngine.Builder> renderingEngine) {
            return renderingEngine(RenderingEngine.builder().applyMutation(renderingEngine).build());
        }

        /**
         * <p>
         * The revision id for the robot application.
         * </p>
         * 
         * @param currentRevisionId
         *        The revision id for the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevisionId(String currentRevisionId);

        /**
         * <p>
         * The object that contains the Docker image URI for your simulation application.
         * </p>
         * 
         * @param environment
         *        The object that contains the Docker image URI for your simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Environment environment);

        /**
         * <p>
         * The object that contains the Docker image URI for your simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link Environment.Builder} avoiding the need to create
         * one manually via {@link Environment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Environment.Builder#build()} is called immediately and its result
         * is passed to {@link #environment(Environment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(Environment)
         */
        default Builder environment(Consumer<Environment.Builder> environment) {
            return environment(Environment.builder().applyMutation(environment).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String application;

        private List<SourceConfig> sources = DefaultSdkAutoConstructList.getInstance();

        private SimulationSoftwareSuite simulationSoftwareSuite;

        private RobotSoftwareSuite robotSoftwareSuite;

        private RenderingEngine renderingEngine;

        private String currentRevisionId;

        private Environment environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSimulationApplicationRequest model) {
            super(model);
            application(model.application);
            sources(model.sources);
            simulationSoftwareSuite(model.simulationSoftwareSuite);
            robotSoftwareSuite(model.robotSoftwareSuite);
            renderingEngine(model.renderingEngine);
            currentRevisionId(model.currentRevisionId);
            environment(model.environment);
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        @Transient
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final List<SourceConfig.Builder> getSources() {
            List<SourceConfig.Builder> result = SourceConfigsCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<SourceConfig.BuilderImpl> sources) {
            this.sources = SourceConfigsCopier.copyFromBuilder(sources);
        }

        @Override
        @Transient
        public final Builder sources(Collection<SourceConfig> sources) {
            this.sources = SourceConfigsCopier.copy(sources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(SourceConfig... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfig.Builder>... sources) {
            sources(Stream.of(sources).map(c -> SourceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SimulationSoftwareSuite.Builder getSimulationSoftwareSuite() {
            return simulationSoftwareSuite != null ? simulationSoftwareSuite.toBuilder() : null;
        }

        public final void setSimulationSoftwareSuite(SimulationSoftwareSuite.BuilderImpl simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite != null ? simulationSoftwareSuite.build() : null;
        }

        @Override
        @Transient
        public final Builder simulationSoftwareSuite(SimulationSoftwareSuite simulationSoftwareSuite) {
            this.simulationSoftwareSuite = simulationSoftwareSuite;
            return this;
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return robotSoftwareSuite != null ? robotSoftwareSuite.toBuilder() : null;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        @Override
        @Transient
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final RenderingEngine.Builder getRenderingEngine() {
            return renderingEngine != null ? renderingEngine.toBuilder() : null;
        }

        public final void setRenderingEngine(RenderingEngine.BuilderImpl renderingEngine) {
            this.renderingEngine = renderingEngine != null ? renderingEngine.build() : null;
        }

        @Override
        @Transient
        public final Builder renderingEngine(RenderingEngine renderingEngine) {
            this.renderingEngine = renderingEngine;
            return this;
        }

        public final String getCurrentRevisionId() {
            return currentRevisionId;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        @Transient
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final Environment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        @Transient
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSimulationApplicationRequest build() {
            return new UpdateSimulationApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
