/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorldTemplateBodyRequest extends RoboMakerRequest implements
        ToCopyableBuilder<GetWorldTemplateBodyRequest.Builder, GetWorldTemplateBodyRequest> {
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(GetWorldTemplateBodyRequest::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<String> GENERATION_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationJob").getter(getter(GetWorldTemplateBodyRequest::generationJob))
            .setter(setter(Builder::generationJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD,
            GENERATION_JOB_FIELD));

    private final String template;

    private final String generationJob;

    private GetWorldTemplateBodyRequest(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
        this.generationJob = builder.generationJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world template.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world template.
     */
    public final String template() {
        return template;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world generator job.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world generator job.
     */
    public final String generationJob() {
        return generationJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(generationJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorldTemplateBodyRequest)) {
            return false;
        }
        GetWorldTemplateBodyRequest other = (GetWorldTemplateBodyRequest) obj;
        return Objects.equals(template(), other.template()) && Objects.equals(generationJob(), other.generationJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorldTemplateBodyRequest").add("Template", template()).add("GenerationJob", generationJob())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "generationJob":
            return Optional.ofNullable(clazz.cast(generationJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorldTemplateBodyRequest, T> g) {
        return obj -> g.apply((GetWorldTemplateBodyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetWorldTemplateBodyRequest> {
        /**
         * <p>
         * The Amazon Resource Name (arn) of the world template.
         * </p>
         * 
         * @param template
         *        The Amazon Resource Name (arn) of the world template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * The Amazon Resource Name (arn) of the world generator job.
         * </p>
         * 
         * @param generationJob
         *        The Amazon Resource Name (arn) of the world generator job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationJob(String generationJob);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String template;

        private String generationJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorldTemplateBodyRequest model) {
            super(model);
            template(model.template);
            generationJob(model.generationJob);
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        @Transient
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final String getGenerationJob() {
            return generationJob;
        }

        public final void setGenerationJob(String generationJob) {
            this.generationJob = generationJob;
        }

        @Override
        @Transient
        public final Builder generationJob(String generationJob) {
            this.generationJob = generationJob;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorldTemplateBodyRequest build() {
            return new GetWorldTemplateBodyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
