/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum DeploymentJobErrorCode {
    RESOURCE_NOT_FOUND("ResourceNotFound"),

    ENVIRONMENT_SETUP_ERROR("EnvironmentSetupError"),

    ETAG_MISMATCH("EtagMismatch"),

    FAILURE_THRESHOLD_BREACHED("FailureThresholdBreached"),

    ROBOT_DEPLOYMENT_ABORTED("RobotDeploymentAborted"),

    ROBOT_DEPLOYMENT_NO_RESPONSE("RobotDeploymentNoResponse"),

    ROBOT_AGENT_CONNECTION_TIMEOUT("RobotAgentConnectionTimeout"),

    GREENGRASS_DEPLOYMENT_FAILED("GreengrassDeploymentFailed"),

    INVALID_GREENGRASS_GROUP("InvalidGreengrassGroup"),

    MISSING_ROBOT_ARCHITECTURE("MissingRobotArchitecture"),

    MISSING_ROBOT_APPLICATION_ARCHITECTURE("MissingRobotApplicationArchitecture"),

    MISSING_ROBOT_DEPLOYMENT_RESOURCE("MissingRobotDeploymentResource"),

    GREENGRASS_GROUP_VERSION_DOES_NOT_EXIST("GreengrassGroupVersionDoesNotExist"),

    LAMBDA_DELETED("LambdaDeleted"),

    EXTRACTING_BUNDLE_FAILURE("ExtractingBundleFailure"),

    PRE_LAUNCH_FILE_FAILURE("PreLaunchFileFailure"),

    POST_LAUNCH_FILE_FAILURE("PostLaunchFileFailure"),

    BAD_PERMISSION_ERROR("BadPermissionError"),

    DOWNLOAD_CONDITION_FAILED("DownloadConditionFailed"),

    BAD_LAMBDA_ASSOCIATED("BadLambdaAssociated"),

    INTERNAL_SERVER_ERROR("InternalServerError"),

    ROBOT_APPLICATION_DOES_NOT_EXIST("RobotApplicationDoesNotExist"),

    DEPLOYMENT_FLEET_DOES_NOT_EXIST("DeploymentFleetDoesNotExist"),

    FLEET_DEPLOYMENT_TIMEOUT("FleetDeploymentTimeout"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentJobErrorCode> VALUE_MAP = EnumUtils.uniqueIndex(DeploymentJobErrorCode.class,
            DeploymentJobErrorCode::toString);

    private final String value;

    private DeploymentJobErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DeploymentJobErrorCode corresponding to the value
     */
    public static DeploymentJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DeploymentJobErrorCode}s
     */
    public static Set<DeploymentJobErrorCode> knownValues() {
        Set<DeploymentJobErrorCode> knownValues = EnumSet.allOf(DeploymentJobErrorCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
