/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorldExportJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeWorldExportJobResponse.Builder, DescribeWorldExportJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeWorldExportJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeWorldExportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeWorldExportJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(DescribeWorldExportJobResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(DescribeWorldExportJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(DescribeWorldExportJobResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<List<String>> WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("worlds")
            .getter(getter(DescribeWorldExportJobResponse::worlds))
            .setter(setter(Builder::worlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).memberName("outputLocation")
            .getter(getter(DescribeWorldExportJobResponse::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRole").getter(getter(DescribeWorldExportJobResponse::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeWorldExportJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, CLIENT_REQUEST_TOKEN_FIELD, WORLDS_FIELD,
            OUTPUT_LOCATION_FIELD, IAM_ROLE_FIELD, TAGS_FIELD));

    private final String arn;

    private final String status;

    private final Instant createdAt;

    private final String failureCode;

    private final String failureReason;

    private final String clientRequestToken;

    private final List<String> worlds;

    private final OutputLocation outputLocation;

    private final String iamRole;

    private final Map<String, String> tags;

    private DescribeWorldExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.clientRequestToken = builder.clientRequestToken;
        this.worlds = builder.worlds;
        this.outputLocation = builder.outputLocation;
        this.iamRole = builder.iamRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the world export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the world export job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
     *         information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public final WorldExportJobStatus status() {
        return WorldExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the world export job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world export job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world export job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world export job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more information.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world export job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world export job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world export job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world export job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world export job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world export job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
     *         information.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world export job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world export job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world export job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world export job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The failure code of the world export job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldExportJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world export job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldExportJobErrorCode
     */
    public final WorldExportJobErrorCode failureCode() {
        return WorldExportJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the world export job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldExportJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world export job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldExportJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The reason why the world export job failed.
     * </p>
     * 
     * @return The reason why the world export job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Worlds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorlds() {
        return worlds != null && !(worlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorlds} method.
     * </p>
     * 
     * @return A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
     */
    public final List<String> worlds() {
        return worlds;
    }

    /**
     * Returns the value of the OutputLocation property for this object.
     * 
     * @return The value of the OutputLocation property for this object.
     */
    public final OutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     * </p>
     * 
     * @return The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the world export job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the world export job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorlds() ? worlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorldExportJobResponse)) {
            return false;
        }
        DescribeWorldExportJobResponse other = (DescribeWorldExportJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasWorlds() == other.hasWorlds()
                && Objects.equals(worlds(), other.worlds()) && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(iamRole(), other.iamRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorldExportJobResponse").add("Arn", arn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("FailureCode", failureCodeAsString()).add("FailureReason", failureReason())
                .add("ClientRequestToken", clientRequestToken()).add("Worlds", hasWorlds() ? worlds() : null)
                .add("OutputLocation", outputLocation()).add("IamRole", iamRole()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "worlds":
            return Optional.ofNullable(clazz.cast(worlds()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorldExportJobResponse, T> g) {
        return obj -> g.apply((DescribeWorldExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorldExportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the world export job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the world export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
         * information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
         *        information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the world export job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world export job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world export job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world export job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
         * information.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world export job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world export job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world export job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world export job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world export job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world export job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world export job failed. See <code>failureCode</code> and <code>failureReason</code> for more
         *        information.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world export job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world export job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobStatus
         */
        Builder status(WorldExportJobStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world export job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The failure code of the world export job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world export job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldExportJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the world export job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world export job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldExportJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldExportJobErrorCode
         */
        Builder failureCode(WorldExportJobErrorCode failureCode);

        /**
         * <p>
         * The reason why the world export job failed.
         * </p>
         * 
         * @param failureReason
         *        The reason why the world export job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
         * </p>
         * 
         * @param worlds
         *        A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(Collection<String> worlds);

        /**
         * <p>
         * A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
         * </p>
         * 
         * @param worlds
         *        A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(String... worlds);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * @param outputLocation
         *        The new value for the OutputLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputLocation.Builder} avoiding the need
         * to create one manually via {@link OutputLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         * </p>
         * 
         * @param iamRole
         *        The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the world export job.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the world export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant createdAt;

        private String failureCode;

        private String failureReason;

        private String clientRequestToken;

        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();

        private OutputLocation outputLocation;

        private String iamRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorldExportJobResponse model) {
            super(model);
            arn(model.arn);
            status(model.status);
            createdAt(model.createdAt);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
            clientRequestToken(model.clientRequestToken);
            worlds(model.worlds);
            outputLocation(model.outputLocation);
            iamRole(model.iamRole);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldExportJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Collection<String> getWorlds() {
            if (worlds instanceof SdkAutoConstructList) {
                return null;
            }
            return worlds;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        @Override
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worlds(String... worlds) {
            worlds(Arrays.asList(worlds));
            return this;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeWorldExportJobResponse build() {
            return new DescribeWorldExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
