/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerBaseClientBuilder;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerClient;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.RoboMakerClientBuilder;
import software.amazon.awssdk.services.robomaker.RoboMakerServiceClientConfiguration;
import software.amazon.awssdk.services.robomaker.endpoints.RoboMakerEndpointProvider;

@SdkInternalApi
final class DefaultRoboMakerClientBuilder
extends DefaultRoboMakerBaseClientBuilder<RoboMakerClientBuilder, RoboMakerClient>
implements RoboMakerClientBuilder {
    DefaultRoboMakerClientBuilder() {
    }

    @Override
    public DefaultRoboMakerClientBuilder endpointProvider(RoboMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RoboMakerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRoboMakerClientBuilder.validateClientOptions(clientConfiguration);
        RoboMakerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRoboMakerClient client = new DefaultRoboMakerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RoboMakerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RoboMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

