/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.robomaker.internal.RoboMakerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.ConcurrentDeploymentException;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateFleetRequest;
import software.amazon.awssdk.services.robomaker.model.CreateFleetResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse;
import software.amazon.awssdk.services.robomaker.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.robomaker.model.InternalServerException;
import software.amazon.awssdk.services.robomaker.model.InvalidParameterException;
import software.amazon.awssdk.services.robomaker.model.LimitExceededException;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.robomaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.RoboMakerException;
import software.amazon.awssdk.services.robomaker.model.ServiceUnavailableException;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.TagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.TagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ThrottlingException;
import software.amazon.awssdk.services.robomaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.transform.BatchDeleteWorldsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.BatchDescribeSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CancelWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.CreateWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeleteWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DeregisterRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeFleetRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldExportJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.DescribeWorldTemplateRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.GetWorldTemplateBodyRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListDeploymentJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListRobotApplicationsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListRobotsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationApplicationsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationJobBatchesRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListSimulationJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldExportJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldGenerationJobsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldTemplatesRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.ListWorldsRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.RegisterRobotRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.RestartSimulationJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.StartSimulationJobBatchRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.SyncDeploymentJobRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateRobotApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateSimulationApplicationRequestMarshaller;
import software.amazon.awssdk.services.robomaker.transform.UpdateWorldTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link RoboMakerAsyncClient}.
 *
 * @see RoboMakerAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoboMakerAsyncClient implements RoboMakerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRoboMakerAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final RoboMakerServiceClientConfiguration serviceClientConfiguration;

    protected DefaultRoboMakerAsyncClient(RoboMakerServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Deletes one or more worlds in a batch operation.
     * </p>
     *
     * @param batchDeleteWorldsRequest
     * @return A Java Future containing the result of the BatchDeleteWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDeleteWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteWorldsResponse> batchDeleteWorlds(BatchDeleteWorldsRequest batchDeleteWorldsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteWorldsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteWorldsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteWorlds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteWorldsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteWorldsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteWorldsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteWorldsRequest, BatchDeleteWorldsResponse>()
                            .withOperationName("BatchDeleteWorlds").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteWorldsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteWorldsRequest));
            CompletableFuture<BatchDeleteWorldsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     * @return A Java Future containing the result of the BatchDescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDescribeSimulationJobResponse> batchDescribeSimulationJob(
            BatchDescribeSimulationJobRequest batchDescribeSimulationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDescribeSimulationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeSimulationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeSimulationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDescribeSimulationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDescribeSimulationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDescribeSimulationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeSimulationJobRequest, BatchDescribeSimulationJobResponse>()
                            .withOperationName("BatchDescribeSimulationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDescribeSimulationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDescribeSimulationJobRequest));
            CompletableFuture<BatchDescribeSimulationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param cancelDeploymentJobRequest
     * @return A Java Future containing the result of the CancelDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelDeploymentJobResponse> cancelDeploymentJob(
            CancelDeploymentJobRequest cancelDeploymentJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDeploymentJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelDeploymentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDeploymentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelDeploymentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelDeploymentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelDeploymentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelDeploymentJobRequest, CancelDeploymentJobResponse>()
                            .withOperationName("CancelDeploymentJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelDeploymentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelDeploymentJobRequest));
            CompletableFuture<CancelDeploymentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     *
     * @param cancelSimulationJobRequest
     * @return A Java Future containing the result of the CancelSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSimulationJobResponse> cancelSimulationJob(
            CancelSimulationJobRequest cancelSimulationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSimulationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSimulationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSimulationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelSimulationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelSimulationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelSimulationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSimulationJobRequest, CancelSimulationJobResponse>()
                            .withOperationName("CancelSimulationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSimulationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSimulationJobRequest));
            CompletableFuture<CancelSimulationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active
     * simulation jobs created as part of the batch.
     * </p>
     *
     * @param cancelSimulationJobBatchRequest
     * @return A Java Future containing the result of the CancelSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSimulationJobBatchResponse> cancelSimulationJobBatch(
            CancelSimulationJobBatchRequest cancelSimulationJobBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSimulationJobBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSimulationJobBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSimulationJobBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelSimulationJobBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelSimulationJobBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelSimulationJobBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSimulationJobBatchRequest, CancelSimulationJobBatchResponse>()
                            .withOperationName("CancelSimulationJobBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSimulationJobBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSimulationJobBatchRequest));
            CompletableFuture<CancelSimulationJobBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified export job.
     * </p>
     *
     * @param cancelWorldExportJobRequest
     * @return A Java Future containing the result of the CancelWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelWorldExportJobResponse> cancelWorldExportJob(
            CancelWorldExportJobRequest cancelWorldExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelWorldExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelWorldExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelWorldExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelWorldExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelWorldExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelWorldExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelWorldExportJobRequest, CancelWorldExportJobResponse>()
                            .withOperationName("CancelWorldExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelWorldExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelWorldExportJobRequest));
            CompletableFuture<CancelWorldExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the specified world generator job.
     * </p>
     *
     * @param cancelWorldGenerationJobRequest
     * @return A Java Future containing the result of the CancelWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelWorldGenerationJobResponse> cancelWorldGenerationJob(
            CancelWorldGenerationJobRequest cancelWorldGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelWorldGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelWorldGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelWorldGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelWorldGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelWorldGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelWorldGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelWorldGenerationJobRequest, CancelWorldGenerationJobResponse>()
                            .withOperationName("CancelWorldGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelWorldGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelWorldGenerationJobRequest));
            CompletableFuture<CancelWorldGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createDeploymentJobRequest
     * @return A Java Future containing the result of the CreateDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentJobResponse> createDeploymentJob(
            CreateDeploymentJobRequest createDeploymentJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeploymentJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeploymentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentJobRequest, CreateDeploymentJobResponse>()
                            .withOperationName("CreateDeploymentJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDeploymentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDeploymentJobRequest));
            CompletableFuture<CreateDeploymentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param createRobotRequest
     * @return A Java Future containing the result of the CreateRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRobotResponse> createRobot(CreateRobotRequest createRobotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRobotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRobotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRobot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRobotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateRobotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRobotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRobotRequest, CreateRobotResponse>()
                            .withOperationName("CreateRobot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRobotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRobotRequest));
            CompletableFuture<CreateRobotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     *
     * @param createRobotApplicationRequest
     * @return A Java Future containing the result of the CreateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRobotApplicationResponse> createRobotApplication(
            CreateRobotApplicationRequest createRobotApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRobotApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRobotApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRobotApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRobotApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRobotApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRobotApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRobotApplicationRequest, CreateRobotApplicationResponse>()
                            .withOperationName("CreateRobotApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRobotApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRobotApplicationRequest));
            CompletableFuture<CreateRobotApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     * @return A Java Future containing the result of the CreateRobotApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRobotApplicationVersionResponse> createRobotApplicationVersion(
            CreateRobotApplicationVersionRequest createRobotApplicationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRobotApplicationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRobotApplicationVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRobotApplicationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRobotApplicationVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRobotApplicationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRobotApplicationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRobotApplicationVersionRequest, CreateRobotApplicationVersionResponse>()
                            .withOperationName("CreateRobotApplicationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRobotApplicationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRobotApplicationVersionRequest));
            CompletableFuture<CreateRobotApplicationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     *
     * @param createSimulationApplicationRequest
     * @return A Java Future containing the result of the CreateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSimulationApplicationResponse> createSimulationApplication(
            CreateSimulationApplicationRequest createSimulationApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSimulationApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSimulationApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSimulationApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSimulationApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSimulationApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSimulationApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSimulationApplicationRequest, CreateSimulationApplicationResponse>()
                            .withOperationName("CreateSimulationApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSimulationApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSimulationApplicationRequest));
            CompletableFuture<CreateSimulationApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     * @return A Java Future containing the result of the CreateSimulationApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSimulationApplicationVersionResponse> createSimulationApplicationVersion(
            CreateSimulationApplicationVersionRequest createSimulationApplicationVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSimulationApplicationVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSimulationApplicationVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSimulationApplicationVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSimulationApplicationVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateSimulationApplicationVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSimulationApplicationVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSimulationApplicationVersionRequest, CreateSimulationApplicationVersionResponse>()
                            .withOperationName("CreateSimulationApplicationVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSimulationApplicationVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSimulationApplicationVersionRequest));
            CompletableFuture<CreateSimulationApplicationVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createSimulationJobRequest
     * @return A Java Future containing the result of the CreateSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSimulationJobResponse> createSimulationJob(
            CreateSimulationJobRequest createSimulationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSimulationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSimulationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSimulationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSimulationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSimulationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSimulationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSimulationJobRequest, CreateSimulationJobResponse>()
                            .withOperationName("CreateSimulationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSimulationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSimulationJobRequest));
            CompletableFuture<CreateSimulationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a world export job.
     * </p>
     *
     * @param createWorldExportJobRequest
     * @return A Java Future containing the result of the CreateWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorldExportJobResponse> createWorldExportJob(
            CreateWorldExportJobRequest createWorldExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorldExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorldExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorldExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorldExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorldExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorldExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorldExportJobRequest, CreateWorldExportJobResponse>()
                            .withOperationName("CreateWorldExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorldExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorldExportJobRequest));
            CompletableFuture<CreateWorldExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates worlds using the specified template.
     * </p>
     *
     * @param createWorldGenerationJobRequest
     * @return A Java Future containing the result of the CreateWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorldGenerationJobResponse> createWorldGenerationJob(
            CreateWorldGenerationJobRequest createWorldGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorldGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorldGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorldGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorldGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorldGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorldGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorldGenerationJobRequest, CreateWorldGenerationJobResponse>()
                            .withOperationName("CreateWorldGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorldGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorldGenerationJobRequest));
            CompletableFuture<CreateWorldGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a world template.
     * </p>
     *
     * @param createWorldTemplateRequest
     * @return A Java Future containing the result of the CreateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorldTemplateResponse> createWorldTemplate(
            CreateWorldTemplateRequest createWorldTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorldTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorldTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorldTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorldTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorldTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateWorldTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorldTemplateRequest, CreateWorldTemplateResponse>()
                            .withOperationName("CreateWorldTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorldTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWorldTemplateRequest));
            CompletableFuture<CreateWorldTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                            .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetRequest));
            CompletableFuture<DeleteFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deleteRobotRequest
     * @return A Java Future containing the result of the DeleteRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRobotResponse> deleteRobot(DeleteRobotRequest deleteRobotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRobotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRobotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRobot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRobotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRobotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRobotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRobotRequest, DeleteRobotResponse>()
                            .withOperationName("DeleteRobot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRobotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRobotRequest));
            CompletableFuture<DeleteRobotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     *
     * @param deleteRobotApplicationRequest
     * @return A Java Future containing the result of the DeleteRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRobotApplicationResponse> deleteRobotApplication(
            DeleteRobotApplicationRequest deleteRobotApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRobotApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRobotApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRobotApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRobotApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRobotApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRobotApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRobotApplicationRequest, DeleteRobotApplicationResponse>()
                            .withOperationName("DeleteRobotApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRobotApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRobotApplicationRequest));
            CompletableFuture<DeleteRobotApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     * @return A Java Future containing the result of the DeleteSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSimulationApplicationResponse> deleteSimulationApplication(
            DeleteSimulationApplicationRequest deleteSimulationApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSimulationApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSimulationApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSimulationApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSimulationApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSimulationApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSimulationApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSimulationApplicationRequest, DeleteSimulationApplicationResponse>()
                            .withOperationName("DeleteSimulationApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSimulationApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSimulationApplicationRequest));
            CompletableFuture<DeleteSimulationApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a world template.
     * </p>
     *
     * @param deleteWorldTemplateRequest
     * @return A Java Future containing the result of the DeleteWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorldTemplateResponse> deleteWorldTemplate(
            DeleteWorldTemplateRequest deleteWorldTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorldTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorldTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorldTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorldTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorldTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteWorldTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorldTemplateRequest, DeleteWorldTemplateResponse>()
                            .withOperationName("DeleteWorldTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorldTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWorldTemplateRequest));
            CompletableFuture<DeleteWorldTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deregisterRobotRequest
     * @return A Java Future containing the result of the DeregisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeregisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterRobotResponse> deregisterRobot(DeregisterRobotRequest deregisterRobotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterRobotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterRobotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterRobot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterRobotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterRobotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterRobotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterRobotRequest, DeregisterRobotResponse>()
                            .withOperationName("DeregisterRobot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterRobotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterRobotRequest));
            CompletableFuture<DeregisterRobotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeDeploymentJobRequest
     * @return A Java Future containing the result of the DescribeDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeploymentJobResponse> describeDeploymentJob(
            DescribeDeploymentJobRequest describeDeploymentJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeploymentJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeploymentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeploymentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeploymentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeploymentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDeploymentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeploymentJobRequest, DescribeDeploymentJobResponse>()
                            .withOperationName("DescribeDeploymentJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDeploymentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDeploymentJobRequest));
            CompletableFuture<DescribeDeploymentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeFleetRequest
     * @return A Java Future containing the result of the DescribeFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetResponse> describeFleet(DescribeFleetRequest describeFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeFleetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetRequest, DescribeFleetResponse>()
                            .withOperationName("DescribeFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetRequest));
            CompletableFuture<DescribeFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeRobotRequest
     * @return A Java Future containing the result of the DescribeRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRobotResponse> describeRobot(DescribeRobotRequest describeRobotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRobotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRobotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRobot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRobotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeRobotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRobotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRobotRequest, DescribeRobotResponse>()
                            .withOperationName("DescribeRobot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRobotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRobotRequest));
            CompletableFuture<DescribeRobotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     *
     * @param describeRobotApplicationRequest
     * @return A Java Future containing the result of the DescribeRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRobotApplicationResponse> describeRobotApplication(
            DescribeRobotApplicationRequest describeRobotApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRobotApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRobotApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRobotApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRobotApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRobotApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRobotApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRobotApplicationRequest, DescribeRobotApplicationResponse>()
                            .withOperationName("DescribeRobotApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRobotApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRobotApplicationRequest));
            CompletableFuture<DescribeRobotApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     *
     * @param describeSimulationApplicationRequest
     * @return A Java Future containing the result of the DescribeSimulationApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSimulationApplicationResponse> describeSimulationApplication(
            DescribeSimulationApplicationRequest describeSimulationApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSimulationApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSimulationApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSimulationApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSimulationApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSimulationApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSimulationApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSimulationApplicationRequest, DescribeSimulationApplicationResponse>()
                            .withOperationName("DescribeSimulationApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSimulationApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSimulationApplicationRequest));
            CompletableFuture<DescribeSimulationApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     *
     * @param describeSimulationJobRequest
     * @return A Java Future containing the result of the DescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSimulationJobResponse> describeSimulationJob(
            DescribeSimulationJobRequest describeSimulationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSimulationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSimulationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSimulationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSimulationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSimulationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSimulationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSimulationJobRequest, DescribeSimulationJobResponse>()
                            .withOperationName("DescribeSimulationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSimulationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSimulationJobRequest));
            CompletableFuture<DescribeSimulationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a simulation job batch.
     * </p>
     *
     * @param describeSimulationJobBatchRequest
     * @return A Java Future containing the result of the DescribeSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSimulationJobBatchResponse> describeSimulationJobBatch(
            DescribeSimulationJobBatchRequest describeSimulationJobBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSimulationJobBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSimulationJobBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSimulationJobBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSimulationJobBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSimulationJobBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSimulationJobBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSimulationJobBatchRequest, DescribeSimulationJobBatchResponse>()
                            .withOperationName("DescribeSimulationJobBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSimulationJobBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSimulationJobBatchRequest));
            CompletableFuture<DescribeSimulationJobBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a world.
     * </p>
     *
     * @param describeWorldRequest
     * @return A Java Future containing the result of the DescribeWorld operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorld
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorldResponse> describeWorld(DescribeWorldRequest describeWorldRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorldRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorld");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorldResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeWorldResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorldResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorldRequest, DescribeWorldResponse>()
                            .withOperationName("DescribeWorld").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorldRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorldRequest));
            CompletableFuture<DescribeWorldResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a world export job.
     * </p>
     *
     * @param describeWorldExportJobRequest
     * @return A Java Future containing the result of the DescribeWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorldExportJobResponse> describeWorldExportJob(
            DescribeWorldExportJobRequest describeWorldExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorldExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorldExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorldExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorldExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorldExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorldExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorldExportJobRequest, DescribeWorldExportJobResponse>()
                            .withOperationName("DescribeWorldExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorldExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorldExportJobRequest));
            CompletableFuture<DescribeWorldExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a world generation job.
     * </p>
     *
     * @param describeWorldGenerationJobRequest
     * @return A Java Future containing the result of the DescribeWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorldGenerationJobResponse> describeWorldGenerationJob(
            DescribeWorldGenerationJobRequest describeWorldGenerationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorldGenerationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorldGenerationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorldGenerationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorldGenerationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorldGenerationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorldGenerationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorldGenerationJobRequest, DescribeWorldGenerationJobResponse>()
                            .withOperationName("DescribeWorldGenerationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorldGenerationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorldGenerationJobRequest));
            CompletableFuture<DescribeWorldGenerationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a world template.
     * </p>
     *
     * @param describeWorldTemplateRequest
     * @return A Java Future containing the result of the DescribeWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeWorldTemplateResponse> describeWorldTemplate(
            DescribeWorldTemplateRequest describeWorldTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorldTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorldTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorldTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeWorldTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeWorldTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeWorldTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeWorldTemplateRequest, DescribeWorldTemplateResponse>()
                            .withOperationName("DescribeWorldTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeWorldTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeWorldTemplateRequest));
            CompletableFuture<DescribeWorldTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the world template body.
     * </p>
     *
     * @param getWorldTemplateBodyRequest
     * @return A Java Future containing the result of the GetWorldTemplateBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.GetWorldTemplateBody
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorldTemplateBodyResponse> getWorldTemplateBody(
            GetWorldTemplateBodyRequest getWorldTemplateBodyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorldTemplateBodyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorldTemplateBodyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorldTemplateBody");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorldTemplateBodyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorldTemplateBodyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetWorldTemplateBodyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorldTemplateBodyRequest, GetWorldTemplateBodyResponse>()
                            .withOperationName("GetWorldTemplateBody").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorldTemplateBodyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getWorldTemplateBodyRequest));
            CompletableFuture<GetWorldTemplateBodyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listDeploymentJobsRequest
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs(ListDeploymentJobsRequest listDeploymentJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDeploymentJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeploymentJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentJobsRequest, ListDeploymentJobsResponse>()
                            .withOperationName("ListDeploymentJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDeploymentJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDeploymentJobsRequest));
            CompletableFuture<ListDeploymentJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFleetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFleetsRequest));
            CompletableFuture<ListFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRobotApplicationsResponse> listRobotApplications(
            ListRobotApplicationsRequest listRobotApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRobotApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRobotApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRobotApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRobotApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRobotApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRobotApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRobotApplicationsRequest, ListRobotApplicationsResponse>()
                            .withOperationName("ListRobotApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRobotApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRobotApplicationsRequest));
            CompletableFuture<ListRobotApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listRobotsRequest
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRobotsResponse> listRobots(ListRobotsRequest listRobotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRobotsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRobotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRobots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRobotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRobotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRobotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRobotsRequest, ListRobotsResponse>().withOperationName("ListRobots")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRobotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRobotsRequest));
            CompletableFuture<ListRobotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSimulationApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSimulationApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSimulationApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSimulationApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSimulationApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSimulationApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSimulationApplicationsRequest, ListSimulationApplicationsResponse>()
                            .withOperationName("ListSimulationApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSimulationApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSimulationApplicationsRequest));
            CompletableFuture<ListSimulationApplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     * @return A Java Future containing the result of the ListSimulationJobBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSimulationJobBatchesResponse> listSimulationJobBatches(
            ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSimulationJobBatchesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSimulationJobBatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSimulationJobBatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSimulationJobBatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSimulationJobBatchesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSimulationJobBatchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSimulationJobBatchesRequest, ListSimulationJobBatchesResponse>()
                            .withOperationName("ListSimulationJobBatches").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSimulationJobBatchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSimulationJobBatchesRequest));
            CompletableFuture<ListSimulationJobBatchesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSimulationJobsResponse> listSimulationJobs(ListSimulationJobsRequest listSimulationJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSimulationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSimulationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSimulationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSimulationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSimulationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSimulationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSimulationJobsRequest, ListSimulationJobsResponse>()
                            .withOperationName("ListSimulationJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSimulationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSimulationJobsRequest));
            CompletableFuture<ListSimulationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     *
     * @param listWorldExportJobsRequest
     * @return A Java Future containing the result of the ListWorldExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorldExportJobsResponse> listWorldExportJobs(
            ListWorldExportJobsRequest listWorldExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorldExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorldExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorldExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorldExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorldExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorldExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorldExportJobsRequest, ListWorldExportJobsResponse>()
                            .withOperationName("ListWorldExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorldExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorldExportJobsRequest));
            CompletableFuture<ListWorldExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     * @return A Java Future containing the result of the ListWorldGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorldGenerationJobsResponse> listWorldGenerationJobs(
            ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorldGenerationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorldGenerationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorldGenerationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorldGenerationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorldGenerationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorldGenerationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorldGenerationJobsRequest, ListWorldGenerationJobsResponse>()
                            .withOperationName("ListWorldGenerationJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorldGenerationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorldGenerationJobsRequest));
            CompletableFuture<ListWorldGenerationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     *
     * @param listWorldTemplatesRequest
     * @return A Java Future containing the result of the ListWorldTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorldTemplatesResponse> listWorldTemplates(ListWorldTemplatesRequest listWorldTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorldTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorldTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorldTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorldTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorldTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorldTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorldTemplatesRequest, ListWorldTemplatesResponse>()
                            .withOperationName("ListWorldTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorldTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorldTemplatesRequest));
            CompletableFuture<ListWorldTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     *
     * @param listWorldsRequest
     * @return A Java Future containing the result of the ListWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorldsResponse> listWorlds(ListWorldsRequest listWorldsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorldsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorldsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorlds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorldsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListWorldsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListWorldsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorldsRequest, ListWorldsResponse>().withOperationName("ListWorlds")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorldsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listWorldsRequest));
            CompletableFuture<ListWorldsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param registerRobotRequest
     * @return A Java Future containing the result of the RegisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RegisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterRobotResponse> registerRobot(RegisterRobotRequest registerRobotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerRobotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerRobotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterRobot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterRobotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RegisterRobotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterRobotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterRobotRequest, RegisterRobotResponse>()
                            .withOperationName("RegisterRobot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterRobotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerRobotRequest));
            CompletableFuture<RegisterRobotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     *
     * @param restartSimulationJobRequest
     * @return A Java Future containing the result of the RestartSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RestartSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestartSimulationJobResponse> restartSimulationJob(
            RestartSimulationJobRequest restartSimulationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartSimulationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartSimulationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartSimulationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestartSimulationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestartSimulationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestartSimulationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestartSimulationJobRequest, RestartSimulationJobResponse>()
                            .withOperationName("RestartSimulationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestartSimulationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restartSimulationJobRequest));
            CompletableFuture<RestartSimulationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code>
     * objects.
     * </p>
     *
     * @param startSimulationJobBatchRequest
     * @return A Java Future containing the result of the StartSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.StartSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSimulationJobBatchResponse> startSimulationJobBatch(
            StartSimulationJobBatchRequest startSimulationJobBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSimulationJobBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSimulationJobBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSimulationJobBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSimulationJobBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSimulationJobBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSimulationJobBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSimulationJobBatchRequest, StartSimulationJobBatchResponse>()
                            .withOperationName("StartSimulationJobBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSimulationJobBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSimulationJobBatchRequest));
            CompletableFuture<StartSimulationJobBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param syncDeploymentJobRequest
     * @return A Java Future containing the result of the SyncDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.SyncDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SyncDeploymentJobResponse> syncDeploymentJob(SyncDeploymentJobRequest syncDeploymentJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(syncDeploymentJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, syncDeploymentJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SyncDeploymentJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SyncDeploymentJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SyncDeploymentJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SyncDeploymentJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SyncDeploymentJobRequest, SyncDeploymentJobResponse>()
                            .withOperationName("SyncDeploymentJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SyncDeploymentJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(syncDeploymentJobRequest));
            CompletableFuture<SyncDeploymentJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     *
     * @param updateRobotApplicationRequest
     * @return A Java Future containing the result of the UpdateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRobotApplicationResponse> updateRobotApplication(
            UpdateRobotApplicationRequest updateRobotApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRobotApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRobotApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRobotApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRobotApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRobotApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRobotApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRobotApplicationRequest, UpdateRobotApplicationResponse>()
                            .withOperationName("UpdateRobotApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRobotApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRobotApplicationRequest));
            CompletableFuture<UpdateRobotApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     *
     * @param updateSimulationApplicationRequest
     * @return A Java Future containing the result of the UpdateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSimulationApplicationResponse> updateSimulationApplication(
            UpdateSimulationApplicationRequest updateSimulationApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSimulationApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSimulationApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSimulationApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSimulationApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSimulationApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSimulationApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSimulationApplicationRequest, UpdateSimulationApplicationResponse>()
                            .withOperationName("UpdateSimulationApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSimulationApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSimulationApplicationRequest));
            CompletableFuture<UpdateSimulationApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a world template.
     * </p>
     *
     * @param updateWorldTemplateRequest
     * @return A Java Future containing the result of the UpdateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorldTemplateResponse> updateWorldTemplate(
            UpdateWorldTemplateRequest updateWorldTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorldTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorldTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "RoboMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorldTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorldTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorldTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateWorldTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorldTemplateRequest, UpdateWorldTemplateResponse>()
                            .withOperationName("UpdateWorldTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorldTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWorldTemplateRequest));
            CompletableFuture<UpdateWorldTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final RoboMakerServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RoboMakerException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentDeploymentException")
                                .exceptionBuilderSupplier(ConcurrentDeploymentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        RoboMakerServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = RoboMakerServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
