/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a world.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldConfig implements SdkPojo, Serializable, ToCopyableBuilder<WorldConfig.Builder, WorldConfig> {
    private static final SdkField<String> WORLD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("world")
            .getter(getter(WorldConfig::world)).setter(setter(Builder::world))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("world").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String world;

    private WorldConfig(BuilderImpl builder) {
        this.world = builder.world;
    }

    /**
     * <p>
     * The world generated by Simulation WorldForge.
     * </p>
     * 
     * @return The world generated by Simulation WorldForge.
     */
    public final String world() {
        return world;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(world());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldConfig)) {
            return false;
        }
        WorldConfig other = (WorldConfig) obj;
        return Objects.equals(world(), other.world());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorldConfig").add("World", world()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "world":
            return Optional.ofNullable(clazz.cast(world()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorldConfig, T> g) {
        return obj -> g.apply((WorldConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldConfig> {
        /**
         * <p>
         * The world generated by Simulation WorldForge.
         * </p>
         * 
         * @param world
         *        The world generated by Simulation WorldForge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder world(String world);
    }

    static final class BuilderImpl implements Builder {
        private String world;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldConfig model) {
            world(model.world);
        }

        public final String getWorld() {
            return world;
        }

        public final void setWorld(String world) {
            this.world = world;
        }

        @Override
        public final Builder world(String world) {
            this.world = world;
            return this;
        }

        @Override
        public WorldConfig build() {
            return new WorldConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
