/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum SimulationJobErrorCode {
    INTERNAL_SERVICE_ERROR("InternalServiceError"),

    ROBOT_APPLICATION_CRASH("RobotApplicationCrash"),

    SIMULATION_APPLICATION_CRASH("SimulationApplicationCrash"),

    ROBOT_APPLICATION_HEALTH_CHECK_FAILURE("RobotApplicationHealthCheckFailure"),

    SIMULATION_APPLICATION_HEALTH_CHECK_FAILURE("SimulationApplicationHealthCheckFailure"),

    BAD_PERMISSIONS_ROBOT_APPLICATION("BadPermissionsRobotApplication"),

    BAD_PERMISSIONS_SIMULATION_APPLICATION("BadPermissionsSimulationApplication"),

    BAD_PERMISSIONS_S3_OBJECT("BadPermissionsS3Object"),

    BAD_PERMISSIONS_S3_OUTPUT("BadPermissionsS3Output"),

    BAD_PERMISSIONS_CLOUDWATCH_LOGS("BadPermissionsCloudwatchLogs"),

    SUBNET_IP_LIMIT_EXCEEDED("SubnetIpLimitExceeded"),

    ENI_LIMIT_EXCEEDED("ENILimitExceeded"),

    BAD_PERMISSIONS_USER_CREDENTIALS("BadPermissionsUserCredentials"),

    INVALID_BUNDLE_ROBOT_APPLICATION("InvalidBundleRobotApplication"),

    INVALID_BUNDLE_SIMULATION_APPLICATION("InvalidBundleSimulationApplication"),

    INVALID_S3_RESOURCE("InvalidS3Resource"),

    THROTTLING_ERROR("ThrottlingError"),

    LIMIT_EXCEEDED("LimitExceeded"),

    MISMATCHED_ETAG("MismatchedEtag"),

    ROBOT_APPLICATION_VERSION_MISMATCHED_ETAG("RobotApplicationVersionMismatchedEtag"),

    SIMULATION_APPLICATION_VERSION_MISMATCHED_ETAG("SimulationApplicationVersionMismatchedEtag"),

    RESOURCE_NOT_FOUND("ResourceNotFound"),

    REQUEST_THROTTLED("RequestThrottled"),

    BATCH_TIMED_OUT("BatchTimedOut"),

    BATCH_CANCELED("BatchCanceled"),

    INVALID_INPUT("InvalidInput"),

    WRONG_REGION_S3_BUCKET("WrongRegionS3Bucket"),

    WRONG_REGION_S3_OUTPUT("WrongRegionS3Output"),

    WRONG_REGION_ROBOT_APPLICATION("WrongRegionRobotApplication"),

    WRONG_REGION_SIMULATION_APPLICATION("WrongRegionSimulationApplication"),

    UPLOAD_CONTENT_MISMATCH_ERROR("UploadContentMismatchError"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SimulationJobErrorCode> VALUE_MAP = EnumUtils.uniqueIndex(SimulationJobErrorCode.class,
            SimulationJobErrorCode::toString);

    private final String value;

    private SimulationJobErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SimulationJobErrorCode corresponding to the value
     */
    public static SimulationJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SimulationJobErrorCode}s
     */
    public static Set<SimulationJobErrorCode> knownValues() {
        Set<SimulationJobErrorCode> knownValues = EnumSet.allOf(SimulationJobErrorCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
