/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a simulation application configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationApplicationConfig.Builder, SimulationApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(SimulationApplicationConfig::application))
            .setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationVersion").getter(getter(SimulationApplicationConfig::applicationVersion))
            .setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.<LaunchConfig> builder(MarshallingType.SDK_POJO)
            .memberName("launchConfig").getter(getter(SimulationApplicationConfig::launchConfig))
            .setter(setter(Builder::launchConfig)).constructor(LaunchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()).build();

    private static final SdkField<List<UploadConfiguration>> UPLOAD_CONFIGURATIONS_FIELD = SdkField
            .<List<UploadConfiguration>> builder(MarshallingType.LIST)
            .memberName("uploadConfigurations")
            .getter(getter(SimulationApplicationConfig::uploadConfigurations))
            .setter(setter(Builder::uploadConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UploadConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(UploadConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorldConfig>> WORLD_CONFIGS_FIELD = SdkField
            .<List<WorldConfig>> builder(MarshallingType.LIST)
            .memberName("worldConfigs")
            .getter(getter(SimulationApplicationConfig::worldConfigs))
            .setter(setter(Builder::worldConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorldConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorldConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDefaultUploadConfigurations")
            .getter(getter(SimulationApplicationConfig::useDefaultUploadConfigurations))
            .setter(setter(Builder::useDefaultUploadConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultUploadConfigurations")
                    .build()).build();

    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField
            .<List<Tool>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(SimulationApplicationConfig::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USE_DEFAULT_TOOLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useDefaultTools").getter(getter(SimulationApplicationConfig::useDefaultTools))
            .setter(setter(Builder::useDefaultTools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultTools").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, UPLOAD_CONFIGURATIONS_FIELD, WORLD_CONFIGS_FIELD,
            USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD, TOOLS_FIELD, USE_DEFAULT_TOOLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String application;

    private final String applicationVersion;

    private final LaunchConfig launchConfig;

    private final List<UploadConfiguration> uploadConfigurations;

    private final List<WorldConfig> worldConfigs;

    private final Boolean useDefaultUploadConfigurations;

    private final List<Tool> tools;

    private final Boolean useDefaultTools;

    private SimulationApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.uploadConfigurations = builder.uploadConfigurations;
        this.worldConfigs = builder.worldConfigs;
        this.useDefaultUploadConfigurations = builder.useDefaultUploadConfigurations;
        this.tools = builder.tools;
        this.useDefaultTools = builder.useDefaultTools;
    }

    /**
     * <p>
     * The application information for the simulation application.
     * </p>
     * 
     * @return The application information for the simulation application.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The version of the simulation application.
     * </p>
     * 
     * @return The version of the simulation application.
     */
    public final String applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The launch configuration for the simulation application.
     * </p>
     * 
     * @return The launch configuration for the simulation application.
     */
    public final LaunchConfig launchConfig() {
        return launchConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the UploadConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUploadConfigurations() {
        return uploadConfigurations != null && !(uploadConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about upload configurations for the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUploadConfigurations} method.
     * </p>
     * 
     * @return Information about upload configurations for the simulation application.
     */
    public final List<UploadConfiguration> uploadConfigurations() {
        return uploadConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorldConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorldConfigs() {
        return worldConfigs != null && !(worldConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of world configurations.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorldConfigs} method.
     * </p>
     * 
     * @return A list of world configurations.</p> <important>
     *         <p>
     *         This API is no longer supported and will throw an error if used.
     *         </p>
     */
    public final List<WorldConfig> worldConfigs() {
        return worldConfigs;
    }

    /**
     * <p>
     * A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
     * <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.
     * </p>
     * <p>
     * If you set this value, you must specify an <code>outputLocation</code>.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * 
     * @return A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
     *         <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be
     *         recorded.</p>
     *         <p>
     *         If you set this value, you must specify an <code>outputLocation</code>.
     *         </p>
     *         <important>
     *         <p>
     *         This API is no longer supported and will throw an error if used.
     *         </p>
     * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
     */
    @Deprecated
    public final Boolean useDefaultUploadConfigurations() {
        return useDefaultUploadConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about tools configured for the simulation application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTools} method.
     * </p>
     * 
     * @return Information about tools configured for the simulation application.
     */
    public final List<Tool> tools() {
        return tools;
    }

    /**
     * <p>
     * A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt,
     * terminal and rosbag record. The default is <code>False</code>.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * 
     * @return A Boolean indicating whether to use default simulation application tools. The default tools are rviz,
     *         rqt, terminal and rosbag record. The default is <code>False</code>.</p> <important>
     *         <p>
     *         This API is no longer supported and will throw an error if used.
     *         </p>
     * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
     */
    @Deprecated
    public final Boolean useDefaultTools() {
        return useDefaultTools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasUploadConfigurations() ? uploadConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorldConfigs() ? worldConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultUploadConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(useDefaultTools());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationConfig)) {
            return false;
        }
        SimulationApplicationConfig other = (SimulationApplicationConfig) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(launchConfig(), other.launchConfig())
                && hasUploadConfigurations() == other.hasUploadConfigurations()
                && Objects.equals(uploadConfigurations(), other.uploadConfigurations())
                && hasWorldConfigs() == other.hasWorldConfigs() && Objects.equals(worldConfigs(), other.worldConfigs())
                && Objects.equals(useDefaultUploadConfigurations(), other.useDefaultUploadConfigurations())
                && hasTools() == other.hasTools() && Objects.equals(tools(), other.tools())
                && Objects.equals(useDefaultTools(), other.useDefaultTools());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimulationApplicationConfig").add("Application", application())
                .add("ApplicationVersion", applicationVersion()).add("LaunchConfig", launchConfig())
                .add("UploadConfigurations", hasUploadConfigurations() ? uploadConfigurations() : null)
                .add("WorldConfigs", hasWorldConfigs() ? worldConfigs() : null)
                .add("UseDefaultUploadConfigurations", useDefaultUploadConfigurations())
                .add("Tools", hasTools() ? tools() : null).add("UseDefaultTools", useDefaultTools()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "launchConfig":
            return Optional.ofNullable(clazz.cast(launchConfig()));
        case "uploadConfigurations":
            return Optional.ofNullable(clazz.cast(uploadConfigurations()));
        case "worldConfigs":
            return Optional.ofNullable(clazz.cast(worldConfigs()));
        case "useDefaultUploadConfigurations":
            return Optional.ofNullable(clazz.cast(useDefaultUploadConfigurations()));
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "useDefaultTools":
            return Optional.ofNullable(clazz.cast(useDefaultTools()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationApplicationConfig, T> g) {
        return obj -> g.apply((SimulationApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationApplicationConfig> {
        /**
         * <p>
         * The application information for the simulation application.
         * </p>
         * 
         * @param application
         *        The application information for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The version of the simulation application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(String applicationVersion);

        /**
         * <p>
         * The launch configuration for the simulation application.
         * </p>
         * 
         * @param launchConfig
         *        The launch configuration for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfig(LaunchConfig launchConfig);

        /**
         * <p>
         * The launch configuration for the simulation application.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchConfig.Builder} avoiding the need
         * to create one manually via {@link LaunchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #launchConfig(LaunchConfig)}.
         * 
         * @param launchConfig
         *        a consumer that will call methods on {@link LaunchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfig(LaunchConfig)
         */
        default Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return launchConfig(LaunchConfig.builder().applyMutation(launchConfig).build());
        }

        /**
         * <p>
         * Information about upload configurations for the simulation application.
         * </p>
         * 
         * @param uploadConfigurations
         *        Information about upload configurations for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations);

        /**
         * <p>
         * Information about upload configurations for the simulation application.
         * </p>
         * 
         * @param uploadConfigurations
         *        Information about upload configurations for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadConfigurations(UploadConfiguration... uploadConfigurations);

        /**
         * <p>
         * Information about upload configurations for the simulation application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.robomaker.model.UploadConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.robomaker.model.UploadConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.robomaker.model.UploadConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #uploadConfigurations(List<UploadConfiguration>)}.
         * 
         * @param uploadConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.robomaker.model.UploadConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadConfigurations(java.util.Collection<UploadConfiguration>)
         */
        Builder uploadConfigurations(Consumer<UploadConfiguration.Builder>... uploadConfigurations);

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important>
         * 
         * @param worldConfigs
         *        A list of world configurations.</p> <important>
         *        <p>
         *        This API is no longer supported and will throw an error if used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldConfigs(Collection<WorldConfig> worldConfigs);

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important>
         * 
         * @param worldConfigs
         *        A list of world configurations.</p> <important>
         *        <p>
         *        This API is no longer supported and will throw an error if used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldConfigs(WorldConfig... worldConfigs);

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.robomaker.model.WorldConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.robomaker.model.WorldConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.robomaker.model.WorldConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #worldConfigs(List<WorldConfig>)}.
         * 
         * @param worldConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.robomaker.model.WorldConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worldConfigs(java.util.Collection<WorldConfig>)
         */
        Builder worldConfigs(Consumer<WorldConfig.Builder>... worldConfigs);

        /**
         * <p>
         * A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
         * <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.
         * </p>
         * <p>
         * If you set this value, you must specify an <code>outputLocation</code>.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important>
         * 
         * @param useDefaultUploadConfigurations
         *        A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and
         *        <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be
         *        recorded.</p>
         *        <p>
         *        If you set this value, you must specify an <code>outputLocation</code>.
         *        </p>
         *        <important>
         *        <p>
         *        This API is no longer supported and will throw an error if used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
         *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
         */
        @Deprecated
        Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations);

        /**
         * <p>
         * Information about tools configured for the simulation application.
         * </p>
         * 
         * @param tools
         *        Information about tools configured for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<Tool> tools);

        /**
         * <p>
         * Information about tools configured for the simulation application.
         * </p>
         * 
         * @param tools
         *        Information about tools configured for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Tool... tools);

        /**
         * <p>
         * Information about tools configured for the simulation application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.robomaker.model.Tool.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.robomaker.model.Tool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.robomaker.model.Tool.Builder#build()} is called immediately and its
         * result is passed to {@link #tools(List<Tool>)}.
         * 
         * @param tools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.robomaker.model.Tool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tools(java.util.Collection<Tool>)
         */
        Builder tools(Consumer<Tool.Builder>... tools);

        /**
         * <p>
         * A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt,
         * terminal and rosbag record. The default is <code>False</code>.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important>
         * 
         * @param useDefaultTools
         *        A Boolean indicating whether to use default simulation application tools. The default tools are rviz,
         *        rqt, terminal and rosbag record. The default is <code>False</code>.</p> <important>
         *        <p>
         *        This API is no longer supported and will throw an error if used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
         *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
         */
        @Deprecated
        Builder useDefaultTools(Boolean useDefaultTools);
    }

    static final class BuilderImpl implements Builder {
        private String application;

        private String applicationVersion;

        private LaunchConfig launchConfig;

        private List<UploadConfiguration> uploadConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<WorldConfig> worldConfigs = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultUploadConfigurations;

        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();

        private Boolean useDefaultTools;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationApplicationConfig model) {
            application(model.application);
            applicationVersion(model.applicationVersion);
            launchConfig(model.launchConfig);
            uploadConfigurations(model.uploadConfigurations);
            worldConfigs(model.worldConfigs);
            useDefaultUploadConfigurations(model.useDefaultUploadConfigurations);
            tools(model.tools);
            useDefaultTools(model.useDefaultTools);
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getApplicationVersion() {
            return applicationVersion;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return launchConfig != null ? launchConfig.toBuilder() : null;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final List<UploadConfiguration.Builder> getUploadConfigurations() {
            List<UploadConfiguration.Builder> result = UploadConfigurationsCopier.copyToBuilder(this.uploadConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUploadConfigurations(Collection<UploadConfiguration.BuilderImpl> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copyFromBuilder(uploadConfigurations);
        }

        @Override
        public final Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copy(uploadConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(UploadConfiguration... uploadConfigurations) {
            uploadConfigurations(Arrays.asList(uploadConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(Consumer<UploadConfiguration.Builder>... uploadConfigurations) {
            uploadConfigurations(Stream.of(uploadConfigurations).map(c -> UploadConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<WorldConfig.Builder> getWorldConfigs() {
            List<WorldConfig.Builder> result = WorldConfigsCopier.copyToBuilder(this.worldConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorldConfigs(Collection<WorldConfig.BuilderImpl> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copyFromBuilder(worldConfigs);
        }

        @Override
        public final Builder worldConfigs(Collection<WorldConfig> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copy(worldConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(WorldConfig... worldConfigs) {
            worldConfigs(Arrays.asList(worldConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(Consumer<WorldConfig.Builder>... worldConfigs) {
            worldConfigs(Stream.of(worldConfigs).map(c -> WorldConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getUseDefaultUploadConfigurations() {
            return useDefaultUploadConfigurations;
        }

        @Deprecated
        public final void setUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
        }

        @Override
        @Deprecated
        public final Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
            return this;
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolsCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolsCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolsCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder>... tools) {
            tools(Stream.of(tools).map(c -> Tool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getUseDefaultTools() {
            return useDefaultTools;
        }

        @Deprecated
        public final void setUseDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
        }

        @Override
        @Deprecated
        public final Builder useDefaultTools(Boolean useDefaultTools) {
            this.useDefaultTools = useDefaultTools;
            return this;
        }

        @Override
        public SimulationApplicationConfig build() {
            return new SimulationApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
