/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterRobotRequest extends RoboMakerRequest implements
        ToCopyableBuilder<RegisterRobotRequest.Builder, RegisterRobotRequest> {
    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(RegisterRobotRequest::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<String> ROBOT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("robot")
            .getter(getter(RegisterRobotRequest::robot)).setter(setter(Builder::robot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_FIELD, ROBOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleet;

    private final String robot;

    private RegisterRobotRequest(BuilderImpl builder) {
        super(builder);
        this.fleet = builder.fleet;
        this.robot = builder.robot;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public final String fleet() {
        return fleet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot.
     */
    public final String robot() {
        return robot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(robot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterRobotRequest)) {
            return false;
        }
        RegisterRobotRequest other = (RegisterRobotRequest) obj;
        return Objects.equals(fleet(), other.fleet()) && Objects.equals(robot(), other.robot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterRobotRequest").add("Fleet", fleet()).add("Robot", robot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "robot":
            return Optional.ofNullable(clazz.cast(robot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fleet", FLEET_FIELD);
        map.put("robot", ROBOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterRobotRequest, T> g) {
        return obj -> g.apply((RegisterRobotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterRobotRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleet
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot.
         * </p>
         * 
         * @param robot
         *        The Amazon Resource Name (ARN) of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robot(String robot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String fleet;

        private String robot;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterRobotRequest model) {
            super(model);
            fleet(model.fleet);
            robot(model.robot);
        }

        public final String getFleet() {
            return fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final String getRobot() {
            return robot;
        }

        public final void setRobot(String robot) {
            this.robot = robot;
        }

        @Override
        public final Builder robot(String robot) {
            this.robot = robot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterRobotRequest build() {
            return new RegisterRobotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
