/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides upload configuration information. Files are uploaded from the simulation job to a location you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UploadConfiguration.Builder, UploadConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UploadConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(UploadConfiguration::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> UPLOAD_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadBehavior").getter(getter(UploadConfiguration::uploadBehaviorAsString))
            .setter(setter(Builder::uploadBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD,
            UPLOAD_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String path;

    private final String uploadBehavior;

    private UploadConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.uploadBehavior = builder.uploadBehavior;
    }

    /**
     * <p>
     * A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output
     * location to determine the final path.
     * </p>
     * <p>
     * For example, if your simulation output location is <code>s3://amzn-s3-demo-bucket</code> and your upload
     * configuration name is <code>robot-test</code>, your files will be uploaded to
     * <code>s3://amzn-s3-demo-bucket/&lt;simid&gt;/&lt;runid&gt;/robot-test</code>.
     * </p>
     * 
     * @return A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation
     *         output location to determine the final path. </p>
     *         <p>
     *         For example, if your simulation output location is <code>s3://amzn-s3-demo-bucket</code> and your upload
     *         configuration name is <code>robot-test</code>, your files will be uploaded to
     *         <code>s3://amzn-s3-demo-bucket/&lt;simid&gt;/&lt;runid&gt;/robot-test</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of
     * <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code> causes all .log
     * files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a
     * href="https://github.com/gobwas/glob">Glob Library</a>.
     * </p>
     * 
     * @return Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the
     *         addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying
     *         <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be
     *         collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * Specifies when to upload the files:
     * </p>
     * <dl>
     * <dt>UPLOAD_ON_TERMINATE</dt>
     * <dd>
     * <p>
     * Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not
     * uploaded until all of your code (including tools) have stopped.
     * </p>
     * <p>
     * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts
     * will be made.
     * </p>
     * </dd>
     * <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
     * <dd>
     * <p>
     * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is
     * checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadBehavior}
     * will return {@link UploadBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploadBehaviorAsString}.
     * </p>
     * 
     * @return Specifies when to upload the files:</p>
     *         <dl>
     *         <dt>UPLOAD_ON_TERMINATE</dt>
     *         <dd>
     *         <p>
     *         Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files
     *         are not uploaded until all of your code (including tools) have stopped.
     *         </p>
     *         <p>
     *         If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
     *         attempts will be made.
     *         </p>
     *         </dd>
     *         <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
     *         <dd>
     *         <p>
     *         Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified
     *         path is checked every 5 seconds. A final check is made when all of your code (including tools) have
     *         stopped.
     *         </p>
     *         </dd>
     * @see UploadBehavior
     */
    public final UploadBehavior uploadBehavior() {
        return UploadBehavior.fromValue(uploadBehavior);
    }

    /**
     * <p>
     * Specifies when to upload the files:
     * </p>
     * <dl>
     * <dt>UPLOAD_ON_TERMINATE</dt>
     * <dd>
     * <p>
     * Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not
     * uploaded until all of your code (including tools) have stopped.
     * </p>
     * <p>
     * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts
     * will be made.
     * </p>
     * </dd>
     * <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
     * <dd>
     * <p>
     * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is
     * checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadBehavior}
     * will return {@link UploadBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #uploadBehaviorAsString}.
     * </p>
     * 
     * @return Specifies when to upload the files:</p>
     *         <dl>
     *         <dt>UPLOAD_ON_TERMINATE</dt>
     *         <dd>
     *         <p>
     *         Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files
     *         are not uploaded until all of your code (including tools) have stopped.
     *         </p>
     *         <p>
     *         If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
     *         attempts will be made.
     *         </p>
     *         </dd>
     *         <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
     *         <dd>
     *         <p>
     *         Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified
     *         path is checked every 5 seconds. A final check is made when all of your code (including tools) have
     *         stopped.
     *         </p>
     *         </dd>
     * @see UploadBehavior
     */
    public final String uploadBehaviorAsString() {
        return uploadBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(uploadBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadConfiguration)) {
            return false;
        }
        UploadConfiguration other = (UploadConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(path(), other.path())
                && Objects.equals(uploadBehaviorAsString(), other.uploadBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadConfiguration").add("Name", name()).add("Path", path())
                .add("UploadBehavior", uploadBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "uploadBehavior":
            return Optional.ofNullable(clazz.cast(uploadBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("path", PATH_FIELD);
        map.put("uploadBehavior", UPLOAD_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadConfiguration, T> g) {
        return obj -> g.apply((UploadConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UploadConfiguration> {
        /**
         * <p>
         * A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output
         * location to determine the final path.
         * </p>
         * <p>
         * For example, if your simulation output location is <code>s3://amzn-s3-demo-bucket</code> and your upload
         * configuration name is <code>robot-test</code>, your files will be uploaded to
         * <code>s3://amzn-s3-demo-bucket/&lt;simid&gt;/&lt;runid&gt;/robot-test</code>.
         * </p>
         * 
         * @param name
         *        A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation
         *        output location to determine the final path. </p>
         *        <p>
         *        For example, if your simulation output location is <code>s3://amzn-s3-demo-bucket</code> and your
         *        upload configuration name is <code>robot-test</code>, your files will be uploaded to
         *        <code>s3://amzn-s3-demo-bucket/&lt;simid&gt;/&lt;runid&gt;/robot-test</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the
         * addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code>
         * causes all .log files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a
         * href="https://github.com/gobwas/glob">Glob Library</a>.
         * </p>
         * 
         * @param path
         *        Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the
         *        addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying
         *        <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be
         *        collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Specifies when to upload the files:
         * </p>
         * <dl>
         * <dt>UPLOAD_ON_TERMINATE</dt>
         * <dd>
         * <p>
         * Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are
         * not uploaded until all of your code (including tools) have stopped.
         * </p>
         * <p>
         * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
         * attempts will be made.
         * </p>
         * </dd>
         * <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
         * <dd>
         * <p>
         * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path
         * is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param uploadBehavior
         *        Specifies when to upload the files:</p>
         *        <dl>
         *        <dt>UPLOAD_ON_TERMINATE</dt>
         *        <dd>
         *        <p>
         *        Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching
         *        files are not uploaded until all of your code (including tools) have stopped.
         *        </p>
         *        <p>
         *        If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
         *        attempts will be made.
         *        </p>
         *        </dd>
         *        <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
         *        <dd>
         *        <p>
         *        Matching files are uploaded as they are created. They are deleted after they are uploaded. The
         *        specified path is checked every 5 seconds. A final check is made when all of your code (including
         *        tools) have stopped.
         *        </p>
         *        </dd>
         * @see UploadBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadBehavior
         */
        Builder uploadBehavior(String uploadBehavior);

        /**
         * <p>
         * Specifies when to upload the files:
         * </p>
         * <dl>
         * <dt>UPLOAD_ON_TERMINATE</dt>
         * <dd>
         * <p>
         * Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are
         * not uploaded until all of your code (including tools) have stopped.
         * </p>
         * <p>
         * If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
         * attempts will be made.
         * </p>
         * </dd>
         * <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
         * <dd>
         * <p>
         * Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path
         * is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param uploadBehavior
         *        Specifies when to upload the files:</p>
         *        <dl>
         *        <dt>UPLOAD_ON_TERMINATE</dt>
         *        <dd>
         *        <p>
         *        Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching
         *        files are not uploaded until all of your code (including tools) have stopped.
         *        </p>
         *        <p>
         *        If there is a problem uploading a file, the upload is retried. If problems persist, no further upload
         *        attempts will be made.
         *        </p>
         *        </dd>
         *        <dt>UPLOAD_ROLLING_AUTO_REMOVE</dt>
         *        <dd>
         *        <p>
         *        Matching files are uploaded as they are created. They are deleted after they are uploaded. The
         *        specified path is checked every 5 seconds. A final check is made when all of your code (including
         *        tools) have stopped.
         *        </p>
         *        </dd>
         * @see UploadBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadBehavior
         */
        Builder uploadBehavior(UploadBehavior uploadBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String path;

        private String uploadBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadConfiguration model) {
            name(model.name);
            path(model.path);
            uploadBehavior(model.uploadBehavior);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getUploadBehavior() {
            return uploadBehavior;
        }

        public final void setUploadBehavior(String uploadBehavior) {
            this.uploadBehavior = uploadBehavior;
        }

        @Override
        public final Builder uploadBehavior(String uploadBehavior) {
            this.uploadBehavior = uploadBehavior;
            return this;
        }

        @Override
        public final Builder uploadBehavior(UploadBehavior uploadBehavior) {
            this.uploadBehavior(uploadBehavior == null ? null : uploadBehavior.toString());
            return this;
        }

        @Override
        public UploadConfiguration build() {
            return new UploadConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
