/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the batch policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPolicy implements SdkPojo, Serializable, ToCopyableBuilder<BatchPolicy.Builder, BatchPolicy> {
    private static final SdkField<Long> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeoutInSeconds").getter(getter(BatchPolicy::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrency").getter(getter(BatchPolicy::maxConcurrency)).setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD,
            MAX_CONCURRENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long timeoutInSeconds;

    private final Integer maxConcurrency;

    private BatchPolicy(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.maxConcurrency = builder.maxConcurrency;
    }

    /**
     * <p>
     * The amount of time, in seconds, to wait for the batch to complete.
     * </p>
     * <p>
     * If a batch times out, and there are pending requests that were failing due to an internal failure (like
     * <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be
     * <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will
     * be moved to the failed list and the batch status will be <code>TimedOut</code>.
     * </p>
     * 
     * @return The amount of time, in seconds, to wait for the batch to complete. </p>
     *         <p>
     *         If a batch times out, and there are pending requests that were failing due to an internal failure (like
     *         <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be
     *         <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending
     *         requests will be moved to the failed list and the batch status will be <code>TimedOut</code>.
     */
    public final Long timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The number of active simulation jobs create as part of the batch that can be in an active state at the same time.
     * </p>
     * <p>
     * Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states.
     * </p>
     * 
     * @return The number of active simulation jobs create as part of the batch that can be in an active state at the
     *         same time. </p>
     *         <p>
     *         Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>,
     *         <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are
     *         terminal states.
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPolicy)) {
            return false;
        }
        BatchPolicy other = (BatchPolicy) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(maxConcurrency(), other.maxConcurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPolicy").add("TimeoutInSeconds", timeoutInSeconds())
                .add("MaxConcurrency", maxConcurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "maxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("maxConcurrency", MAX_CONCURRENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPolicy, T> g) {
        return obj -> g.apply((BatchPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchPolicy> {
        /**
         * <p>
         * The amount of time, in seconds, to wait for the batch to complete.
         * </p>
         * <p>
         * If a batch times out, and there are pending requests that were failing due to an internal failure (like
         * <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be
         * <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests
         * will be moved to the failed list and the batch status will be <code>TimedOut</code>.
         * </p>
         * 
         * @param timeoutInSeconds
         *        The amount of time, in seconds, to wait for the batch to complete. </p>
         *        <p>
         *        If a batch times out, and there are pending requests that were failing due to an internal failure
         *        (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status
         *        will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed
         *        pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Long timeoutInSeconds);

        /**
         * <p>
         * The number of active simulation jobs create as part of the batch that can be in an active state at the same
         * time.
         * </p>
         * <p>
         * Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>,
         * <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are
         * terminal states.
         * </p>
         * 
         * @param maxConcurrency
         *        The number of active simulation jobs create as part of the batch that can be in an active state at the
         *        same time. </p>
         *        <p>
         *        Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>,
         *        <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are
         *        terminal states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);
    }

    static final class BuilderImpl implements Builder {
        private Long timeoutInSeconds;

        private Integer maxConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPolicy model) {
            timeoutInSeconds(model.timeoutInSeconds);
            maxConcurrency(model.maxConcurrency);
        }

        public final Long getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Long timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public BatchPolicy build() {
            return new BatchPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
