/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorldResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeWorldResponse.Builder, DescribeWorldResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeWorldResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> GENERATION_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationJob").getter(getter(DescribeWorldResponse::generationJob))
            .setter(setter(Builder::generationJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationJob").build()).build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(DescribeWorldResponse::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeWorldResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeWorldResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORLD_DESCRIPTION_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("worldDescriptionBody").getter(getter(DescribeWorldResponse::worldDescriptionBody))
            .setter(setter(Builder::worldDescriptionBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldDescriptionBody").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            GENERATION_JOB_FIELD, TEMPLATE_FIELD, CREATED_AT_FIELD, TAGS_FIELD, WORLD_DESCRIPTION_BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String generationJob;

    private final String template;

    private final Instant createdAt;

    private final Map<String, String> tags;

    private final String worldDescriptionBody;

    private DescribeWorldResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.generationJob = builder.generationJob;
        this.template = builder.template;
        this.createdAt = builder.createdAt;
        this.tags = builder.tags;
        this.worldDescriptionBody = builder.worldDescriptionBody;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world generation job that generated the world.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world generation job that generated the world.
     */
    public final String generationJob() {
        return generationJob;
    }

    /**
     * <p>
     * The world template.
     * </p>
     * 
     * @return The world template.
     */
    public final String template() {
        return template;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the world.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the world.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Returns the JSON formatted string that describes the contents of your world.
     * </p>
     * 
     * @return Returns the JSON formatted string that describes the contents of your world.
     */
    public final String worldDescriptionBody() {
        return worldDescriptionBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(generationJob());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(worldDescriptionBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorldResponse)) {
            return false;
        }
        DescribeWorldResponse other = (DescribeWorldResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(generationJob(), other.generationJob())
                && Objects.equals(template(), other.template()) && Objects.equals(createdAt(), other.createdAt())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(worldDescriptionBody(), other.worldDescriptionBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorldResponse").add("Arn", arn()).add("GenerationJob", generationJob())
                .add("Template", template()).add("CreatedAt", createdAt()).add("Tags", hasTags() ? tags() : null)
                .add("WorldDescriptionBody", worldDescriptionBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "generationJob":
            return Optional.ofNullable(clazz.cast(generationJob()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "worldDescriptionBody":
            return Optional.ofNullable(clazz.cast(worldDescriptionBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("generationJob", GENERATION_JOB_FIELD);
        map.put("template", TEMPLATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("worldDescriptionBody", WORLD_DESCRIPTION_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorldResponse, T> g) {
        return obj -> g.apply((DescribeWorldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorldResponse> {
        /**
         * <p>
         * The Amazon Resource Name (arn) of the world.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (arn) of the world.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (arn) of the world generation job that generated the world.
         * </p>
         * 
         * @param generationJob
         *        The Amazon Resource Name (arn) of the world generation job that generated the world.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationJob(String generationJob);

        /**
         * <p>
         * The world template.
         * </p>
         * 
         * @param template
         *        The world template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the world.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the world.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Returns the JSON formatted string that describes the contents of your world.
         * </p>
         * 
         * @param worldDescriptionBody
         *        Returns the JSON formatted string that describes the contents of your world.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldDescriptionBody(String worldDescriptionBody);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String generationJob;

        private String template;

        private Instant createdAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String worldDescriptionBody;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorldResponse model) {
            super(model);
            arn(model.arn);
            generationJob(model.generationJob);
            template(model.template);
            createdAt(model.createdAt);
            tags(model.tags);
            worldDescriptionBody(model.worldDescriptionBody);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getGenerationJob() {
            return generationJob;
        }

        public final void setGenerationJob(String generationJob) {
            this.generationJob = generationJob;
        }

        @Override
        public final Builder generationJob(String generationJob) {
            this.generationJob = generationJob;
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorldDescriptionBody() {
            return worldDescriptionBody;
        }

        public final void setWorldDescriptionBody(String worldDescriptionBody) {
            this.worldDescriptionBody = worldDescriptionBody;
        }

        @Override
        public final Builder worldDescriptionBody(String worldDescriptionBody) {
            this.worldDescriptionBody = worldDescriptionBody;
            return this;
        }

        @Override
        public DescribeWorldResponse build() {
            return new DescribeWorldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
