/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a launch configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchConfig implements SdkPojo, Serializable, ToCopyableBuilder<LaunchConfig.Builder, LaunchConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(LaunchConfig::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> LAUNCH_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchFile").getter(getter(LaunchConfig::launchFile)).setter(setter(Builder::launchFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchFile").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(LaunchConfig::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PortForwardingConfig> PORT_FORWARDING_CONFIG_FIELD = SdkField
            .<PortForwardingConfig> builder(MarshallingType.SDK_POJO).memberName("portForwardingConfig")
            .getter(getter(LaunchConfig::portForwardingConfig)).setter(setter(Builder::portForwardingConfig))
            .constructor(PortForwardingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portForwardingConfig").build())
            .build();

    private static final SdkField<Boolean> STREAM_UI_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("streamUI").getter(getter(LaunchConfig::streamUI)).setter(setter(Builder::streamUI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUI").build()).build();

    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("command")
            .getter(getter(LaunchConfig::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            LAUNCH_FILE_FIELD, ENVIRONMENT_VARIABLES_FIELD, PORT_FORWARDING_CONFIG_FIELD, STREAM_UI_FIELD, COMMAND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String packageName;

    private final String launchFile;

    private final Map<String, String> environmentVariables;

    private final PortForwardingConfig portForwardingConfig;

    private final Boolean streamUI;

    private final List<String> command;

    private LaunchConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.launchFile = builder.launchFile;
        this.environmentVariables = builder.environmentVariables;
        this.portForwardingConfig = builder.portForwardingConfig;
        this.streamUI = builder.streamUI;
        this.command = builder.command;
    }

    /**
     * <p>
     * The package name.
     * </p>
     * 
     * @return The package name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The launch file name.
     * </p>
     * 
     * @return The launch file name.
     */
    public final String launchFile() {
        return launchFile;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables for the application launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables for the application launch.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The port forwarding configuration.
     * </p>
     * 
     * @return The port forwarding configuration.
     */
    public final PortForwardingConfig portForwardingConfig() {
        return portForwardingConfig;
    }

    /**
     * <p>
     * Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS
     * RoboMaker will configure a connection so you can interact with your application as it is running in the
     * simulation. You must configure and launch the component. It must have a graphical user interface.
     * </p>
     * 
     * @return Boolean indicating whether a streaming session will be configured for the application. If
     *         <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as
     *         it is running in the simulation. You must configure and launch the component. It must have a graphical
     *         user interface.
     */
    public final Boolean streamUI() {
        return streamUI;
    }

    /**
     * For responses, this returns true if the service returned a value for the Command property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use this
     * field to specify a list of commands for your container image.
     * </p>
     * <p>
     * If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>,
     * you can use this field to specify a list of commands for your container image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommand} method.
     * </p>
     * 
     * @return If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can
     *         use this field to specify a list of commands for your container image.</p>
     *         <p>
     *         If you've specified <code>SimulationRuntime</code> as the value for your
     *         <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your
     *         container image.
     */
    public final List<String> command() {
        return command;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(launchFile());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(portForwardingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(streamUI());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfig)) {
            return false;
        }
        LaunchConfig other = (LaunchConfig) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(launchFile(), other.launchFile())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(portForwardingConfig(), other.portForwardingConfig())
                && Objects.equals(streamUI(), other.streamUI()) && hasCommand() == other.hasCommand()
                && Objects.equals(command(), other.command());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchConfig").add("PackageName", packageName()).add("LaunchFile", launchFile())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("PortForwardingConfig", portForwardingConfig()).add("StreamUI", streamUI())
                .add("Command", hasCommand() ? command() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "launchFile":
            return Optional.ofNullable(clazz.cast(launchFile()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "portForwardingConfig":
            return Optional.ofNullable(clazz.cast(portForwardingConfig()));
        case "streamUI":
            return Optional.ofNullable(clazz.cast(streamUI()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("launchFile", LAUNCH_FILE_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("portForwardingConfig", PORT_FORWARDING_CONFIG_FIELD);
        map.put("streamUI", STREAM_UI_FIELD);
        map.put("command", COMMAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfig, T> g) {
        return obj -> g.apply((LaunchConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchConfig> {
        /**
         * <p>
         * The package name.
         * </p>
         * 
         * @param packageName
         *        The package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The launch file name.
         * </p>
         * 
         * @param launchFile
         *        The launch file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchFile(String launchFile);

        /**
         * <p>
         * The environment variables for the application launch.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables for the application launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The port forwarding configuration.
         * </p>
         * 
         * @param portForwardingConfig
         *        The port forwarding configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portForwardingConfig(PortForwardingConfig portForwardingConfig);

        /**
         * <p>
         * The port forwarding configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortForwardingConfig.Builder} avoiding
         * the need to create one manually via {@link PortForwardingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortForwardingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #portForwardingConfig(PortForwardingConfig)}.
         * 
         * @param portForwardingConfig
         *        a consumer that will call methods on {@link PortForwardingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portForwardingConfig(PortForwardingConfig)
         */
        default Builder portForwardingConfig(Consumer<PortForwardingConfig.Builder> portForwardingConfig) {
            return portForwardingConfig(PortForwardingConfig.builder().applyMutation(portForwardingConfig).build());
        }

        /**
         * <p>
         * Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>,
         * AWS RoboMaker will configure a connection so you can interact with your application as it is running in the
         * simulation. You must configure and launch the component. It must have a graphical user interface.
         * </p>
         * 
         * @param streamUI
         *        Boolean indicating whether a streaming session will be configured for the application. If
         *        <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application
         *        as it is running in the simulation. You must configure and launch the component. It must have a
         *        graphical user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamUI(Boolean streamUI);

        /**
         * <p>
         * If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use
         * this field to specify a list of commands for your container image.
         * </p>
         * <p>
         * If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>
         * , you can use this field to specify a list of commands for your container image.
         * </p>
         * 
         * @param command
         *        If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you
         *        can use this field to specify a list of commands for your container image.</p>
         *        <p>
         *        If you've specified <code>SimulationRuntime</code> as the value for your
         *        <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your
         *        container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use
         * this field to specify a list of commands for your container image.
         * </p>
         * <p>
         * If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>
         * , you can use this field to specify a list of commands for your container image.
         * </p>
         * 
         * @param command
         *        If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you
         *        can use this field to specify a list of commands for your container image.</p>
         *        <p>
         *        If you've specified <code>SimulationRuntime</code> as the value for your
         *        <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your
         *        container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);
    }

    static final class BuilderImpl implements Builder {
        private String packageName;

        private String launchFile;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private PortForwardingConfig portForwardingConfig;

        private Boolean streamUI;

        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfig model) {
            packageName(model.packageName);
            launchFile(model.launchFile);
            environmentVariables(model.environmentVariables);
            portForwardingConfig(model.portForwardingConfig);
            streamUI(model.streamUI);
            command(model.command);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getLaunchFile() {
            return launchFile;
        }

        public final void setLaunchFile(String launchFile) {
            this.launchFile = launchFile;
        }

        @Override
        public final Builder launchFile(String launchFile) {
            this.launchFile = launchFile;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
            return this;
        }

        public final PortForwardingConfig.Builder getPortForwardingConfig() {
            return portForwardingConfig != null ? portForwardingConfig.toBuilder() : null;
        }

        public final void setPortForwardingConfig(PortForwardingConfig.BuilderImpl portForwardingConfig) {
            this.portForwardingConfig = portForwardingConfig != null ? portForwardingConfig.build() : null;
        }

        @Override
        public final Builder portForwardingConfig(PortForwardingConfig portForwardingConfig) {
            this.portForwardingConfig = portForwardingConfig;
            return this;
        }

        public final Boolean getStreamUI() {
            return streamUI;
        }

        public final void setStreamUI(Boolean streamUI) {
            this.streamUI = streamUI;
        }

        @Override
        public final Builder streamUI(Boolean streamUI) {
            this.streamUI = streamUI;
            return this;
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = CommandListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = CommandListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        @Override
        public LaunchConfig build() {
            return new LaunchConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
