/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfig implements SdkPojo, Serializable, ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private static final SdkField<Boolean> RECORD_ALL_ROS_TOPICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("recordAllRosTopics").getter(getter(LoggingConfig::recordAllRosTopics))
            .setter(setter(Builder::recordAllRosTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordAllRosTopics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ALL_ROS_TOPICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean recordAllRosTopics;

    private LoggingConfig(BuilderImpl builder) {
        this.recordAllRosTopics = builder.recordAllRosTopics;
    }

    /**
     * <p>
     * A boolean indicating whether to record all ROS topics.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * 
     * @return A boolean indicating whether to record all ROS topics.</p> <important>
     *         <p>
     *         This API is no longer supported and will throw an error if used.
     *         </p>
     * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
     */
    @Deprecated
    public final Boolean recordAllRosTopics() {
        return recordAllRosTopics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordAllRosTopics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(recordAllRosTopics(), other.recordAllRosTopics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfig").add("RecordAllRosTopics", recordAllRosTopics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordAllRosTopics":
            return Optional.ofNullable(clazz.cast(recordAllRosTopics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recordAllRosTopics", RECORD_ALL_ROS_TOPICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * A boolean indicating whether to record all ROS topics.
         * </p>
         * <important>
         * <p>
         * This API is no longer supported and will throw an error if used.
         * </p>
         * </important>
         * 
         * @param recordAllRosTopics
         *        A boolean indicating whether to record all ROS topics.</p> <important>
         *        <p>
         *        This API is no longer supported and will throw an error if used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated AWS RoboMaker is ending support for ROS software suite. For additional information, see
         *             https://docs.aws.amazon.com/robomaker/latest/dg/software-support-policy.html.
         */
        @Deprecated
        Builder recordAllRosTopics(Boolean recordAllRosTopics);
    }

    static final class BuilderImpl implements Builder {
        private Boolean recordAllRosTopics;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            recordAllRosTopics(model.recordAllRosTopics);
        }

        @Deprecated
        public final Boolean getRecordAllRosTopics() {
            return recordAllRosTopics;
        }

        @Deprecated
        public final void setRecordAllRosTopics(Boolean recordAllRosTopics) {
            this.recordAllRosTopics = recordAllRosTopics;
        }

        @Override
        @Deprecated
        public final Builder recordAllRosTopics(Boolean recordAllRosTopics) {
            this.recordAllRosTopics = recordAllRosTopics;
            return this;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
