/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a port mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortMapping implements SdkPojo, Serializable, ToCopyableBuilder<PortMapping.Builder, PortMapping> {
    private static final SdkField<Integer> JOB_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("jobPort").getter(getter(PortMapping::jobPort)).setter(setter(Builder::jobPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobPort").build()).build();

    private static final SdkField<Integer> APPLICATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applicationPort").getter(getter(PortMapping::applicationPort)).setter(setter(Builder::applicationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationPort").build()).build();

    private static final SdkField<Boolean> ENABLE_ON_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableOnPublicIp").getter(getter(PortMapping::enableOnPublicIp))
            .setter(setter(Builder::enableOnPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableOnPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_PORT_FIELD,
            APPLICATION_PORT_FIELD, ENABLE_ON_PUBLIC_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer jobPort;

    private final Integer applicationPort;

    private final Boolean enableOnPublicIp;

    private PortMapping(BuilderImpl builder) {
        this.jobPort = builder.jobPort;
        this.applicationPort = builder.applicationPort;
        this.enableOnPublicIp = builder.enableOnPublicIp;
    }

    /**
     * <p>
     * The port number on the simulation job instance to use as a remote connection point.
     * </p>
     * 
     * @return The port number on the simulation job instance to use as a remote connection point.
     */
    public final Integer jobPort() {
        return jobPort;
    }

    /**
     * <p>
     * The port number on the application.
     * </p>
     * 
     * @return The port number on the application.
     */
    public final Integer applicationPort() {
        return applicationPort;
    }

    /**
     * <p>
     * A Boolean indicating whether to enable this port mapping on public IP.
     * </p>
     * 
     * @return A Boolean indicating whether to enable this port mapping on public IP.
     */
    public final Boolean enableOnPublicIp() {
        return enableOnPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobPort());
        hashCode = 31 * hashCode + Objects.hashCode(applicationPort());
        hashCode = 31 * hashCode + Objects.hashCode(enableOnPublicIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping) obj;
        return Objects.equals(jobPort(), other.jobPort()) && Objects.equals(applicationPort(), other.applicationPort())
                && Objects.equals(enableOnPublicIp(), other.enableOnPublicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortMapping").add("JobPort", jobPort()).add("ApplicationPort", applicationPort())
                .add("EnableOnPublicIp", enableOnPublicIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobPort":
            return Optional.ofNullable(clazz.cast(jobPort()));
        case "applicationPort":
            return Optional.ofNullable(clazz.cast(applicationPort()));
        case "enableOnPublicIp":
            return Optional.ofNullable(clazz.cast(enableOnPublicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobPort", JOB_PORT_FIELD);
        map.put("applicationPort", APPLICATION_PORT_FIELD);
        map.put("enableOnPublicIp", ENABLE_ON_PUBLIC_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortMapping, T> g) {
        return obj -> g.apply((PortMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortMapping> {
        /**
         * <p>
         * The port number on the simulation job instance to use as a remote connection point.
         * </p>
         * 
         * @param jobPort
         *        The port number on the simulation job instance to use as a remote connection point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobPort(Integer jobPort);

        /**
         * <p>
         * The port number on the application.
         * </p>
         * 
         * @param applicationPort
         *        The port number on the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationPort(Integer applicationPort);

        /**
         * <p>
         * A Boolean indicating whether to enable this port mapping on public IP.
         * </p>
         * 
         * @param enableOnPublicIp
         *        A Boolean indicating whether to enable this port mapping on public IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableOnPublicIp(Boolean enableOnPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private Integer jobPort;

        private Integer applicationPort;

        private Boolean enableOnPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(PortMapping model) {
            jobPort(model.jobPort);
            applicationPort(model.applicationPort);
            enableOnPublicIp(model.enableOnPublicIp);
        }

        public final Integer getJobPort() {
            return jobPort;
        }

        public final void setJobPort(Integer jobPort) {
            this.jobPort = jobPort;
        }

        @Override
        public final Builder jobPort(Integer jobPort) {
            this.jobPort = jobPort;
            return this;
        }

        public final Integer getApplicationPort() {
            return applicationPort;
        }

        public final void setApplicationPort(Integer applicationPort) {
            this.applicationPort = applicationPort;
        }

        @Override
        public final Builder applicationPort(Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        public final Boolean getEnableOnPublicIp() {
            return enableOnPublicIp;
        }

        public final void setEnableOnPublicIp(Boolean enableOnPublicIp) {
            this.enableOnPublicIp = enableOnPublicIp;
        }

        @Override
        public final Builder enableOnPublicIp(Boolean enableOnPublicIp) {
            this.enableOnPublicIp = enableOnPublicIp;
            return this;
        }

        @Override
        public PortMapping build() {
            return new PortMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
