/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a world generator job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorldGenerationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorldGenerationJobSummary.Builder, WorldGenerationJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(WorldGenerationJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(WorldGenerationJobSummary::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(WorldGenerationJobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorldGenerationJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.<WorldCount> builder(MarshallingType.SDK_POJO)
            .memberName("worldCount").getter(getter(WorldGenerationJobSummary::worldCount)).setter(setter(Builder::worldCount))
            .constructor(WorldCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()).build();

    private static final SdkField<Integer> SUCCEEDED_WORLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("succeededWorldCount").getter(getter(WorldGenerationJobSummary::succeededWorldCount))
            .setter(setter(Builder::succeededWorldCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededWorldCount").build())
            .build();

    private static final SdkField<Integer> FAILED_WORLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedWorldCount").getter(getter(WorldGenerationJobSummary::failedWorldCount))
            .setter(setter(Builder::failedWorldCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedWorldCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TEMPLATE_FIELD,
            CREATED_AT_FIELD, STATUS_FIELD, WORLD_COUNT_FIELD, SUCCEEDED_WORLD_COUNT_FIELD, FAILED_WORLD_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String template;

    private final Instant createdAt;

    private final String status;

    private final WorldCount worldCount;

    private final Integer succeededWorldCount;

    private final Integer failedWorldCount;

    private WorldGenerationJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.template = builder.template;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.worldCount = builder.worldCount;
        this.succeededWorldCount = builder.succeededWorldCount;
        this.failedWorldCount = builder.failedWorldCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the world generator job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the world generator job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world template.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world template.
     */
    public final String template() {
        return template;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world generator job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world generator job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the world generator job:
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world generator job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world generator job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world generator job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world generator job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>PartialFailed</dt>
     * <dd>
     * <p>
     * Some worlds did not generate.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world generator job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world generator job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world generator job:</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world generator job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world generator job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world generator job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world generator job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>PartialFailed</dt>
     *         <dd>
     *         <p>
     *         Some worlds did not generate.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world generator job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world generator job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobStatus
     */
    public final WorldGenerationJobStatus status() {
        return WorldGenerationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the world generator job:
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world generator job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world generator job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world generator job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world generator job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>PartialFailed</dt>
     * <dd>
     * <p>
     * Some worlds did not generate.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world generator job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world generator job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world generator job:</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world generator job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world generator job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world generator job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world generator job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>PartialFailed</dt>
     *         <dd>
     *         <p>
     *         Some worlds did not generate.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world generator job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world generator job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Information about the world count.
     * </p>
     * 
     * @return Information about the world count.
     */
    public final WorldCount worldCount() {
        return worldCount;
    }

    /**
     * <p>
     * The number of worlds that were generated.
     * </p>
     * 
     * @return The number of worlds that were generated.
     */
    public final Integer succeededWorldCount() {
        return succeededWorldCount;
    }

    /**
     * <p>
     * The number of worlds that failed.
     * </p>
     * 
     * @return The number of worlds that failed.
     */
    public final Integer failedWorldCount() {
        return failedWorldCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(succeededWorldCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedWorldCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldGenerationJobSummary)) {
            return false;
        }
        WorldGenerationJobSummary other = (WorldGenerationJobSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(template(), other.template())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(worldCount(), other.worldCount())
                && Objects.equals(succeededWorldCount(), other.succeededWorldCount())
                && Objects.equals(failedWorldCount(), other.failedWorldCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorldGenerationJobSummary").add("Arn", arn()).add("Template", template())
                .add("CreatedAt", createdAt()).add("Status", statusAsString()).add("WorldCount", worldCount())
                .add("SucceededWorldCount", succeededWorldCount()).add("FailedWorldCount", failedWorldCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "worldCount":
            return Optional.ofNullable(clazz.cast(worldCount()));
        case "succeededWorldCount":
            return Optional.ofNullable(clazz.cast(succeededWorldCount()));
        case "failedWorldCount":
            return Optional.ofNullable(clazz.cast(failedWorldCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("template", TEMPLATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("worldCount", WORLD_COUNT_FIELD);
        map.put("succeededWorldCount", SUCCEEDED_WORLD_COUNT_FIELD);
        map.put("failedWorldCount", FAILED_WORLD_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorldGenerationJobSummary, T> g) {
        return obj -> g.apply((WorldGenerationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorldGenerationJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the world generator job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the world generator job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (arn) of the world template.
         * </p>
         * 
         * @param template
         *        The Amazon Resource Name (arn) of the world template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world generator job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world generator job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the world generator job:
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world generator job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world generator job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world generator job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world generator job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>PartialFailed</dt>
         * <dd>
         * <p>
         * Some worlds did not generate.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world generator job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world generator job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world generator job:</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world generator job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world generator job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world generator job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world generator job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>PartialFailed</dt>
         *        <dd>
         *        <p>
         *        Some worlds did not generate.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world generator job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world generator job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the world generator job:
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world generator job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world generator job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world generator job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world generator job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>PartialFailed</dt>
         * <dd>
         * <p>
         * Some worlds did not generate.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world generator job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world generator job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world generator job:</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world generator job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world generator job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world generator job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world generator job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>PartialFailed</dt>
         *        <dd>
         *        <p>
         *        Some worlds did not generate.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world generator job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world generator job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobStatus
         */
        Builder status(WorldGenerationJobStatus status);

        /**
         * <p>
         * Information about the world count.
         * </p>
         * 
         * @param worldCount
         *        Information about the world count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldCount(WorldCount worldCount);

        /**
         * <p>
         * Information about the world count.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorldCount.Builder} avoiding the need to
         * create one manually via {@link WorldCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorldCount.Builder#build()} is called immediately and its result
         * is passed to {@link #worldCount(WorldCount)}.
         * 
         * @param worldCount
         *        a consumer that will call methods on {@link WorldCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worldCount(WorldCount)
         */
        default Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return worldCount(WorldCount.builder().applyMutation(worldCount).build());
        }

        /**
         * <p>
         * The number of worlds that were generated.
         * </p>
         * 
         * @param succeededWorldCount
         *        The number of worlds that were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededWorldCount(Integer succeededWorldCount);

        /**
         * <p>
         * The number of worlds that failed.
         * </p>
         * 
         * @param failedWorldCount
         *        The number of worlds that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedWorldCount(Integer failedWorldCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String template;

        private Instant createdAt;

        private String status;

        private WorldCount worldCount;

        private Integer succeededWorldCount;

        private Integer failedWorldCount;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldGenerationJobSummary model) {
            arn(model.arn);
            template(model.template);
            createdAt(model.createdAt);
            status(model.status);
            worldCount(model.worldCount);
            succeededWorldCount(model.succeededWorldCount);
            failedWorldCount(model.failedWorldCount);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final WorldCount.Builder getWorldCount() {
            return worldCount != null ? worldCount.toBuilder() : null;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final Integer getSucceededWorldCount() {
            return succeededWorldCount;
        }

        public final void setSucceededWorldCount(Integer succeededWorldCount) {
            this.succeededWorldCount = succeededWorldCount;
        }

        @Override
        public final Builder succeededWorldCount(Integer succeededWorldCount) {
            this.succeededWorldCount = succeededWorldCount;
            return this;
        }

        public final Integer getFailedWorldCount() {
            return failedWorldCount;
        }

        public final void setFailedWorldCount(Integer failedWorldCount) {
            this.failedWorldCount = failedWorldCount;
        }

        @Override
        public final Builder failedWorldCount(Integer failedWorldCount) {
            this.failedWorldCount = failedWorldCount;
            return this;
        }

        @Override
        public WorldGenerationJobSummary build() {
            return new WorldGenerationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
