/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.WorldCount;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorldGenerationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorldGenerationJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::arn)).setter(WorldGenerationJobSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::template)).setter(WorldGenerationJobSummary.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::createdAt)).setter(WorldGenerationJobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::statusAsString)).setter(WorldGenerationJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("worldCount").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::worldCount)).setter(WorldGenerationJobSummary.setter(Builder::worldCount)).constructor(WorldCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()}).build();
    private static final SdkField<Integer> SUCCEEDED_WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("succeededWorldCount").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::succeededWorldCount)).setter(WorldGenerationJobSummary.setter(Builder::succeededWorldCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededWorldCount").build()}).build();
    private static final SdkField<Integer> FAILED_WORLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failedWorldCount").getter(WorldGenerationJobSummary.getter(WorldGenerationJobSummary::failedWorldCount)).setter(WorldGenerationJobSummary.setter(Builder::failedWorldCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedWorldCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TEMPLATE_FIELD, CREATED_AT_FIELD, STATUS_FIELD, WORLD_COUNT_FIELD, SUCCEEDED_WORLD_COUNT_FIELD, FAILED_WORLD_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorldGenerationJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String template;
    private final Instant createdAt;
    private final String status;
    private final WorldCount worldCount;
    private final Integer succeededWorldCount;
    private final Integer failedWorldCount;

    private WorldGenerationJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.template = builder.template;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.worldCount = builder.worldCount;
        this.succeededWorldCount = builder.succeededWorldCount;
        this.failedWorldCount = builder.failedWorldCount;
    }

    public final String arn() {
        return this.arn;
    }

    public final String template() {
        return this.template;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final WorldGenerationJobStatus status() {
        return WorldGenerationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final WorldCount worldCount() {
        return this.worldCount;
    }

    public final Integer succeededWorldCount() {
        return this.succeededWorldCount;
    }

    public final Integer failedWorldCount() {
        return this.failedWorldCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.succeededWorldCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedWorldCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldGenerationJobSummary)) {
            return false;
        }
        WorldGenerationJobSummary other = (WorldGenerationJobSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.worldCount(), other.worldCount()) && Objects.equals(this.succeededWorldCount(), other.succeededWorldCount()) && Objects.equals(this.failedWorldCount(), other.failedWorldCount());
    }

    public final String toString() {
        return ToString.builder((String)"WorldGenerationJobSummary").add("Arn", (Object)this.arn()).add("Template", (Object)this.template()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("WorldCount", (Object)this.worldCount()).add("SucceededWorldCount", (Object)this.succeededWorldCount()).add("FailedWorldCount", (Object)this.failedWorldCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "worldCount": {
                return Optional.ofNullable(clazz.cast(this.worldCount()));
            }
            case "succeededWorldCount": {
                return Optional.ofNullable(clazz.cast(this.succeededWorldCount()));
            }
            case "failedWorldCount": {
                return Optional.ofNullable(clazz.cast(this.failedWorldCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("template", TEMPLATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("worldCount", WORLD_COUNT_FIELD);
        map.put("succeededWorldCount", SUCCEEDED_WORLD_COUNT_FIELD);
        map.put("failedWorldCount", FAILED_WORLD_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorldGenerationJobSummary, T> g) {
        return obj -> g.apply((WorldGenerationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String template;
        private Instant createdAt;
        private String status;
        private WorldCount worldCount;
        private Integer succeededWorldCount;
        private Integer failedWorldCount;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldGenerationJobSummary model) {
            this.arn(model.arn);
            this.template(model.template);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.worldCount(model.worldCount);
            this.succeededWorldCount(model.succeededWorldCount);
            this.failedWorldCount(model.failedWorldCount);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTemplate() {
            return this.template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final WorldCount.Builder getWorldCount() {
            return this.worldCount != null ? this.worldCount.toBuilder() : null;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final Integer getSucceededWorldCount() {
            return this.succeededWorldCount;
        }

        public final void setSucceededWorldCount(Integer succeededWorldCount) {
            this.succeededWorldCount = succeededWorldCount;
        }

        @Override
        public final Builder succeededWorldCount(Integer succeededWorldCount) {
            this.succeededWorldCount = succeededWorldCount;
            return this;
        }

        public final Integer getFailedWorldCount() {
            return this.failedWorldCount;
        }

        public final void setFailedWorldCount(Integer failedWorldCount) {
            this.failedWorldCount = failedWorldCount;
        }

        @Override
        public final Builder failedWorldCount(Integer failedWorldCount) {
            this.failedWorldCount = failedWorldCount;
            return this;
        }

        public WorldGenerationJobSummary build() {
            return new WorldGenerationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorldGenerationJobSummary> {
        public Builder arn(String var1);

        public Builder template(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(WorldGenerationJobStatus var1);

        public Builder worldCount(WorldCount var1);

        default public Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return this.worldCount((WorldCount)((WorldCount.Builder)WorldCount.builder().applyMutation(worldCount)).build());
        }

        public Builder succeededWorldCount(Integer var1);

        public Builder failedWorldCount(Integer var1);
    }
}

