/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCrlsResponse extends RolesAnywhereResponse implements
        ToCopyableBuilder<ListCrlsResponse.Builder, ListCrlsResponse> {
    private static final SdkField<List<CrlDetail>> CRLS_FIELD = SdkField
            .<List<CrlDetail>> builder(MarshallingType.LIST)
            .memberName("crls")
            .getter(getter(ListCrlsResponse::crls))
            .setter(setter(Builder::crls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrlDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrlDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCrlsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRLS_FIELD, NEXT_TOKEN_FIELD));

    private final List<CrlDetail> crls;

    private final String nextToken;

    private ListCrlsResponse(BuilderImpl builder) {
        super(builder);
        this.crls = builder.crls;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Crls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCrls() {
        return crls != null && !(crls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of certificate revocation lists (CRL).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrls} method.
     * </p>
     * 
     * @return A list of certificate revocation lists (CRL).
     */
    public final List<CrlDetail> crls() {
        return crls;
    }

    /**
     * <p>
     * A token that indicates where the output should continue from, if a previous operation did not show all results.
     * To get the next results, call the operation again with this value.
     * </p>
     * 
     * @return A token that indicates where the output should continue from, if a previous operation did not show all
     *         results. To get the next results, call the operation again with this value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrls() ? crls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrlsResponse)) {
            return false;
        }
        ListCrlsResponse other = (ListCrlsResponse) obj;
        return hasCrls() == other.hasCrls() && Objects.equals(crls(), other.crls())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCrlsResponse").add("Crls", hasCrls() ? crls() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crls":
            return Optional.ofNullable(clazz.cast(crls()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCrlsResponse, T> g) {
        return obj -> g.apply((ListCrlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RolesAnywhereResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCrlsResponse> {
        /**
         * <p>
         * A list of certificate revocation lists (CRL).
         * </p>
         * 
         * @param crls
         *        A list of certificate revocation lists (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crls(Collection<CrlDetail> crls);

        /**
         * <p>
         * A list of certificate revocation lists (CRL).
         * </p>
         * 
         * @param crls
         *        A list of certificate revocation lists (CRL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crls(CrlDetail... crls);

        /**
         * <p>
         * A list of certificate revocation lists (CRL).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rolesanywhere.model.CrlDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rolesanywhere.model.CrlDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rolesanywhere.model.CrlDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #crls(List<CrlDetail>)}.
         * 
         * @param crls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rolesanywhere.model.CrlDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crls(java.util.Collection<CrlDetail>)
         */
        Builder crls(Consumer<CrlDetail.Builder>... crls);

        /**
         * <p>
         * A token that indicates where the output should continue from, if a previous operation did not show all
         * results. To get the next results, call the operation again with this value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where the output should continue from, if a previous operation did not show all
         *        results. To get the next results, call the operation again with this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RolesAnywhereResponse.BuilderImpl implements Builder {
        private List<CrlDetail> crls = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrlsResponse model) {
            super(model);
            crls(model.crls);
            nextToken(model.nextToken);
        }

        public final List<CrlDetail.Builder> getCrls() {
            List<CrlDetail.Builder> result = CrlDetailsCopier.copyToBuilder(this.crls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrls(Collection<CrlDetail.BuilderImpl> crls) {
            this.crls = CrlDetailsCopier.copyFromBuilder(crls);
        }

        @Override
        public final Builder crls(Collection<CrlDetail> crls) {
            this.crls = CrlDetailsCopier.copy(crls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crls(CrlDetail... crls) {
            crls(Arrays.asList(crls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crls(Consumer<CrlDetail.Builder>... crls) {
            crls(Stream.of(crls).map(c -> CrlDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrlsResponse build() {
            return new ListCrlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
