/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.CrlDetail;
import software.amazon.awssdk.services.rolesanywhere.model.CrlDetailsCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCrlsResponse
extends RolesAnywhereResponse
implements ToCopyableBuilder<Builder, ListCrlsResponse> {
    private static final SdkField<List<CrlDetail>> CRLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crls").getter(ListCrlsResponse.getter(ListCrlsResponse::crls)).setter(ListCrlsResponse.setter(Builder::crls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrlDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCrlsResponse.getter(ListCrlsResponse::nextToken)).setter(ListCrlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CrlDetail> crls;
    private final String nextToken;

    private ListCrlsResponse(BuilderImpl builder) {
        super(builder);
        this.crls = builder.crls;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCrls() {
        return this.crls != null && !(this.crls instanceof SdkAutoConstructList);
    }

    public final List<CrlDetail> crls() {
        return this.crls;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrls() ? this.crls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrlsResponse)) {
            return false;
        }
        ListCrlsResponse other = (ListCrlsResponse)((Object)obj);
        return this.hasCrls() == other.hasCrls() && Objects.equals(this.crls(), other.crls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCrlsResponse").add("Crls", this.hasCrls() ? this.crls() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crls": {
                return Optional.ofNullable(clazz.cast(this.crls()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCrlsResponse, T> g) {
        return obj -> g.apply((ListCrlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereResponse.BuilderImpl
    implements Builder {
        private List<CrlDetail> crls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrlsResponse model) {
            super(model);
            this.crls(model.crls);
            this.nextToken(model.nextToken);
        }

        public final List<CrlDetail.Builder> getCrls() {
            List<CrlDetail.Builder> result = CrlDetailsCopier.copyToBuilder(this.crls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrls(Collection<CrlDetail.BuilderImpl> crls) {
            this.crls = CrlDetailsCopier.copyFromBuilder(crls);
        }

        @Override
        public final Builder crls(Collection<CrlDetail> crls) {
            this.crls = CrlDetailsCopier.copy(crls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crls(CrlDetail ... crls) {
            this.crls(Arrays.asList(crls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crls(Consumer<CrlDetail.Builder> ... crls) {
            this.crls(Stream.of(crls).map(c -> (CrlDetail)((CrlDetail.Builder)CrlDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrlsResponse build() {
            return new ListCrlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RolesAnywhereResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCrlsResponse> {
        public Builder crls(Collection<CrlDetail> var1);

        public Builder crls(CrlDetail ... var1);

        public Builder crls(Consumer<CrlDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

